import numpy as np
import numpy.linalg as nl
from sklearn.cluster import KMeans
from scipy.sparse import identity

def spl_clustering(A, n_clusters):
    '''
    Perform normalized spectral clustering given affinity matrix and number of clusters
    Return index
    '''
    N = A.shape[0]
    # Compute graph Laplacian L_sym = I-D^(-1/2)AD^(-1/2)
    # DD = D^(-1/2)
    eps = np.finfo(float).eps
    DD = np.asmatrix(np.diag(1./np.sqrt(np.sum(A, axis=0)+eps)))
    L = np.asarray(identity(N)-DD*np.asmatrix(A)*DD)
    # Compute first n_clusters eigenvectors
    eigVal, eigVec=nl.eigh(L)
    sortIndex=np.argsort(eigVal)
    eigQ=eigVec[:, sortIndex[0:n_clusters:]]
    # Normalize rows to norm 1
    T = eigQ/np.reshape(nl.norm(eigQ, ord=2, axis=1),(N,1))
    # K-means
    kmeans = KMeans(n_clusters=n_clusters)
    index=kmeans.fit_predict(T)
    return index

    