import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import os

def show_img(index, index_dict, sp_labels, n_clusters, imgList,foreground, frameStartEnd, root, imgName,  cmap = 'rainbow', ifOnOriginal = False):
    '''
    Given an index, draw and save clustered results.
    '''
    rowNumb, colNumb, frameNumb = sp_labels.shape
    if frameStartEnd!=[]:
        imgFileIndices = np.arange(frameStartEnd[0],frameStartEnd[1])
    else:
        imgFileIndices = np.arange(0,len(imgList))
    frameNumb = len(imgList)
    imgClustered = np.zeros((rowNumb, colNumb, frameNumb))
    dirName = os.path.join(root,'results')
    if not os.path.exists(dirName):
        os.mkdir(dirName)
    for k in range(frameNumb):        
        for i in range(rowNumb):
            for j in range(colNumb):
                TSP_label = sp_labels[i, j, k]
                imgClustered[i, j, k] = index[index_dict[TSP_label]]
    if ifOnOriginal==False:
        for k in range(frameNumb):
            plt.matshow(imgClustered[:, :, k], cmap=cmap)
            matplotlib.image.imsave(os.path.join(dirName,imgName+'_'+np.str(imgFileIndices[k])+'.png'), imgClustered[:, :, k], cmap = cmap)
    else:
        for f in range(frameNumb):
            temp = imgList[f]*(np.reshape(imgClustered[:,:,f],(rowNumb, colNumb, 1))==foreground)
            plt.imshow(temp)
            matplotlib.image.imsave(os.path.join(dirName,imgName+'_'+np.str(imgFileIndices[f])+'.png'), temp)
