import os
from skimage import io
from skimage.util import random_noise
import numpy as np
import matplotlib
import matplotlib.pyplot as plt

def read_img(root, suffix, frameNumb=[], noise=False, var=0.01,showImg = False):
    ''' load images '''
    imgList = []   
    if noise == True: # If noise is added, save images for further use
        dirName = os.path.join(root,'corrupted')
        if not os.path.exists(dirName):
            os.mkdir(dirName)
    for f in os.listdir(root):
        if f.endswith(suffix):
            frameIndex = int(f[6:-4])
            if frameNumb==[]:
                frameNumb = [0,np.inf] # load all frames
            if frameIndex < frameNumb[1] and frameIndex >= frameNumb[0]:
                img = io.imread(os.path.join(root, f))
                if noise == True:
                    img = np.rint(random_noise(img, mode='gaussian', var=var)*np.array([255,255,255], dtype=int))
                    img = img.astype(np.uint8)
                    matplotlib.image.imsave(os.path.join(dirName,'frame'+'_'+np.str(frameIndex)+'.png'), img)
                imgList.append(img)
    if showImg == True:
        plt.imshow(imgList[0])
        print 'Image loaded.'
    else:
        print 'Image loaded but not shown.\n'
    return imgList

