import numpy as np
import interpolate
import cv2
from label_projection import label_projection
from color_descriptor import color_descriptor

def pre_processing(imgList, sp_labels, frameStartEnd=[], extra_dim=False, signature = [1,3,5]):
    '''
    Given images and labels, 
    compute for each TSP its appearance and motion features 
    and form the data matrix.
    '''
    if extra_dim == False:
        maxDim = 2
    else:
        maxDim = 3
    binSize = 7
    # Total number of TSPs
    TSPNumb = np.max(sp_labels)-np.min(sp_labels)+1
    rowNumb, colNumb, dim = imgList[0].shape
    if frameStartEnd!=[]:
        frameNumb = frameStartEnd[1] - frameStartEnd[0]
    else:
        frameNumb = len(imgList)
    appearance = [None]*TSPNumb
    appearanceFeature = np.ones((binSize*3, TSPNumb))*(-1.)
    TSP_counter = []    # stock the number of pixels belonging to each TSP
    motion_original = np.zeros((3, frameNumb, TSPNumb))
    motionFeature = np.ones((maxDim*frameNumb, TSPNumb))
    

    # Initialize appearanceFeature
    for i in range(TSPNumb):
        appearance[i] = []
        
    # change RGB to HSV color space
    imgList_HSV = []
    for f in range(frameNumb):
        imgList_HSV.append(cv2.cvtColor(imgList[f], cv2.COLOR_RGB2HSV))
        
    for f in range(frameNumb):
        for i in range(rowNumb):
                for j in range(colNumb):
                        appearance[sp_labels[i, j, f]].append(imgList_HSV[f][i, j, :])
                            
    
    # Turn list into array
    for i in range(TSPNumb):
        if appearance[i] != []:
            appearanceFeature[:, i] = color_descriptor(np.array(appearance[i]), binSize = binSize)
            TSP_counter.append(len(appearance[i]))
    del appearance
    
    # Initialize motionFeature      
    for f in range(frameNumb): 
        for i in range(rowNumb):
            for j in range(colNumb):
                # ith row jth col <=> position(j, x)
                motion_original[0, f, sp_labels[i, j, f]] += j
                motion_original[1, f, sp_labels[i, j, f]] += i
                motion_original[2, f, sp_labels[i, j, f]] += 1  # count
    
    # delete non-existing TSPs in appearanceFeature and motionFeature
    index_invalid = np.where(appearanceFeature==-1)
    appearanceFeature = np.delete(appearanceFeature, index_invalid[1], axis = 1)
    motion_original = np.delete(motion_original, index_invalid[1], axis = 2)
    # Compute mean position of each TSP
    motion_original /= motion_original[2, :, :]
    motion_original = np.nan_to_num(motion_original)
    # Interpolate motion feature matrix
    motion_original = interpolate.interpolate(motion_original, signature, 0)
    # transform to motion feature matrix
    motionFeature = np.reshape(motion_original[0:maxDim, :, :], (maxDim*frameNumb, motion_original.shape[2]), order = 'F') 
    # Label projection to take into consideration missing TSP labels
    index_dict = label_projection(sp_labels, index_invalid)
    return appearanceFeature, motionFeature, index_dict
