import numpy as np


def interpolate(mat, signature=[1,2,3],invalid_numb = 0):
    '''
    interpolate motion trajectories of disappearing TSPs
    For the remaining incomplete trajectories, we simply fill the empty
    entries by copying their nearest non-empty entry in the corresponding column.
    Fill the extra dimention by corresponding signatures.
    '''
    TSPNumb = mat.shape[2]
    frameNumb = mat.shape[1]
    for i in range(TSPNumb):
        index_min, index_max = np.min(np.where(mat[2,:, i]!=invalid_numb)), np.max(np.where(mat[2,:,i]!=invalid_numb))
        if index_min > 0:
            mat[0,0:index_min,i]=mat[0,index_min,i]
            mat[1,0:index_min,i]=mat[1,index_min,i]
            mat[2,0:index_min,i]=signature[1]
        if index_max < frameNumb:
            mat[0,index_max+1:,i]=mat[0,index_max,i]   
            mat[1,index_max+1:,i]=mat[1,index_max,i]           
            mat[2,index_max+1:,i]=signature[2]
    return mat

            