import os
import numpy as np
import matplotlib.pyplot as plt
import show_img
import pre_processing
from read_mat import read_mat
from read_img import read_img
from SSSC_AMF import SSSC_AMF

plt.close('all')

# hyperparameters
var = 0.25
extraDim = True 
n_clusters = 10
alpha = 800
beta = 1e-5
rho = 1.2
signature = [1,3,5]

# Video-related setting
videoNames = ["chickenNew","chicken_on_turtle"]
work_dir = '/Users/Junlin/Documents/PRL/Data'
frameNumb = [[0,20]]*len(videoNames)
videoNumber = len(videoNames)
matNames = []
mat_contents = []
sp_labels = []
myPath = []
imgList = []
appearanceList = []
motionList = []
index_dict = []
tspNumber = np.zeros((videoNumber,1),dtype=np.int);

# Load and preprocess video sequences
for i in range(videoNumber):  
    # load mat files under Python
    matNames.append('sp_labels_'+videoNames[i]+'.mat')
    mat_contents.append(read_mat(matNames[i], work_dir))
    # assign label matrix to numpy array
    sp_labels.append(mat_contents[i]['sp_labels'])
    # load images
    myPath.append(os.path.join(work_dir,videoNames[i]))
    imgList.append(read_img(myPath[i], '.png', frameNumb[i], noise=False, showImg = True))
    sp_labels_temp = sp_labels[i]
    sp_labels[i] = sp_labels_temp - np.min(sp_labels_temp)
    # form data matrix, each column is a data point
    print 'Building data matrix...\n'
    appearanceFeature_temp, motionFeature_temp, index_dict_temp = pre_processing.pre_processing(imgList[i], sp_labels[i], frameStartEnd=frameNumb[i], extra_dim=extraDim, signature=signature)
    appearanceList.append(appearanceFeature_temp)
    motionList.append(motionFeature_temp)
    index_dict.append(index_dict_temp)
    print 'Done!\n'
    tspNumber[i,0] = appearanceFeature_temp.shape[1]

# concatenate data matrices
appearanceFeature = np.zeros((appearanceList[0].shape[0], np.sum(tspNumber,dtype=np.int))) # appearance feature
rowNumber = 0
for i in range(videoNumber):
    rowNumber += motionList[i].shape[0]
motionFeature = np.zeros((rowNumber, np.sum(tspNumber,dtype=np.int))) # motion feature
startCol = 0
endCol = 0
startRow = 0
endRow = 0
for i in range(videoNumber):
    endCol = startCol+tspNumber[i,0]
    endRow = startRow+motionList[i].shape[0]
    appearanceFeature[:,startCol:endCol] = appearanceList[i]
    # motion feature, block matrix
    motionFeature[startRow:endRow,startCol:endCol] = motionList[i]
    startCol = endCol
    startRow = endRow

# conduct subspace clustering
X = [appearanceFeature, motionFeature]
labels_pred_sssc = SSSC_AMF(X, alpha, beta, rho, n_clusters, signature)

# show clustering results
print 'Showing clustering results...\n'

start = 0
end = 0
for i in range(videoNumber):
    end = start+tspNumber[i]
    show_img.show_img(labels_pred_sssc[start:end], index_dict[i], sp_labels[i], n_clusters, imgList[i], 0, frameNumb[i], myPath[i], videoNames[i], 'rainbow', False)
    start = end


