import numpy as np

def color_descriptor(mat,binSize = 4):
    '''
    Compute HSV color descriptor of a 2D matrix.
    '''
    
    # Calculate histogram
    hist = np.zeros(binSize*3)
    
    # Calculate and plot histogram
    histSize = [binSize, binSize, binSize]
    upperBound = [180, 256, 256]
    start = 0
    end = 0
    
    for i in range(3):
        start = end
        end += histSize[i]
        hist[start:end] = np.histogram(mat[:, i], bins = histSize[i], range = [0, upperBound[i]])[0]
        hist[start:end] = hist[start:end]*1./mat.shape[0]
    
    return hist
