import numpy as np
from SSSC import SSSC
from spl_clustering import spl_clustering

def SSSC_AMF(X, alpha=800, beta=10e-5, rho=1.2, n_clusters=10, signature=[1,3,5], maxIter=1): 
    '''
    Perform SSSC-AMF algorithm to obtain labels
    '''
    print 'Performing SSSC algorithm...\n'
    Z = SSSC(X, alpha, beta, rho, n_clusters, maxIter)
    K = len(Z)
    N = Z[0].shape[0]
    Z_2_summed = np.zeros((N, N))
    A = np.zeros((N, N))
    for k in range(K):
        Z_2_summed += Z[k]*Z[k]
    # affinity matrix
    A = 0.5*(np.sqrt(Z_2_summed)+np.sqrt(Z_2_summed.T))
    # Unified spectral clustering
    labels_pred_sssc = spl_clustering(A, n_clusters)
    return labels_pred_sssc
    
    