# smartgrid lines monitoring (.mod file)
#   this version does not account for what device covers which line
#   the if_covered constraint is wrong

## sets and parameters
# set of buses
set V;
# type of bus: 0=generator, 1=consumer, 2=repeater (also reads V from .dat)
param bustype{V} symbolic;

# set of lines
set E within {V,V};
# line weight (also reads E from .dat)
param w{E};
# set of pairs of antiparallel arcs
set A := E union {u in V, v in V : (v,u) in E};

# set of monitoring devices
set D ordered;
# cost of monitoring device
param devcost{D};

# star sizes
param starsize{u in V} := card({v in V : (u,v) in A});

## decision variables

# assignment of device to bus
var x{D,V} binary;

# whether a line is monitored
var y{A} binary;

## objective function
minimize total_cost: sum{d in D} devcost[d] * sum{v in V} x[d,v];

## constraints

# device types
subject to consumer_repeater{v in V : bustype[v] == "gen"}: x["devB", v] == 0;
subject to generator{v in V : bustype[v] in {"con", "rep"}}: x["devC", v] == 0;
subject to repeater{v in V : bustype[v] in {"gen", "con"}}: x["devD", v] == 0;
subject to consumer{v in V : bustype[v] in {"gen", "rep"}}: x["devE", v] == 0;

# at most one device at each node
subject to assignment{v in V} : sum{d in D} x[d,v] <= 1;

# line monitoring
subject to devA_cover{u in V}:
  sum{v in V : (u,v) in A} y[u,v] >= starsize[u] * x["devA", u];

subject to devB_cover{u in V}:
  sum{v in V : (u,v) in A} y[u,v] >=
    (if starsize[u] == 1 then 1 else 2) * x["devB", u];
  
subject to other_cover{d in {"devC", "devD", "devE"}, u in V}:
  sum{v in V : (u,v) in A} y[u,v] >= x[d, u];

# cover all lines
subject to if_covered{(u,v) in A}: (sum{d in D} x[d,u]) + (sum{e in D} x[e,v]) >= y[u,v];

subject to all_covered{(u,v) in E}: y[u,v] + y[v,u] >= 1;


