### COMPLETE THIS "EMPTY SHELL" OF THE .mod FILE FOR line_monitor.mod

# smartgrid lines monitoring (.mod file)

## sets and parameters
# set of buses
set V;
# type of bus: 0=generator, 1=consumer, 2=repeater (also reads V from .dat)
param bustype{V} symbolic;

# set of lines
set E within {V,V};
# line weight (also reads E from .dat)
param w{E};
# set of pairs of antiparallel arcs
set A := E union {u in V, v in V : (v,u) in E};

# set of monitoring devices
set D ordered;
# cost of monitoring device
param devcost{D};
# set of multiple-covering devices (assumes they are the first two in the set)
set DM := {member(1,D), member(2,D)};
# set of single-covering devices
set D1 := D diff DM;

# stars
set N{u in V} := {v in V : (u,v) in A};
param starsize{u in V} := card(N[u]);

## decision variables

# device at a bus (COMPLETE HERE)

# for d in D and (u,v) in A, v is covered by a device d installed at u (COMPLETE HERE)


## objective function (COMPLETE HERE)
 
## constraints (COMPLETE HERE)

# device types

# at most one device at each node

# devA: every node adjacent to installed node is covered

# devB: at most two nodes adjacent to installed node are covered

# devC, devD, devE: exactly one node adjacent to installed node is covered

# line is covered
