#!/usr/bin/env python

from __future__ import absolute_import
from __future__ import division, print_function, unicode_literals

import sys

from sumy.utils import get_stop_words
from sumy.nlp.tokenizers import Tokenizer
from sumy.parsers.html import HtmlParser
from sumy.parsers.plaintext import PlaintextParser
from sumy.summarizers.lsa import LsaSummarizer as Summarizer
from sumy.nlp.stemmers import Stemmer

LANGUAGE = "english"
SENTENCES_COUNT = 10

if len(sys.argv) >= 2:
    textname = sys.argv[1]
else:
    exit('need filename on cmd line')

parser = PlaintextParser.from_file(textname, Tokenizer(LANGUAGE))
stemmer = Stemmer(LANGUAGE)

summarizer = Summarizer(stemmer)
summarizer.stop_words = get_stop_words(LANGUAGE)

for sentence in summarizer(parser.document, SENTENCES_COUNT):
    print(sentence)
