# modularity.mod -- maximum modularity of a graph

# vertices
param n > 1;
set V := 1..n;

# is there an edge between i and j?
param a{V,V} default 0;

# degree sequence
param k{V} >= 0;

# edges
param m integer;

# constant term
param C;

# two vertices in the same class?
var x{V,V} binary;

# objective
maximize modularity: 
  (1/m) * sum{i in V, j in V : i < j} 
          (a[i,j] - (k[i]*k[j]/(2*m)))*x[i,j] - C;

# constraints
subject to clique1{i in V, j in V, h in V : i<j and j<h}: 
   x[i,j] + x[j,h] - x[i,h] <= 1;

subject to clique2{i in V, j in V, h in V : i<j and j<h}: 
   x[i,j] - x[j,h] + x[i,h] <= 1;

subject to clique3{i in V, j in V, h in V : i<j and j<h}: 
  -x[i,j] + x[j,h] + x[i,h] <= 1;

subject to x_symmetry{i in V, j in V} : x[i,j] = x[j,i];
subject to x_reflexive{i in V} : x[i,i] = 1;

