/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import sampl.ast.ArcAttr;
import sampl.ast.BasicAttr;
import sampl.ast.CoeffAttr;
import sampl.ast.ConstraintDecl;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.ObjectiveDecl;
import sampl.ast.SuffixAttr;
import sampl.ast.UnaryAttr;
import sampl.ast.VariableDecl;
import sampl.parser.Token;
import sampl.parser.TokenKind;
import sampl.sema.DeclSema;
import sampl.sema.Sema;
import sampl.types.MapType;
import sampl.types.Types;

final class VariableDeclSema
extends DeclSema {
    private VariableDecl decl;
    private boolean hasLower;
    private boolean hasUpper;
    private boolean hasInit;

    private boolean checkInitializer(Token op, Expr arg) {
        if (this.hasInit) {
            this.report(op, "Multiple initializers", new Object[0]);
            return false;
        }
        this.hasInit = true;
        return this.sema.expectConstArithmeticExpr(arg);
    }

    VariableDeclSema(Sema sema, int pos, String name, boolean arc) {
        super(sema);
        this.decl = new VariableDecl(pos, name, arc);
    }

    @Override
    boolean needsScenarioConversion() {
        return true;
    }

    @Override
    VariableDecl getDecl() {
        return this.decl;
    }

    @Override
    public void onIndexing(Indexing indexing) {
        if (!Sema.isValid(indexing)) {
            return;
        }
        this.checkScenarioIndex(indexing, false);
        this.decl.setIndexing(indexing);
        this.decl.setType(MapType.get(indexing.getDimension(), Types.VARIABLE));
    }

    @Override
    public void onBasicAttr(Token keyword) {
        BasicAttr.Kind kind;
        switch (keyword.getKind()) {
            case KW_binary: 
            case KW_logical: {
                kind = BasicAttr.Kind.BINARY;
                break;
            }
            case KW_integer: {
                kind = BasicAttr.Kind.INTEGER;
                break;
            }
            default: {
                this.reportInvalidAttr(keyword);
                return;
            }
        }
        this.decl.addAttr(new BasicAttr(keyword.getStartPosition(), kind));
    }

    @Override
    public void onUnaryAttr(Token op, Expr arg) {
        UnaryAttr.Kind kind;
        switch (op.getKind()) {
            case LESS_EQUAL: {
                if (this.hasUpper) {
                    this.report(op, "Multiple bounds", new Object[0]);
                    return;
                }
                this.hasUpper = true;
                if (!this.sema.expectConstArithmeticExpr(arg)) {
                    return;
                }
                kind = UnaryAttr.Kind.LE;
                break;
            }
            case EQUAL: 
            case EQUAL_EQUAL: {
                if (this.hasLower || this.hasUpper) {
                    this.report(op, "Multiple bounds", new Object[0]);
                    return;
                }
                this.hasUpper = true;
                this.hasLower = true;
                if (!this.sema.expectArithmeticExpr(arg)) {
                    return;
                }
                kind = UnaryAttr.Kind.EQ;
                break;
            }
            case GREATER_EQUAL: {
                if (this.hasLower) {
                    this.report(op, "Multiple bounds", new Object[0]);
                    return;
                }
                this.hasLower = true;
                if (!this.sema.expectConstArithmeticExpr(arg)) {
                    return;
                }
                kind = UnaryAttr.Kind.GE;
                break;
            }
            case COLON_EQUAL: {
                if (!this.checkInitializer(op, arg)) {
                    return;
                }
                kind = UnaryAttr.Kind.ASSIGN;
                break;
            }
            case KW_default: {
                if (!this.checkInitializer(op, arg)) {
                    return;
                }
                kind = UnaryAttr.Kind.DEFAULT;
                break;
            }
            case KW_in: {
                if (!this.expectSingleDimenSet(arg)) {
                    return;
                }
                kind = UnaryAttr.Kind.IN;
                break;
            }
            default: {
                this.reportInvalidAttr(op);
                return;
            }
        }
        this.decl.addAttr(new UnaryAttr(op.getStartPosition(), kind, arg));
    }

    @Override
    public void onSuffixAttr(int suffixKWPos, Token suffix, Expr expr) {
        SuffixAttr attr = this.handleSuffixAttr(suffixKWPos, suffix, expr);
        if (attr == null) {
            return;
        }
        if (!attr.getSuffix().supports(this.decl)) {
            this.report(suffix, "Suffix '%s' can't be applied to variable", suffix.getIdentifier());
            return;
        }
        this.decl.addAttr(attr);
    }

    @Override
    public void onArcAttr(Token keyword, Expr ref, Expr expr) {
        assert (keyword.is(TokenKind.KW_from) || keyword.is(TokenKind.KW_to));
        if (!this.decl.isArc()) {
            this.reportInvalidAttr(keyword);
            return;
        }
        ConstraintDecl conDecl = null;
        if (ref.getType() == Types.CONSTRAINT) {
            conDecl = (ConstraintDecl)ref.getTarget();
        }
        if (conDecl == null || !conDecl.isNode()) {
            this.sema.report(ref, "Expected node", new Object[0]);
            return;
        }
        if (expr != null && !this.sema.expectConstArithmeticExpr(expr)) {
            return;
        }
        this.decl.addAttr(new ArcAttr(keyword.getStartPosition(), keyword.is(TokenKind.KW_to), ref, expr));
    }

    @Override
    public void onCoeffAttr(Token keyword, Indexing indexing, Expr ref, Expr coeff) {
        CoeffAttr.Kind kind;
        if (keyword.is(TokenKind.KW_obj)) {
            if (ref.getType() != Types.OBJECTIVE) {
                this.sema.report(ref, "Expected objective", new Object[0]);
                return;
            }
            ObjectiveDecl objDecl = (ObjectiveDecl)ref.getTarget();
            if (objDecl.getExpr() != null && !objDecl.hasToCome()) {
                this.sema.report(ref, "'to_come' not specified for '%s'", objDecl.getName());
            }
            kind = CoeffAttr.Kind.OBJ;
        } else {
            ConstraintDecl conDecl;
            assert (keyword.is(TokenKind.KW_coeff) || keyword.is(TokenKind.KW_cover));
            ConstraintDecl constraintDecl = conDecl = ref.getType() == Types.CONSTRAINT ? (ConstraintDecl)ref.getTarget() : null;
            if (conDecl == null || conDecl.isNode()) {
                this.sema.report(ref, "Expected constraint", new Object[0]);
                return;
            }
            if (!conDecl.hasToCome()) {
                this.sema.report(ref, "'to_come' not specified for '%s'", conDecl.getName());
            }
            kind = CoeffAttr.Kind.COEFF;
        }
        if (coeff != null) {
            if (!this.sema.expectArithmeticExpr(coeff)) {
                return;
            }
            coeff.setType(Types.NUMERIC);
        }
        this.decl.addAttr(new CoeffAttr(keyword.getStartPosition(), kind, indexing, ref, coeff));
    }
}

