/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.ParenExpr;
import sampl.ast.SetLiteral;
import sampl.ast.TreeDecl;
import sampl.ast.UnaryAttr;
import sampl.parser.Token;
import sampl.sema.DeclSema;
import sampl.sema.Sema;
import sampl.types.Types;

final class TreeDeclSema
extends DeclSema {
    private TreeDecl decl;
    private boolean hasTreeAttr;

    private boolean checkSetOfNumbers(Expr expr) {
        if (!(expr instanceof SetLiteral) || expr.getDimension() != 1) {
            this.sema.report(expr, "Expected set of numeric expressions", new Object[0]);
            return false;
        }
        SetLiteral set = (SetLiteral)expr;
        for (Expr member : set.getMembers()) {
            if (member.getType() == Types.NUMERIC) continue;
            this.sema.report(member, "Type mismatch", new Object[0]);
            return false;
        }
        return true;
    }

    TreeDeclSema(Sema sema, int pos, String name) {
        super(sema);
        this.decl = new TreeDecl(pos, name);
    }

    @Override
    TreeDecl getDecl() {
        return this.decl;
    }

    @Override
    public void onIndexing(Indexing indexing) {
        this.sema.report(indexing, "Tree can't have indexing", new Object[0]);
    }

    @Override
    public void onUnaryAttr(Token op, Expr arg) {
        UnaryAttr.Kind kind;
        this.hasTreeAttr = true;
        switch (op.getKind()) {
            case KW_twostage: {
                if (arg != null && arg.getType() != Types.NUMERIC) {
                    this.sema.report(arg, "Type mismatch", new Object[0]);
                    return;
                }
                kind = UnaryAttr.Kind.TWOSTAGE;
                break;
            }
            case KW_nway: {
                if (arg.getType() != Types.NUMERIC) {
                    this.sema.report(arg, "Type mismatch", new Object[0]);
                    return;
                }
                kind = UnaryAttr.Kind.NWAY;
                break;
            }
            case KW_multibranch: {
                if (!this.checkSetOfNumbers(arg)) {
                    return;
                }
                kind = UnaryAttr.Kind.MULTIBRANCH;
                break;
            }
            case KW_tlist: {
                if (!this.checkSetOfNumbers(arg)) {
                    return;
                }
                kind = UnaryAttr.Kind.TLIST;
                break;
            }
            case KW_bundles: {
                if (!(arg instanceof SetLiteral) || arg.getDimension() != 2) {
                    this.sema.report(arg, "Expected set of pairs", new Object[0]);
                    return;
                }
                SetLiteral set = (SetLiteral)arg;
                for (Expr member : set.getMembers()) {
                    Expr first = ((ParenExpr)member).getItem(0);
                    if (first.getType() == Types.NUMERIC) continue;
                    this.sema.report(first, "Type mismatch", new Object[0]);
                    return;
                }
                kind = UnaryAttr.Kind.BUNDLES;
                break;
            }
            default: {
                this.hasTreeAttr = !this.decl.getAttrs().isEmpty();
                this.reportInvalidAttr(op);
                return;
            }
        }
        this.decl.addAttr(new UnaryAttr(op.getStartPosition(), kind, arg));
    }

    @Override
    public void onEndAttrs() {
        if (!this.hasTreeAttr) {
            this.sema.report(this.decl.getStart(), "Tree structure is not specified", new Object[0]);
        }
    }
}

