/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import java.util.List;
import sampl.ast.ColGroup;
import sampl.ast.Direction;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.Referable;
import sampl.ast.SetDecl;
import sampl.ast.TableDecl;
import sampl.parser.Token;
import sampl.sema.DeclSema;
import sampl.sema.Sema;
import sampl.types.MapType;
import sampl.types.Type;
import sampl.types.Types;

final class TableDeclSema
extends DeclSema {
    private TableDecl decl;

    TableDeclSema(Sema sema, int pos, String name) {
        super(sema);
        this.decl = new TableDecl(pos, name);
    }

    @Override
    TableDecl getDecl() {
        return this.decl;
    }

    @Override
    public void onIndexing(Indexing indexing) {
        if (!Sema.isValid(indexing)) {
            return;
        }
        this.decl.setIndexing(indexing);
    }

    @Override
    public void onTableBody(Token inout, List<Expr> strings, Expr keySet, Direction d, int lbracketPos, List<Expr> keyCols, int rbracketPos, Token keyInout, Expr inExpr, List<ColGroup> dataCols) {
        boolean hasSetNames;
        if (keyInout != null) {
            Direction inoutDir = this.sema.convertDirection(keyInout);
            if (d != null && d != inoutDir) {
                this.report(keyInout, "'%s' is inconsistent with '%s'", new Object[]{d, keyInout.getData()});
            }
            d = inoutDir;
        }
        if (keySet != null && !this.sema.expectSetExpr(keySet)) {
            this.hasErrors = true;
        }
        if (inExpr != null && !this.sema.expectSetExpr(inExpr)) {
            this.hasErrors = true;
        }
        boolean bl = hasSetNames = keySet != null;
        if (!hasSetNames && !keyCols.isEmpty()) {
            hasSetNames = true;
            for (Expr keyCol : keyCols) {
                Referable decl = keyCol.getTarget();
                if (!(decl instanceof SetDecl)) {
                    hasSetNames = false;
                    continue;
                }
                if (keyInout == null || ((SetDecl)decl).getDimension() == 1) continue;
                this.report(keyInout, "'%s' requires set of arity 1", keyInout.getData());
            }
        }
        this.decl.setKeySpec(keySet, d, keyCols, inExpr, hasSetNames);
        if (strings != null) {
            this.decl.setStrings(strings);
        }
        if (!(keySet != null || hasSetNames && keyInout != null || dataCols != null)) {
            this.hasErrors = true;
            this.sema.report(this.decl.getStart(), "Table has no set name and no parameter/variable names", new Object[0]);
            return;
        }
        if (dataCols != null) {
            this.decl.setDataCols(dataCols);
        }
        Indexing indexing = this.decl.getIndexing();
        Type type = Types.TABLE;
        if (indexing != null) {
            type = MapType.get(indexing.getDimension(), type);
        }
        this.decl.setType(type);
    }
}

