/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import java.util.List;
import sampl.Integrality;
import sampl.ast.Attr;
import sampl.ast.BasicAttr;
import sampl.ast.DistAttr;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.ParameterDecl;
import sampl.ast.UnaryAttr;
import sampl.parser.Token;
import sampl.parser.TokenKind;
import sampl.sema.DeclSema;
import sampl.sema.Sema;
import sampl.types.MapType;
import sampl.types.Type;
import sampl.types.Types;

final class ParameterDeclSema
extends DeclSema {
    private ParameterDecl decl;
    private Type itemType;
    private Integrality numericType;
    private boolean hasInitializer;
    private boolean hasDist;
    private boolean invalid;

    private void inferType(Type type, Attr attr) {
        if (this.itemType == null) {
            if (this.decl.isStochastic() && type == Types.SYMBOLIC) {
                this.sema.report(attr.getPosition(), "Stochastic parameter can't be symbolic", new Object[0]);
            }
            Indexing indexing = this.decl.getIndexing();
            this.itemType = type;
            if (indexing != null) {
                type = MapType.get(indexing.getDimension(), type);
            }
            this.decl.setType(type);
        } else if (this.itemType != type) {
            this.sema.report(attr.getPosition(), "Attribute is incompatible with inferred type", new Object[0]);
        }
    }

    private void onInitAttr(Token op, UnaryAttr.Kind kind, Expr arg) {
        if (this.hasInitializer) {
            this.report(op, "Multiple initializers", new Object[0]);
            return;
        }
        this.hasInitializer = true;
        UnaryAttr attr = new UnaryAttr(op.getStartPosition(), kind, arg);
        if (!Sema.isConstArithmetic(arg)) {
            if (arg.getType() == Types.STRING) {
                this.inferType(Types.SYMBOLIC, attr);
            } else {
                this.sema.report(arg, "Expected constant arithmetic or string expression", new Object[0]);
                return;
            }
        }
        this.decl.addAttr(attr);
    }

    private void onRelationAttr(Token op, UnaryAttr.Kind kind, Expr arg) {
        if (!this.sema.expectConstArithmeticExpr(arg)) {
            return;
        }
        UnaryAttr attr = new UnaryAttr(op.getStartPosition(), kind, arg);
        this.inferType(Types.NUMERIC, attr);
        this.decl.addAttr(attr);
    }

    private void onInAttr(Token op, UnaryAttr.Kind kind, Expr arg) {
        if (!this.expectSingleDimenSet(arg)) {
            return;
        }
        this.decl.addAttr(new UnaryAttr(op.getStartPosition(), kind, arg));
    }

    ParameterDeclSema(Sema sema, int pos, String name, ParameterDecl.Kind kind) {
        super(sema);
        this.decl = new ParameterDecl(pos, name, kind);
        this.numericType = Integrality.CONTINUOUS;
    }

    @Override
    ParameterDecl getDecl() {
        return this.decl;
    }

    @Override
    Type fixType() {
        if (this.itemType == null) {
            this.inferType(Types.NUMERIC, null);
        }
        return this.decl.getType();
    }

    @Override
    public void onIndexing(Indexing indexing) {
        if (!Sema.isValid(indexing)) {
            this.invalid = true;
            return;
        }
        this.checkScenarioIndex(indexing, this.decl.isProbability());
        this.decl.setIndexing(indexing);
        Type type = this.decl.getType();
        if (type != null) {
            this.decl.setType(MapType.get(indexing.getDimension(), type));
        }
    }

    @Override
    public void onBasicAttr(Token keyword) {
        BasicAttr.Kind kind;
        switch (keyword.getKind()) {
            case KW_binary: {
                kind = BasicAttr.Kind.BINARY;
                this.numericType = Integrality.BINARY;
                break;
            }
            case KW_integer: {
                kind = BasicAttr.Kind.INTEGER;
                if (this.numericType == Integrality.BINARY) break;
                this.numericType = Integrality.INTEGER;
                break;
            }
            case KW_logical: {
                kind = BasicAttr.Kind.LOGICAL;
                this.numericType = Integrality.BINARY;
                break;
            }
            case KW_symbolic: {
                if (!this.decl.isStochastic()) {
                    kind = BasicAttr.Kind.SYMBOLIC;
                    break;
                }
            }
            default: {
                this.reportInvalidAttr(keyword);
                return;
            }
        }
        BasicAttr attr = new BasicAttr(keyword.getStartPosition(), kind);
        this.inferType(kind != BasicAttr.Kind.SYMBOLIC ? Types.NUMERIC : Types.SYMBOLIC, attr);
        this.decl.addAttr(attr);
    }

    @Override
    public void onUnaryAttr(Token op, Expr arg) {
        switch (op.getKind()) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                this.onInitAttr(op, UnaryAttr.Kind.EQ, arg);
                break;
            }
            case COLON_EQUAL: {
                this.onInitAttr(op, UnaryAttr.Kind.ASSIGN, arg);
                break;
            }
            case KW_default: {
                this.onInitAttr(op, UnaryAttr.Kind.DEFAULT, arg);
                break;
            }
            case LESS: {
                this.onRelationAttr(op, UnaryAttr.Kind.LT, arg);
                break;
            }
            case LESS_EQUAL: {
                this.onRelationAttr(op, UnaryAttr.Kind.LE, arg);
                break;
            }
            case GREATER: {
                this.onRelationAttr(op, UnaryAttr.Kind.GT, arg);
                break;
            }
            case GREATER_EQUAL: {
                this.onRelationAttr(op, UnaryAttr.Kind.GE, arg);
                break;
            }
            case EXCL_EQUAL: 
            case LESS_GREATER: {
                UnaryAttr attr = new UnaryAttr(op.getStartPosition(), UnaryAttr.Kind.NE, arg);
                Type type = arg.getType();
                if (type != Types.NUMERIC && type != Types.SYMBOLIC) {
                    if (type == Types.STRING) {
                        this.inferType(Types.SYMBOLIC, attr);
                    } else {
                        this.sema.report(arg, "Type mismatch", new Object[0]);
                        break;
                    }
                }
                this.decl.addAttr(attr);
                break;
            }
            case KW_in: {
                this.onInAttr(op, UnaryAttr.Kind.IN, arg);
                break;
            }
            case KW_within: {
                this.onInAttr(op, UnaryAttr.Kind.WITHIN, arg);
                break;
            }
            default: {
                this.reportInvalidAttr(op);
                return;
            }
        }
    }

    @Override
    public void onDistAttr(int distPos, Token name, List<Expr> args, int rparenPos) {
        assert (name.isKeywordOrIdentifier());
        if (!this.decl.isRandom()) {
            this.reportInvalidAttr(distPos, TokenKind.KW_dist);
            return;
        }
        Indexing indexing = this.decl.getIndexing();
        if (indexing != null && indexing.hasScenarioIndex()) {
            this.sema.report(distPos, "Attribute 'dist' can't be used with scenario indexing", new Object[0]);
            return;
        }
        if (this.hasDist) {
            this.sema.report(distPos, "Duplicate attribute 'dist'", new Object[0]);
            return;
        }
        this.hasDist = true;
        if (!name.getIdentifier().toString().equals("symmetric")) {
            this.report(name, "Unknown distribution", new Object[0]);
            return;
        }
        if (!this.sema.checkArgs(args, rparenPos, "NN")) {
            return;
        }
        this.decl.setDistAttr();
        DistAttr attr = new DistAttr(distPos, args.get(0), args.get(1));
        this.decl.addAttr(attr);
        this.inferType(Types.RANDOM, attr);
    }

    @Override
    public void onEndAttrs() {
        boolean hasScenarioIndex;
        if (this.invalid) {
            return;
        }
        Indexing indexing = this.decl.getIndexing();
        boolean bl = hasScenarioIndex = indexing != null && indexing.hasScenarioIndex();
        if (this.decl.isRandom()) {
            if (!this.hasDist && !hasScenarioIndex) {
                this.sema.report(this.decl.getStart(), "Random parameter is not indexed over scenario set and has no dist attribute", new Object[0]);
            }
        } else if (this.decl.isProbability() && !hasScenarioIndex) {
            this.sema.report(this.decl.getStart(), "Probability parameter is not indexed over scenario set", new Object[0]);
        }
        if (this.itemType == null) {
            this.inferType(Types.NUMERIC, null);
            this.decl.setNumericType(Integrality.CONTINUOUS);
        } else if (this.itemType == Types.NUMERIC) {
            this.decl.setNumericType(this.numericType);
        }
    }
}

