/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import sampl.ast.BinaryExpr;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.IteratedExpr;
import sampl.ast.NetExpr;
import sampl.ast.ObjectiveDecl;
import sampl.ast.ParameterDecl;
import sampl.ast.Referable;
import sampl.sema.DeclSema;
import sampl.sema.Sema;
import sampl.types.MapType;
import sampl.types.Type;
import sampl.types.Types;

final class ObjectiveDeclSema
extends DeclSema {
    private ObjectiveDecl decl;

    private static boolean isProbability(Expr e) {
        Referable decl = e.getTarget();
        return decl instanceof ParameterDecl && ((ParameterDecl)decl).isProbability();
    }

    private void setBaseExpr(IteratedExpr iterExpr, Expr expr) {
        Indexing indexing = iterExpr.getIndexing();
        if (indexing.getNumParts() != 1) {
            this.checkScenarioIndex(indexing, false);
            expr = new IteratedExpr(iterExpr.getStart(), iterExpr.getType(), iterExpr.getKind(), indexing.copyWithoutScenarioSet(), expr);
        }
        this.decl.setBaseExpr(expr);
    }

    private boolean checkExpectation(Expr e) {
        BinaryExpr binExpr;
        IteratedExpr iterExpr;
        IteratedExpr iteratedExpr = iterExpr = e instanceof IteratedExpr ? (IteratedExpr)e : null;
        if (iterExpr == null || iterExpr.getKind() != IteratedExpr.Kind.SUM) {
            this.sema.report(e, "Expected sum over scenario set", new Object[0]);
            return false;
        }
        e = iterExpr.getArg();
        BinaryExpr binaryExpr = binExpr = e instanceof BinaryExpr ? (BinaryExpr)e : null;
        if (binExpr != null && binExpr.getKind() == BinaryExpr.Kind.MUL) {
            if (ObjectiveDeclSema.isProbability(binExpr.getLHS())) {
                this.setBaseExpr(iterExpr, binExpr.getRHS());
                return true;
            }
            if (ObjectiveDeclSema.isProbability(binExpr.getRHS())) {
                this.setBaseExpr(iterExpr, binExpr.getLHS());
                return true;
            }
        }
        this.sema.report(e, "Expected probability multiplier", new Object[0]);
        return false;
    }

    ObjectiveDeclSema(Sema sema, int pos, String name, boolean max) {
        super(sema);
        this.decl = new ObjectiveDecl(pos, name, max);
        this.decl.setType(Types.OBJECTIVE);
    }

    @Override
    boolean needsScenarioConversion() {
        return true;
    }

    @Override
    ObjectiveDecl getDecl() {
        return this.decl;
    }

    @Override
    public void onIndexing(Indexing indexing) {
        if (!Sema.isValid(indexing)) {
            return;
        }
        this.checkScenarioIndex(indexing, false);
        int scenarioPartIndex = indexing.getScenarioPartIndex();
        if (scenarioPartIndex >= 0) {
            this.sema.report(indexing.getPart(scenarioPartIndex), "Objective can't be indexed over scenario set", new Object[0]);
        }
        this.decl.setIndexing(indexing);
        this.decl.setType(MapType.get(indexing.getDimension(), Types.OBJECTIVE));
    }

    @Override
    public void onDeclExpr(int colonPos, Expr expr) {
        Type type = expr.getType();
        boolean isValid = false;
        if (type == Types.NUMERIC || type == Types.SYMBOLIC || type == Types.VARIABLE || type == Types.EXPR) {
            isValid = true;
        } else if (expr instanceof NetExpr && ((NetExpr)expr).getKind() == NetExpr.Kind.TO_COME) {
            this.decl.setToCome();
            isValid = true;
        }
        if (!isValid) {
            this.sema.report(expr, "Invalid objective expression", new Object[0]);
            return;
        }
        if (this.sema.isScenariosetUsed() && !this.checkExpectation(expr)) {
            return;
        }
        this.decl.setExpr(expr);
    }
}

