/*
 * Decompiled with CFR 0.152.
 */
package sampl.sema;

import sampl.ast.BinaryExpr;
import sampl.ast.ConstraintDecl;
import sampl.ast.DoubleInequalityExpr;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.IteratedExpr;
import sampl.ast.NetExpr;
import sampl.ast.SuffixAttr;
import sampl.parser.Token;
import sampl.sema.DeclSema;
import sampl.sema.Sema;
import sampl.types.MapType;
import sampl.types.Types;

final class ConstraintDeclSema
extends DeclSema {
    private ConstraintDecl decl;
    private Expr netExpr;
    private boolean isRobust;

    private boolean checkSide(Expr side) {
        if (Sema.isArithmetic(side)) {
            return true;
        }
        if (side instanceof NetExpr) {
            if (this.netExpr != null) {
                this.sema.report(side, "Expected expression", new Object[0]);
                return false;
            }
            this.netExpr = side;
            return true;
        }
        this.sema.report(side, "Type mismatch", new Object[0]);
        return false;
    }

    private boolean checkConstSide(Expr side) {
        if (Sema.isConstArithmetic(side)) {
            return true;
        }
        if (side instanceof NetExpr) {
            this.sema.report(side, "Expected expression", new Object[0]);
        } else {
            this.sema.report(side, "Expected constant arithmetic expression", new Object[0]);
        }
        return false;
    }

    private static boolean isProbabilityOrExpectation(Expr expr) {
        if (!(expr instanceof IteratedExpr)) {
            return false;
        }
        IteratedExpr.Kind kind = ((IteratedExpr)expr).getKind();
        return kind == IteratedExpr.Kind.PROBABILITY || kind == IteratedExpr.Kind.EXPECTATION;
    }

    ConstraintDeclSema(Sema sema, int pos, String name, boolean node) {
        super(sema);
        this.decl = new ConstraintDecl(pos, name, node);
    }

    @Override
    boolean needsScenarioConversion() {
        return true;
    }

    @Override
    ConstraintDecl getDecl() {
        return this.decl;
    }

    @Override
    public void onIndexing(Indexing indexing) {
        if (!Sema.isValid(indexing)) {
            return;
        }
        this.checkScenarioIndex(indexing, false);
        this.decl.setIndexing(indexing);
        this.decl.setType(MapType.get(indexing.getDimension(), Types.CONSTRAINT));
    }

    @Override
    public void onSuffixAttr(int suffixKWPos, Token suffix, Expr expr) {
        SuffixAttr attr = this.handleSuffixAttr(suffixKWPos, suffix, expr);
        if (attr == null) {
            return;
        }
        if (attr.getSuffix().toString().equals("robustness")) {
            Indexing indexing = this.decl.getIndexing();
            if (indexing != null && indexing.hasScenarioIndex()) {
                this.sema.report(suffix.getStartPosition(), "Suffix 'robustness' can't be used with scenario indexing", new Object[0]);
            }
            this.isRobust = true;
        }
        this.decl.addAttr(attr);
    }

    @Override
    public void onEndAttrs() {
        if (this.isRobust) {
            this.sema.enterRobustConstraintExpr();
        }
    }

    @Override
    public void onDeclExpr(int colonPos, Expr expr) {
        Indexing indexing;
        if (expr instanceof BinaryExpr) {
            BinaryExpr binExpr = (BinaryExpr)expr;
            if (!this.checkSide(binExpr.getLHS()) || !this.checkSide(binExpr.getRHS())) {
                return;
            }
        } else if (expr instanceof DoubleInequalityExpr) {
            DoubleInequalityExpr die = (DoubleInequalityExpr)expr;
            if (!(this.checkConstSide(die.getLHS()) && this.checkSide(die.getMid()) && this.checkConstSide(die.getRHS()))) {
                return;
            }
        } else {
            this.sema.report(expr, "Invalid constraint expression", new Object[0]);
            return;
        }
        if (this.netExpr != null) {
            if (((NetExpr)this.netExpr).getKind() == NetExpr.Kind.NET_OUT) {
                this.decl.setNetOut();
            } else {
                this.decl.setToCome();
            }
        }
        if (!(this.isRobust || !this.sema.isScenariosetUsed() || (indexing = this.decl.getIndexing()) != null && indexing.hasScenarioIndex())) {
            boolean needScenarioIndex = true;
            if (expr instanceof BinaryExpr) {
                BinaryExpr binExpr = (BinaryExpr)expr;
                Expr lhs = binExpr.getLHS();
                Expr rhs = binExpr.getRHS();
                if (ConstraintDeclSema.isProbabilityOrExpectation(lhs)) {
                    if (!this.sema.expectConstArithmeticExpr(rhs)) {
                        return;
                    }
                    needScenarioIndex = false;
                } else if (ConstraintDeclSema.isProbabilityOrExpectation(rhs)) {
                    if (!this.sema.expectConstArithmeticExpr(lhs)) {
                        return;
                    }
                    needScenarioIndex = false;
                }
            }
            if (needScenarioIndex) {
                this.sema.report(this.decl.getStart(), "Stochastic constraint is not indexed over scenario set", new Object[0]);
                return;
            }
        }
        this.decl.setExpr(expr);
    }
}

