/*
 * Decompiled with CFR 0.152.
 */
package sampl.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import sampl.DiagnosticException;
import sampl.DiagnosticHandler;
import sampl.SAMPLException;
import sampl.Source;
import sampl.ast.ColGroup;
import sampl.ast.Condition;
import sampl.ast.Direction;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.Option;
import sampl.ast.Stmt;
import sampl.parser.Action;
import sampl.parser.DeclAction;
import sampl.parser.DeclKind;
import sampl.parser.IdentifierTable;
import sampl.parser.Lexer;
import sampl.parser.Token;
import sampl.parser.TokenHandler;
import sampl.parser.TokenKind;

public final class Parser {
    private Lexer lexer;
    private TokenKind token;
    private Action action;
    private DiagnosticHandler diagHandler;
    private boolean parsingData;
    private boolean skipLists;
    public static int NOPOS = -1;
    private static final int OPTIONAL = 1;
    private static final int INDEX = 2;
    private static final int TUPLE = 4;
    private static final int COLUMN_NAME = 8;

    private void consumeToken() throws SAMPLException {
        this.token = this.lexer.lex(Lexer.Mode.DEFAULT);
    }

    private int consumeAndGetPosition() throws SAMPLException {
        int pos = this.lexer.getTokenPosition();
        this.token = this.lexer.lex(Lexer.Mode.DEFAULT);
        return pos;
    }

    private Token consumeAndGetToken() throws SAMPLException {
        Token last = this.lexer.createToken();
        this.token = this.lexer.lex(Lexer.Mode.DEFAULT);
        return last;
    }

    private void consumeTokenWithRecovery(boolean recover) throws SAMPLException {
        while (true) {
            try {
                while (true) {
                    this.consumeToken();
                    if (!recover) {
                        return;
                    }
                    this.parsingData = false;
                    switch (this.token) {
                        case EOF: 
                        case SEMI: 
                        case S_DOT_T_DOT: 
                        case KW_arc: 
                        case KW_check: 
                        case KW_data: 
                        case KW_display: 
                        case KW_end: 
                        case KW_exit: 
                        case KW_expand: 
                        case KW_for: 
                        case KW_if: 
                        case KW_let: 
                        case KW_maximize: 
                        case KW_minimize: 
                        case KW_model: 
                        case KW_node: 
                        case KW_option: 
                        case KW_param: 
                        case KW_print: 
                        case KW_printf: 
                        case KW_probability: 
                        case KW_problem: 
                        case KW_q: 
                        case KW_quit: 
                        case KW_random: 
                        case KW_read: 
                        case KW_repeat: 
                        case KW_reset: 
                        case KW_scenarioset: 
                        case KW_set: 
                        case KW_shell: 
                        case KW_solution: 
                        case KW_solve: 
                        case KW_subj: 
                        case KW_subject: 
                        case KW_table: 
                        case KW_tree: 
                        case KW_var: 
                        case KW_write: 
                        case KW_xref: {
                            return;
                        }
                    }
                }
            }
            catch (DiagnosticException e) {
                this.diagHandler.diagnostic(e);
                recover = true;
                continue;
            }
            break;
        }
    }

    private Token consumeTokenInData() throws SAMPLException {
        Token last = this.lexer.createToken();
        this.token = this.lexer.lex(Lexer.Mode.DATA);
        return last;
    }

    private DiagnosticException error(String message) {
        return new DiagnosticException(message, this.lexer.getSource(), this.lexer.getTokenPosition());
    }

    private DiagnosticException error(int offset, String message) {
        return new DiagnosticException(message, this.lexer.getSource(), offset);
    }

    private int expect(TokenKind kind) throws SAMPLException {
        if (this.token != kind) {
            throw this.error(String.format("Expected '%s'", new Object[]{kind}));
        }
        return this.lexer.getTokenPosition();
    }

    private int expectAndConsume(TokenKind kind) throws SAMPLException {
        if (this.token != kind) {
            throw this.error(String.format("Expected '%s'", new Object[]{kind}));
        }
        return this.consumeAndGetPosition();
    }

    private void expectKeywordOrIdentifier() throws SAMPLException {
        if (!this.token.isKeywordOrIdentifier()) {
            throw this.error("Expected identifier");
        }
    }

    private boolean isTokenEqualTo(String str) {
        return str.equals(this.lexer.getTokenData());
    }

    private static int getBinOpPrecedence(TokenKind tk) {
        switch (tk) {
            case PLUS: 
            case MINUS: 
            case KW_less: {
                return 11;
            }
            case STAR: 
            case SLASH: 
            case KW_div: 
            case KW_mod: {
                return 13;
            }
            case EXCL_EQUAL: 
            case LESS_GREATER: 
            case EQUAL: 
            case EQUAL_EQUAL: 
            case LESS: 
            case LESS_EQUAL: 
            case GREATER: 
            case GREATER_EQUAL: {
                return 4;
            }
            case DOT_DOT: {
                return 10;
            }
            case AMP: {
                return 7;
            }
            case PIPE_PIPE: 
            case KW_or: {
                return 1;
            }
            case AMP_AMP: 
            case KW_and: {
                return 3;
            }
            case KW_in: 
            case KW_not: {
                return 5;
            }
            case KW_diff: 
            case KW_symdiff: 
            case KW_union: {
                return 8;
            }
            case KW_cross: {
                return 9;
            }
            case CARET: 
            case STAR_STAR: {
                assert (false);
                break;
            }
        }
        return 0;
    }

    private Expr parseString() throws SAMPLException {
        if (this.token == TokenKind.STRING) {
            return this.action.onStringLiteral(this.consumeAndGetToken());
        }
        if (this.token == TokenKind.LPAREN) {
            return this.parseExpr();
        }
        return null;
    }

    private Expr parseFilename() throws SAMPLException {
        this.token = this.lexer.lex(Lexer.Mode.FILENAME);
        Expr expr = this.parseString();
        if (expr == null) {
            throw this.error("Expected filename");
        }
        return expr;
    }

    private Expr parseExpr(int minPrec, int flags) throws SAMPLException {
        Expr lhs = this.parseUnaryExpr(flags);
        if (lhs == null) {
            return lhs;
        }
        return this.parseRhsOfBinaryExpr(lhs, minPrec, false);
    }

    private Expr parseNetExpr(int minPrec) throws SAMPLException {
        Token keyword = null;
        switch (this.token) {
            case KW_net_in: 
            case KW_net_out: 
            case KW_to_come: {
                keyword = this.consumeAndGetToken();
            }
        }
        if (keyword == null) {
            Expr lhs = this.parseUnaryExpr(0);
            return this.parseRhsOfBinaryExpr(lhs, minPrec, true);
        }
        Token op = null;
        Expr rhs = null;
        if (this.token == TokenKind.PLUS) {
            op = this.consumeAndGetToken();
            rhs = this.parseExpr(11);
        }
        return this.action.onNetExpr(keyword, op, rhs);
    }

    private Expr parseExpr(int minPrec) throws SAMPLException {
        return this.parseExpr(minPrec, 0);
    }

    private Expr parseExpr() throws SAMPLException {
        return this.parseExpr(1, 0);
    }

    private Expr parseRhsOfBinaryExpr(Expr lhs, int minPrec, boolean allowNetExpr) throws SAMPLException {
        int nextTokenPrec = Parser.getBinOpPrecedence(this.token);
        while (nextTokenPrec >= minPrec) {
            boolean hasNot;
            boolean bl = hasNot = this.token == TokenKind.KW_not;
            if (hasNot) {
                this.consumeToken();
                if (this.token != TokenKind.KW_in) {
                    throw this.error("Expected 'in'");
                }
            }
            Token op = this.consumeAndGetToken();
            if (allowNetExpr && op.is(TokenKind.PLUS)) {
                switch (this.token) {
                    case KW_net_in: 
                    case KW_net_out: 
                    case KW_to_come: {
                        return this.action.onNetExpr(this.consumeAndGetToken(), op, lhs);
                    }
                }
            }
            Expr rhs = this.parseUnaryExpr(0);
            int prec = nextTokenPrec;
            if (prec < (nextTokenPrec = Parser.getBinOpPrecedence(this.token))) {
                rhs = this.parseRhsOfBinaryExpr(rhs, prec + 1, false);
                nextTokenPrec = Parser.getBinOpPrecedence(this.token);
            }
            assert (prec >= nextTokenPrec);
            if (op.is(TokenKind.DOT_DOT)) {
                Expr by = null;
                if (this.token == TokenKind.KW_by) {
                    this.consumeToken();
                    by = this.parseExpr(11);
                    nextTokenPrec = Parser.getBinOpPrecedence(this.token);
                }
                lhs = this.action.onRangeExpr(lhs, rhs, by);
                continue;
            }
            lhs = this.action.onBinaryExpr(lhs, op, rhs, hasNot);
        }
        return lhs;
    }

    private Expr parseUnaryExpr(int flags) throws SAMPLException {
        Expr expr;
        switch (this.token) {
            case NUMBER: {
                expr = this.action.onNumericLiteral(this.consumeAndGetToken());
                break;
            }
            case STRING: {
                expr = this.action.onStringLiteral(this.consumeAndGetToken());
                break;
            }
            case IDENTIFIER: {
                expr = this.parseNameExpr(this.consumeAndGetToken(), flags);
                break;
            }
            case LPAREN: {
                int lparenPos = this.consumeAndGetPosition();
                flags = (flags & 4) != 0 ? (flags &= 0xFFFFFFFD) : (flags |= 4);
                List<Expr> items = this.parseExprList(1, flags &= 0xFFFFFFF7);
                int rparenPos = this.expectAndConsume(TokenKind.RPAREN);
                expr = this.action.onParenExpr(lparenPos, items, rparenPos);
                break;
            }
            case LBRACE: {
                this.action.enterScope();
                try {
                    Expr arg;
                    expr = this.parseIndexingOrSetLiteral();
                    if (!(expr instanceof Indexing) || (arg = this.parseExpr(13, 1)) == null) break;
                    expr = this.action.onIndexedExpr((Indexing)expr, arg);
                    break;
                }
                finally {
                    this.action.leaveScope();
                }
            }
            case PLUS: 
            case MINUS: {
                expr = this.action.onUnaryExpr(this.consumeAndGetToken(), this.parseUnaryExpr(0));
                break;
            }
            case EXCL: 
            case KW_not: {
                expr = this.action.onUnaryExpr(this.consumeAndGetToken(), this.parseUnaryExpr(0));
                break;
            }
            case KW_expectation: 
            case KW_max: 
            case KW_min: 
            case KW_probability: 
            case KW_prod: 
            case KW_product: 
            case KW_sum: {
                Token op = this.consumeAndGetToken();
                if (this.token != TokenKind.LBRACE) {
                    expr = this.parseNameExpr(op, 0);
                    break;
                }
                expr = this.parseIteratedExpr(op, 13);
                break;
            }
            case KW_union: {
                Token op = this.consumeAndGetToken();
                if (this.token != TokenKind.LBRACE) {
                    expr = this.parseNameExpr(op, 0);
                    break;
                }
                expr = this.parseIteratedExpr(op, 8);
                break;
            }
            case KW_exists: 
            case KW_forall: {
                Token op = this.consumeAndGetToken();
                if (this.token != TokenKind.LBRACE) {
                    expr = this.parseNameExpr(op, 0);
                    break;
                }
                expr = this.parseIteratedExpr(op, 3);
                break;
            }
            case KW_if: {
                expr = this.parseConditionalExpr();
                break;
            }
            case KW_setof: {
                Token op = this.consumeAndGetToken();
                if (this.token != TokenKind.LBRACE) {
                    expr = this.parseNameExpr(op, 0);
                    break;
                }
                expr = this.parseIteratedExpr(op, 11);
                break;
            }
            case LESS_LESS: {
                int lessLessPos = this.consumeAndGetPosition();
                List<Expr> breakpoints = this.parseExprList();
                this.expectAndConsume(TokenKind.SEMI);
                List<Expr> slopes = this.parseExprList();
                int greaterGreaterPos = this.expectAndConsume(TokenKind.GREATER_GREATER);
                expr = this.parseUnaryExpr(0);
                expr = this.action.onPiecewiseLinearExpr(lessLessPos, breakpoints, slopes, greaterGreaterPos, expr);
                break;
            }
            default: {
                if (this.token.isKeywordOrIdentifier() && (this.lexer.getIdentifier().getDecl() != null || this.token.isStartOnly())) {
                    expr = this.parseNameExpr(this.consumeAndGetToken(), flags);
                    break;
                }
                if ((flags & 1) == 0) {
                    throw this.error("Expected expression");
                }
                return null;
            }
        }
        if (this.token == TokenKind.CARET || this.token == TokenKind.STAR_STAR) {
            Token op = this.consumeAndGetToken();
            expr = this.action.onBinaryExpr(expr, op, this.parseUnaryExpr(0), false);
        }
        return expr;
    }

    private Expr parseNameExpr(Token name, int flags) throws SAMPLException {
        Expr expr;
        assert (name.isKeywordOrIdentifier());
        if (this.token == TokenKind.LPAREN) {
            this.consumeToken();
            List<Expr> args = null;
            if (this.token != TokenKind.RPAREN) {
                args = this.parseExprList();
            }
            int rparenPos = this.expectAndConsume(TokenKind.RPAREN);
            return this.action.onCallExpr(name, args, rparenPos);
        }
        if (name.is(TokenKind.KW_card) && this.token == TokenKind.LBRACE) {
            this.consumeToken();
            ArrayList<Expr> args = new ArrayList<Expr>();
            args.add(this.parseExpr());
            int rbracePos = this.expectAndConsume(TokenKind.RBRACE);
            return this.action.onCallExpr(name, args, rbracePos);
        }
        if (this.token == TokenKind.LBRACKET) {
            expr = this.parseSubscriptExpr(name, false);
        } else {
            if ((flags & 2) != 0) {
                if ((flags & 4) == 0 ? this.token == TokenKind.KW_in : this.token == TokenKind.COMMA || this.token == TokenKind.RPAREN) {
                    return this.action.onReference(name, Action.ReferenceKind.ALLOW_INDEX);
                }
            } else if ((flags & 8) != 0) {
                return this.action.onReference(name, Action.ReferenceKind.COLUMN_NAME);
            }
            expr = this.action.onReference(name, Action.ReferenceKind.DEFAULT);
        }
        if (this.token == TokenKind.DOT) {
            this.consumeToken();
            this.expectKeywordOrIdentifier();
            expr = this.action.onSuffixExpr(expr, this.consumeAndGetToken());
        }
        return expr;
    }

    private Expr parseRefOrSubscriptExpr(boolean isTableName) throws SAMPLException {
        this.expectKeywordOrIdentifier();
        Token name = this.consumeAndGetToken();
        if (this.token == TokenKind.LBRACKET) {
            return this.parseSubscriptExpr(name, isTableName);
        }
        return this.action.onReference(name, isTableName ? Action.ReferenceKind.TABLE_NAME : Action.ReferenceKind.DEFAULT);
    }

    private Expr parseSubscriptExpr(Token name, boolean isTableName) throws SAMPLException {
        assert (this.token == TokenKind.LBRACKET);
        this.consumeToken();
        List<Expr> indices = this.parseExprList();
        int rbracketPos = this.expectAndConsume(TokenKind.RBRACKET);
        return this.action.onSubscriptExpr(name, indices, rbracketPos, isTableName);
    }

    private Expr parseIteratedExpr(Token op, int argPrec) throws SAMPLException {
        Indexing indexing;
        assert (op.is(TokenKind.KW_sum) || op.is(TokenKind.KW_prod) || op.is(TokenKind.KW_product) || op.is(TokenKind.KW_min) || op.is(TokenKind.KW_max) || op.is(TokenKind.KW_exists) || op.is(TokenKind.KW_forall) || op.is(TokenKind.KW_union) || op.is(TokenKind.KW_setof) || op.is(TokenKind.KW_expectation) || op.is(TokenKind.KW_probability));
        assert (this.token == TokenKind.LBRACE);
        Expr arg = null;
        try {
            this.action.enterScope();
            indexing = this.parseIndexing();
            if (!op.is(TokenKind.KW_probability)) {
                arg = this.parseExpr(argPrec);
            }
        }
        finally {
            this.action.leaveScope();
        }
        return this.action.onIteratedExpr(op, indexing, arg);
    }

    Indexing parseIndexingTail(int lbracePos, List<Expr> exprs) throws SAMPLException {
        exprs.set(0, this.action.onIndex(exprs.get(0)));
        while (this.token == TokenKind.COMMA) {
            this.consumeToken();
            Expr expr = this.action.onIndex(this.parseExpr(5, 2));
            exprs.add(expr);
        }
        Expr condition = null;
        if (this.token == TokenKind.COLON) {
            this.consumeToken();
            condition = this.parseExpr();
        }
        int rbracePos = this.expectAndConsume(TokenKind.RBRACE);
        return this.action.onIndexingExpr(lbracePos, exprs, condition, rbracePos);
    }

    /*
     * Unable to fully structure code
     */
    private Expr parseIndexingOrSetLiteral() throws SAMPLException {
        if (!Parser.$assertionsDisabled && this.token != TokenKind.LBRACE) {
            throw new AssertionError();
        }
        lbracePos = this.consumeAndGetPosition();
        exprs = new ArrayList<Expr>();
        if (this.token == TokenKind.RBRACE) {
            rbracePos = this.consumeAndGetPosition();
            return this.action.onSetLiteral(lbracePos, exprs, rbracePos);
        }
        expr = this.parseExpr(5, 2);
        exprs.add(expr);
        if (!this.action.isIndex(expr)) ** GOTO lbl17
        return this.parseIndexingTail(lbracePos, exprs);
lbl-1000:
        // 1 sources

        {
            this.consumeToken();
            expr = this.parseExpr(5);
            exprs.add(expr);
lbl17:
            // 2 sources

            ** while (this.token == TokenKind.COMMA)
        }
lbl18:
        // 1 sources

        rbracePos = this.expectAndConsume(TokenKind.RBRACE);
        return this.action.onSetLiteral(lbracePos, exprs, rbracePos);
    }

    private Indexing parseIndexing() throws SAMPLException {
        assert (this.token == TokenKind.LBRACE);
        int lbracePos = this.consumeAndGetPosition();
        if (this.token == TokenKind.RBRACE) {
            throw this.error(lbracePos, "Empty indexing");
        }
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        exprs.add(this.parseExpr(5, 2));
        return this.parseIndexingTail(lbracePos, exprs);
    }

    private Expr parseConditionalExpr() throws SAMPLException {
        assert (this.token == TokenKind.KW_if);
        int ifPos = this.consumeAndGetPosition();
        Expr ifExpr = this.parseExpr();
        this.expectAndConsume(TokenKind.KW_then);
        Expr thenExpr = this.parseExpr(6);
        Expr elseExpr = null;
        if (this.token == TokenKind.KW_else) {
            this.consumeToken();
            elseExpr = this.parseExpr(6);
        }
        return this.action.onConditionalExpr(ifPos, ifExpr, thenExpr, elseExpr);
    }

    private Expr parseConstraintExpr() throws SAMPLException {
        Expr expr = this.parseBasicConstraintExpr();
        if (this.token == TokenKind.KW_complements) {
            Token op = this.consumeAndGetToken();
            Expr rhs = this.parseBasicConstraintExpr();
            expr = this.action.onBinaryExpr(expr, op, rhs, false);
        }
        return expr;
    }

    private Expr parseBasicConstraintExpr() throws SAMPLException {
        Expr expr = this.parseNetExpr(11);
        switch (this.token) {
            case LESS_EQUAL: 
            case GREATER_EQUAL: {
                Token op = this.consumeAndGetToken();
                Expr mid = this.parseNetExpr(11);
                if (this.token == op.getKind()) {
                    this.consumeToken();
                    Expr rhs = this.parseExpr(11);
                    expr = this.action.onDoubleInequalityExpr(op, expr, mid, rhs);
                    break;
                }
                expr = this.action.onBinaryExpr(expr, op, mid, false);
                break;
            }
            case EQUAL: 
            case EQUAL_EQUAL: {
                Token op = this.consumeAndGetToken();
                Expr rhs = this.parseNetExpr(11);
                expr = this.action.onBinaryExpr(expr, op, rhs, false);
            }
        }
        return expr;
    }

    private List<Expr> parseExprList(int minPrec, int flags) throws SAMPLException {
        Expr expr = this.parseExpr(minPrec, flags);
        if (expr == null && (flags & 1) != 0) {
            return null;
        }
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        exprs.add(expr);
        flags &= 0xFFFFFFFE;
        while (this.token == TokenKind.COMMA) {
            this.consumeToken();
            expr = this.parseExpr(minPrec, flags);
            exprs.add(expr);
        }
        return exprs;
    }

    private List<Expr> parseExprList() throws SAMPLException {
        return this.parseExprList(1, 0);
    }

    private boolean parseTreeAttr(DeclAction da) throws SAMPLException {
        switch (this.token) {
            case KW_nway: 
            case KW_twostage: {
                Token keyword = this.consumeAndGetToken();
                Expr arg = null;
                if (this.token == TokenKind.LBRACE) {
                    this.consumeToken();
                    arg = this.parseExpr();
                    this.expectAndConsume(TokenKind.RBRACE);
                } else if (keyword.is(TokenKind.KW_nway)) {
                    throw this.error("Expected '{'");
                }
                da.onUnaryAttr(keyword, arg);
                return true;
            }
            case KW_bundles: 
            case KW_multibranch: 
            case KW_tlist: {
                Token keyword = this.consumeAndGetToken();
                this.expect(TokenKind.LBRACE);
                Expr arg = this.parseIndexingOrSetLiteral();
                da.onUnaryAttr(keyword, arg);
                return true;
            }
        }
        return false;
    }

    private void parseDecl(Token startToken, DeclKind declKind) throws SAMPLException {
        this.expectKeywordOrIdentifier();
        Token name = this.consumeAndGetToken();
        Token alias = null;
        if (this.token == TokenKind.STRING && declKind != DeclKind.TABLE) {
            alias = this.consumeAndGetToken();
        }
        boolean enteredScope = false;
        boolean startedDecl = false;
        int semiPos = NOPOS;
        try {
            boolean hasComma;
            DeclAction da = this.action.onDecl(declKind, startToken, name, alias);
            if (this.token == TokenKind.LBRACE) {
                this.action.enterScope();
                enteredScope = true;
                da.onIndexing(this.parseIndexing());
            }
            startedDecl = true;
            int prec = 6;
            block17: while (true) {
                boolean bl = hasComma = this.token == TokenKind.COMMA;
                if (hasComma) {
                    this.consumeToken();
                }
                switch (this.token) {
                    case KW_binary: 
                    case KW_circular: 
                    case KW_integer: 
                    case KW_logical: 
                    case KW_ordered: 
                    case KW_symbolic: {
                        da.onBasicAttr(this.consumeAndGetToken());
                        continue block17;
                    }
                    case EXCL_EQUAL: 
                    case LESS_GREATER: 
                    case EQUAL: 
                    case EQUAL_EQUAL: 
                    case LESS: 
                    case LESS_EQUAL: 
                    case GREATER: 
                    case GREATER_EQUAL: 
                    case KW_by: 
                    case KW_default: 
                    case KW_dimen: 
                    case KW_in: 
                    case KW_within: {
                        Token op = this.consumeAndGetToken();
                        Expr expr = this.parseExpr(6);
                        da.onUnaryAttr(op, expr);
                        continue block17;
                    }
                    case KW_suffix: {
                        int suffixPos = this.consumeAndGetPosition();
                        this.expectKeywordOrIdentifier();
                        Token suffix = this.consumeAndGetToken();
                        Expr expr = this.parseExpr(6);
                        da.onSuffixAttr(suffixPos, suffix, expr);
                        continue block17;
                    }
                    case KW_from: 
                    case KW_to: {
                        Token keyword = this.consumeAndGetToken();
                        Expr ref = this.parseRefOrSubscriptExpr(false);
                        Expr expr = this.parseExpr(13, 1);
                        da.onArcAttr(keyword, ref, expr);
                        continue block17;
                    }
                    case KW_coeff: 
                    case KW_cover: 
                    case KW_obj: {
                        Token keyword = this.consumeAndGetToken();
                        Indexing attrIndexing = null;
                        if (this.token == TokenKind.LBRACE) {
                            attrIndexing = this.parseIndexing();
                        }
                        Expr ref = this.parseRefOrSubscriptExpr(false);
                        Expr coef = this.parseExpr(13, keyword.is(TokenKind.KW_cover) ? 1 : 0);
                        da.onCoeffAttr(keyword, attrIndexing, ref, coef);
                        continue block17;
                    }
                    case COLON_EQUAL: {
                        Token op = this.consumeAndGetToken();
                        if (this.parseTreeAttr(da)) continue block17;
                        da.onUnaryAttr(op, this.parseExpr(6));
                        continue block17;
                    }
                    case KW_dist: {
                        int distPos = this.consumeAndGetPosition();
                        this.expectKeywordOrIdentifier();
                        Token distName = this.consumeAndGetToken();
                        this.expectAndConsume(TokenKind.LPAREN);
                        List<Expr> args = this.parseExprList();
                        int rparenPos = this.expectAndConsume(TokenKind.RPAREN);
                        da.onDistAttr(distPos, distName, args, rparenPos);
                        continue block17;
                    }
                }
                if (!this.parseTreeAttr(da)) break;
            }
            if (hasComma) {
                throw this.error("Expected attribute");
            }
            da.onEndAttrs();
            if (this.token == TokenKind.COLON) {
                switch (declKind) {
                    case OBJECTIVE: {
                        int colonPos = this.consumeAndGetPosition();
                        Expr expr = this.parseNetExpr(1);
                        da.onDeclExpr(colonPos, expr);
                        break;
                    }
                    case CONSTRAINT: 
                    case NODE: {
                        int colonPos = this.consumeAndGetPosition();
                        Expr expr = this.parseConstraintExpr();
                        da.onDeclExpr(colonPos, expr);
                        break;
                    }
                    case PROBLEM: {
                        int colonPos = this.consumeAndGetPosition();
                        ArrayList<Token> names = new ArrayList<Token>();
                        this.expectKeywordOrIdentifier();
                        while (true) {
                            names.add(this.consumeAndGetToken());
                            if (this.token != TokenKind.COMMA) break;
                            this.consumeToken();
                            this.expectKeywordOrIdentifier();
                        }
                        da.onProblemItems(colonPos, names);
                    }
                }
            } else if (declKind == DeclKind.CONSTRAINT) {
                throw this.error("Expected ':'");
            }
            semiPos = this.expectAndConsume(TokenKind.SEMI);
        }
        finally {
            if (enteredScope) {
                this.action.leaveScope();
            }
            if (startedDecl) {
                this.action.onDeclEnd(semiPos);
            }
        }
    }

    private Stmt parseProblemDeclOrStmt(boolean allowDecl) throws SAMPLException {
        Token name;
        assert (this.token == TokenKind.KW_problem);
        Token problem = this.consumeAndGetToken();
        Token token = name = this.token.isKeywordOrIdentifier() ? this.lexer.createToken() : null;
        if (name != null && name.getIdentifier().getDecl() != null || this.token == TokenKind.SEMI) {
            Expr ref = name != null ? this.parseExpr() : null;
            int semiPos = this.expectAndConsume(TokenKind.SEMI);
            return this.action.onProblemStmt(problem.getStartPosition(), ref, semiPos);
        }
        if (!allowDecl) {
            throw this.error("Expected ';'");
        }
        this.parseDecl(problem, DeclKind.PROBLEM);
        return null;
    }

    private Token parseInOut() throws SAMPLException {
        if (this.token == TokenKind.KW_IN || this.token == TokenKind.KW_OUT || this.token == TokenKind.KW_INOUT) {
            return this.consumeAndGetToken();
        }
        return null;
    }

    private void parseTableDecl() throws SAMPLException {
        assert (this.token == TokenKind.KW_table);
        Token table = this.consumeAndGetToken();
        this.expectKeywordOrIdentifier();
        Token name = this.consumeAndGetToken();
        DeclAction da = this.action.onDecl(DeclKind.TABLE, table, name, null);
        boolean enteredScope = false;
        boolean startedDecl = false;
        int semiPos = NOPOS;
        try {
            Expr expr;
            if (this.token == TokenKind.LBRACE) {
                this.action.enterScope();
                enteredScope = true;
                da.onIndexing(this.parseIndexing());
            }
            startedDecl = true;
            Token inout = this.parseInOut();
            ArrayList<Expr> strings = new ArrayList<Expr>();
            while ((expr = this.parseString()) != null) {
                if (this.token == TokenKind.COMMA) {
                    this.consumeToken();
                }
                strings.add(expr);
            }
            this.expectAndConsume(TokenKind.COLON);
            Expr keySet = null;
            Direction direction = null;
            if (this.token != TokenKind.LBRACKET) {
                keySet = this.parseExpr(14);
                if (this.token == TokenKind.LESS) {
                    this.consumeToken();
                    this.expectAndConsume(TokenKind.MINUS);
                    if (this.token == TokenKind.GREATER) {
                        this.consumeToken();
                        direction = Direction.INOUT;
                    } else {
                        direction = Direction.IN;
                    }
                } else if (this.token == TokenKind.MINUS) {
                    this.consumeToken();
                    this.expectAndConsume(TokenKind.GREATER);
                    direction = Direction.OUT;
                } else {
                    throw this.error("Expected '<-', '<->', or '->'");
                }
            }
            int lbracketPos = this.expectAndConsume(TokenKind.LBRACKET);
            ArrayList<Expr> keyCols = new ArrayList<Expr>();
            if (this.token.isKeywordOrIdentifier()) {
                if (!enteredScope) {
                    this.action.enterScope();
                    enteredScope = true;
                }
                while (true) {
                    Expr key;
                    Token token;
                    if ((token = this.consumeAndGetToken()).isKeywordOrIdentifier() && this.token == TokenKind.TILDE) {
                        this.consumeToken();
                        key = this.action.onKeyColSpec(token, this.consumeAndGetToken());
                    } else {
                        key = this.action.onKeyColSpec(null, token);
                    }
                    keyCols.add(key);
                    if (this.token != TokenKind.COMMA) break;
                    this.consumeToken();
                }
            }
            int rbracketPos = this.expectAndConsume(TokenKind.RBRACKET);
            Token keyInout = this.parseInOut();
            Expr inExpr = null;
            if (this.token == TokenKind.KW_in) {
                this.consumeToken();
                inExpr = this.parseExpr();
            }
            if (this.token == TokenKind.COMMA) {
                this.consumeToken();
            }
            List<ColGroup> dataCols = null;
            if (this.token != TokenKind.SEMI) {
                dataCols = this.parseColumnGroupList();
                if (this.token != TokenKind.SEMI) {
                    throw this.error("Expected ';'");
                }
            }
            assert (this.token == TokenKind.SEMI);
            semiPos = this.consumeAndGetPosition();
            da.onTableBody(inout, strings, keySet, direction, lbracketPos, keyCols, rbracketPos, keyInout, inExpr, dataCols);
        }
        finally {
            if (enteredScope) {
                this.action.leaveScope();
            }
            if (startedDecl) {
                this.action.onDeclEnd(semiPos);
            }
        }
    }

    private List<ColGroup> parseColumnGroupList() throws SAMPLException {
        ArrayList<ColGroup> colGroups = new ArrayList<ColGroup>();
        while (true) {
            ColGroup colGroup;
            if ((colGroup = this.parseColGroup()) == null) {
                if (this.token == TokenKind.COMMA) {
                    this.consumeToken();
                }
                return colGroups;
            }
            colGroups.add(colGroup);
            if (this.token != TokenKind.COMMA) {
                return colGroups;
            }
            this.consumeToken();
        }
    }

    private ColGroup parseColGroup() throws SAMPLException {
        ColGroup colGroup;
        if (this.token != TokenKind.LBRACE) {
            return this.parseColSpec(null);
        }
        this.action.enterScope();
        try {
            Expr expr = this.parseIndexingOrSetLiteral();
            if (!(expr instanceof Indexing)) {
                throw this.error(expr.getStart(), "Expected column specifier");
            }
            Indexing indexing = (Indexing)expr;
            if (this.token == TokenKind.LESS) {
                this.expectAndConsume(TokenKind.LESS);
                colGroup = this.parseColSpec(indexing);
                this.expectAndConsume(TokenKind.GREATER);
            } else {
                colGroup = this.parseColSpec(indexing);
            }
        }
        finally {
            this.action.leaveScope();
        }
        return colGroup;
    }

    private ColGroup parseColSpec(Indexing indexing) throws SAMPLException {
        Expr expr;
        int flags = 8;
        if (indexing == null) {
            flags |= 1;
        }
        if ((expr = this.parseExpr(5, flags)) == null) {
            return null;
        }
        Token colName = null;
        if (this.token == TokenKind.TILDE) {
            this.consumeToken();
            if (!this.token.isKeywordOrIdentifier() && this.token != TokenKind.STRING) {
                throw this.error("Expected column name");
            }
            colName = this.consumeAndGetToken();
        }
        Token inout = null;
        if (this.token == TokenKind.KW_IN || this.token == TokenKind.KW_OUT || this.token == TokenKind.KW_INOUT) {
            inout = this.consumeAndGetToken();
        }
        return this.action.onColumn(indexing, expr, colName, inout);
    }

    private Stmt parseJumpStmt() throws SAMPLException {
        assert (this.token == TokenKind.KW_break || this.token == TokenKind.KW_continue);
        Token keyword = this.consumeAndGetToken();
        Token loopName = null;
        if (this.token.isKeywordOrIdentifier()) {
            loopName = this.consumeAndGetToken();
        }
        int semiPos = this.expect(TokenKind.SEMI);
        return this.action.onJumpStmt(keyword, loopName, semiPos);
    }

    private Stmt parseBasicStmt() throws SAMPLException {
        assert (this.token == TokenKind.KW_shell || this.token == TokenKind.KW_solve || this.token == TokenKind.KW_reset);
        Token keyword = this.consumeAndGetToken();
        Expr expr = this.parseExpr(5, 1);
        Expr filename = null;
        if (this.token == TokenKind.GREATER && !keyword.is(TokenKind.KW_reset)) {
            filename = this.parseFilename();
        }
        int semiPos = this.expect(TokenKind.SEMI);
        return this.action.onBasicStmt(keyword, expr, filename, semiPos);
    }

    private List<Option> parseOptionList() throws SAMPLException {
        ArrayList<Option> options = new ArrayList<Option>();
        if (!this.token.isKeywordOrIdentifier()) {
            return options;
        }
        while (true) {
            Expr value;
            Token option = this.lexer.createToken();
            Token name = null;
            this.token = this.lexer.lex(Lexer.Mode.OPTION);
            switch (this.token) {
                case STRING: {
                    Token first = this.lexer.createToken();
                    this.token = this.lexer.lex(Lexer.Mode.OPTION);
                    if (this.token != TokenKind.STRING) {
                        value = this.action.onStringLiteral(first);
                        break;
                    }
                    ArrayList<Token> tokens = new ArrayList<Token>();
                    tokens.add(first);
                    do {
                        tokens.add(this.lexer.createToken());
                        this.token = this.lexer.lex(Lexer.Mode.OPTION);
                    } while (this.token == TokenKind.STRING);
                    value = this.action.onStringLiteral(tokens);
                    break;
                }
                case DOT: {
                    this.consumeToken();
                    this.expectKeywordOrIdentifier();
                    name = option;
                    option = this.lexer.createToken();
                    this.token = this.lexer.lex(Lexer.Mode.OPTION);
                    if (this.token == TokenKind.STRING) {
                        value = this.action.onStringLiteral(this.consumeAndGetToken());
                        break;
                    }
                    value = this.parseExpr(1, 1);
                    break;
                }
                default: {
                    value = this.parseExpr(1, 1);
                }
            }
            options.add(this.action.onOption(name, option, value));
            if (this.token != TokenKind.COMMA) {
                return options;
            }
            this.consumeToken();
            this.expectKeywordOrIdentifier();
        }
    }

    private Stmt parseOptionStmt() throws SAMPLException {
        assert (this.token == TokenKind.KW_option);
        int optionPos = this.consumeAndGetPosition();
        List<Option> options = this.parseOptionList();
        int semiPos = this.expect(TokenKind.SEMI);
        return this.action.onOptionStmt(optionPos, options, semiPos);
    }

    private Stmt parseCheckDeclOrStmt(boolean allowDecl) throws SAMPLException {
        int semiPos;
        assert (this.token == TokenKind.KW_check);
        int checkPos = this.consumeAndGetPosition();
        boolean enteredScope = false;
        Indexing indexing = null;
        Expr expr = null;
        try {
            if (allowDecl) {
                int flags = 0;
                if (this.token == TokenKind.LBRACE) {
                    this.action.enterScope();
                    enteredScope = true;
                    indexing = this.parseIndexing();
                    this.expectAndConsume(TokenKind.COLON);
                } else if (this.token == TokenKind.COLON) {
                    this.consumeToken();
                } else {
                    flags = 1;
                }
                expr = this.parseExpr(1, flags);
            }
            semiPos = this.expect(TokenKind.SEMI);
        }
        finally {
            if (enteredScope) {
                this.action.leaveScope();
            }
        }
        if (expr == null) {
            return this.action.onCheckStmt(checkPos, semiPos);
        }
        this.action.onCheckDecl(checkPos, indexing, expr, semiPos);
        return null;
    }

    private Stmt parseFixUnfixStmt() throws SAMPLException {
        int semiPos;
        Expr lhs;
        assert (this.token == TokenKind.KW_fix || this.token == TokenKind.KW_unfix);
        int letPos = this.consumeAndGetPosition();
        Indexing indexing = null;
        Expr rhs = null;
        boolean enteredScope = false;
        try {
            if (this.token == TokenKind.LBRACE) {
                this.action.enterScope();
                enteredScope = true;
                indexing = this.parseIndexing();
            }
            lhs = this.parseExpr();
            if (this.token != TokenKind.SEMI) {
                this.expectAndConsume(TokenKind.COLON_EQUAL);
                rhs = this.parseExpr();
            }
            semiPos = this.expect(TokenKind.SEMI);
        }
        finally {
            if (enteredScope) {
                this.action.leaveScope();
            }
        }
        return this.action.onFixStmt(letPos, indexing, lhs, rhs, semiPos);
    }

    private Stmt parseLetStmt() throws SAMPLException {
        int semiPos;
        Expr rhs;
        Expr lhs;
        assert (this.token == TokenKind.KW_let);
        int letPos = this.consumeAndGetPosition();
        Indexing indexing = null;
        boolean enteredScope = false;
        try {
            if (this.token == TokenKind.LBRACE) {
                this.action.enterScope();
                enteredScope = true;
                indexing = this.parseIndexing();
            }
            lhs = this.parseExpr();
            this.expectAndConsume(TokenKind.COLON_EQUAL);
            rhs = this.parseExpr();
            semiPos = this.expect(TokenKind.SEMI);
        }
        finally {
            if (enteredScope) {
                this.action.leaveScope();
            }
        }
        return this.action.onLetStmt(letPos, indexing, lhs, rhs, semiPos);
    }

    private Stmt parseIfStmt() throws SAMPLException {
        assert (this.token == TokenKind.KW_if);
        int ifPos = this.consumeAndGetPosition();
        Expr condition = this.parseExpr();
        this.expectAndConsume(TokenKind.KW_then);
        Stmt thenStmt = this.parseStmt();
        Stmt elseStmt = null;
        if (this.token == TokenKind.KW_else) {
            this.consumeToken();
            elseStmt = this.parseStmt();
        }
        return this.action.onIfStmt(ifPos, condition, thenStmt, elseStmt);
    }

    private Stmt parseForStmt(boolean topLevel) throws SAMPLException {
        Token name;
        assert (this.token == TokenKind.KW_for);
        int forPos = this.consumeAndGetPosition();
        Token token = name = this.token.isKeywordOrIdentifier() ? this.consumeAndGetToken() : null;
        if (this.token != TokenKind.LBRACE) {
            throw this.error("Expected indexing");
        }
        this.action.onLoopStart(name);
        try {
            this.action.enterScope();
            Indexing indexing = this.parseIndexing();
            Stmt body = this.parseStmt(false, false);
            Stmt stmt = this.action.onForStmt(forPos, indexing, body);
            return stmt;
        }
        finally {
            this.action.leaveScope();
            this.action.onLoopEnd();
        }
    }

    private Stmt parseRepeatStmt() throws SAMPLException {
        assert (this.token == TokenKind.KW_repeat);
        int repeatPos = this.consumeAndGetPosition();
        Token name = null;
        if (this.token.isKeywordOrIdentifier() && this.token != TokenKind.KW_until && this.token != TokenKind.KW_while) {
            name = this.consumeAndGetToken();
        }
        this.action.onLoopStart(name);
        try {
            Condition precondition = null;
            switch (this.token) {
                default: {
                    break;
                }
                case KW_until: {
                    this.consumeToken();
                    precondition = new Condition(true, this.parseExpr());
                    break;
                }
                case KW_while: {
                    this.consumeToken();
                    precondition = new Condition(false, this.parseExpr());
                }
            }
            Stmt body = this.parseCompoundStmt();
            Condition postcondition = null;
            int semiPos = NOPOS;
            switch (this.token) {
                case KW_until: {
                    this.consumeToken();
                    postcondition = new Condition(true, this.parseExpr());
                    semiPos = this.expect(TokenKind.SEMI);
                    break;
                }
                case KW_while: {
                    this.consumeToken();
                    postcondition = new Condition(false, this.parseExpr());
                    semiPos = this.expect(TokenKind.SEMI);
                }
            }
            Stmt stmt = this.action.onRepeatStmt(repeatPos, precondition, body, postcondition, semiPos);
            return stmt;
        }
        finally {
            this.action.onLoopEnd();
        }
    }

    private Stmt parseCompoundStmt() throws SAMPLException {
        int lbracePos = this.expectAndConsume(TokenKind.LBRACE);
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        while (this.token != TokenKind.RBRACE) {
            stmts.add(this.parseStmt());
        }
        int rbracePos = this.consumeAndGetPosition();
        return this.action.onCompoundStmt(lbracePos, stmts, rbracePos);
    }

    private Stmt parseReadTableOrIOStmt() throws SAMPLException {
        int semiPos;
        assert (this.token == TokenKind.KW_display || this.token == TokenKind.KW_expand || this.token == TokenKind.KW_print || this.token == TokenKind.KW_printf || this.token == TokenKind.KW_read || this.token == TokenKind.KW_xref);
        Token keyword = this.consumeAndGetToken();
        if (keyword.is(TokenKind.KW_read) && this.token == TokenKind.KW_table) {
            return this.parseTableIOStmt(keyword);
        }
        Expr indexing = null;
        Action.Redirection redirection = null;
        List<Expr> exprs = null;
        boolean hasColon = false;
        boolean enteredScope = false;
        try {
            if (this.token == TokenKind.LBRACE) {
                this.action.enterScope();
                enteredScope = true;
                indexing = this.parseIndexingOrSetLiteral();
                if (indexing instanceof Indexing) {
                    Expr arg = this.parseExpr(13, 1);
                    if (arg != null) {
                        indexing = this.action.onIndexedExpr((Indexing)indexing, arg);
                        enteredScope = false;
                        this.action.leaveScope();
                    } else if (this.token == TokenKind.COLON) {
                        hasColon = true;
                        this.consumeToken();
                    }
                }
            }
            int PREC = 5;
            if (indexing != null && !hasColon && this.token == TokenKind.COMMA) {
                this.consumeToken();
                exprs = this.parseExprList(5, 0);
            } else {
                exprs = this.parseExprList(5, 1);
            }
            Action.Redirection.Op op = null;
            switch (this.token) {
                case LESS: {
                    op = Action.Redirection.Op.LESS;
                    break;
                }
                case GREATER: {
                    op = Action.Redirection.Op.GREATER;
                    break;
                }
                case GREATER_GREATER: {
                    op = Action.Redirection.Op.GREATER_GREATER;
                    break;
                }
            }
            if (op != null) {
                redirection = new Action.Redirection(this.lexer.getTokenPosition(), op);
                redirection.filename = this.parseFilename();
            }
            if (exprs == null) {
                exprs = new ArrayList<Expr>();
            }
            if (indexing != null && !hasColon) {
                exprs.add(0, indexing);
                indexing = null;
            }
            semiPos = this.expect(TokenKind.SEMI);
        }
        finally {
            if (enteredScope) {
                this.action.leaveScope();
            }
        }
        return this.action.onIOStmt(keyword, (Indexing)indexing, exprs, redirection, semiPos);
    }

    private Stmt parseWriteStmt() throws SAMPLException {
        assert (this.token == TokenKind.KW_write || this.token == TokenKind.KW_solution);
        Token keyword = this.lexer.createToken();
        this.token = this.lexer.lex(Lexer.Mode.FILENAME);
        if (keyword.is(TokenKind.KW_write) && this.isTokenEqualTo("table")) {
            return this.parseTableIOStmt(keyword);
        }
        Expr expr = null;
        if (this.token == TokenKind.STRING) {
            expr = this.action.onStringLiteral(this.consumeAndGetToken());
        } else if (this.token == TokenKind.LPAREN) {
            expr = this.parseExpr();
        }
        int semiPos = this.expect(TokenKind.SEMI);
        return this.action.onBasicStmt(keyword, expr, null, semiPos);
    }

    private Stmt parseTableIOStmt(Token keyword) throws SAMPLException {
        assert (keyword.is(TokenKind.KW_read) || keyword.is(TokenKind.KW_write));
        assert (this.token == TokenKind.KW_table || this.isTokenEqualTo("table"));
        int tablePos = this.consumeAndGetPosition();
        Expr expr = this.parseRefOrSubscriptExpr(true);
        int semiPos = this.expect(TokenKind.SEMI);
        return this.action.onTableIOStmt(keyword, tablePos, expr, semiPos);
    }

    private Stmt parseIncludeStmt() throws SAMPLException {
        assert (this.token == TokenKind.KW_model || this.token == TokenKind.KW_data || this.token == TokenKind.KW_commands);
        Token keyword = this.lexer.createToken();
        this.token = this.lexer.lex(Lexer.Mode.FILENAME);
        if (this.token == TokenKind.SEMI) {
            this.parsingData = keyword.is(TokenKind.KW_data);
            return this.action.onBasicStmt(keyword, null, null, this.lexer.getTokenPosition());
        }
        Expr expr = null;
        if (this.token == TokenKind.STRING) {
            expr = this.action.onStringLiteral(this.lexer.createToken());
        } else {
            assert (this.token == TokenKind.LPAREN);
            this.consumeToken();
            expr = this.parseExpr();
            if (this.token != TokenKind.RPAREN) {
                throw this.error("Expected ')'");
            }
        }
        Token end = this.consumeAndGetToken();
        return this.action.onIncludeStmt(keyword, expr, end);
    }

    private Stmt parseStmt(boolean topLevel, boolean consumeSemi) throws SAMPLException {
        Stmt stmt;
        switch (this.token) {
            case SEMI: {
                return this.action.onEmptyStmt(this.consumeAndGetToken());
            }
            case KW_break: 
            case KW_continue: {
                stmt = this.parseJumpStmt();
                break;
            }
            case KW_reset: 
            case KW_shell: 
            case KW_solve: {
                stmt = this.parseBasicStmt();
                break;
            }
            case KW_problem: {
                stmt = this.parseProblemDeclOrStmt(topLevel);
                break;
            }
            case KW_option: {
                stmt = this.parseOptionStmt();
                break;
            }
            case KW_check: {
                stmt = this.parseCheckDeclOrStmt(topLevel);
                break;
            }
            case KW_solution: 
            case KW_write: {
                stmt = this.parseWriteStmt();
                break;
            }
            case KW_display: 
            case KW_expand: 
            case KW_print: 
            case KW_printf: 
            case KW_read: 
            case KW_xref: {
                stmt = this.parseReadTableOrIOStmt();
                break;
            }
            case KW_let: {
                stmt = this.parseLetStmt();
                break;
            }
            case KW_if: {
                stmt = this.parseIfStmt();
                break;
            }
            case KW_for: {
                stmt = this.parseForStmt(topLevel);
                break;
            }
            case KW_repeat: {
                stmt = this.parseRepeatStmt();
                break;
            }
            case LBRACE: {
                stmt = this.parseCompoundStmt();
                break;
            }
            case KW_fix: {
                stmt = this.parseFixUnfixStmt();
                break;
            }
            case KW_drop: 
            case KW_restore: 
            case KW_unfix: {
                throw this.error("Drop, restore, fix and unfix are not implemented in this version of SAMPL.");
            }
            default: {
                throw this.error(topLevel ? "Expected declaration or statement" : "Expected statement");
            }
        }
        if (consumeSemi && this.token == TokenKind.SEMI) {
            this.consumeToken();
        }
        return stmt;
    }

    private Stmt parseStmt() throws SAMPLException {
        return this.parseStmt(false, true);
    }

    private void parseSetData() throws SAMPLException {
        assert (this.token == TokenKind.KW_set);
        int setPos = this.consumeAndGetPosition();
        this.expectKeywordOrIdentifier();
        Token name = this.consumeTokenInData();
        Action.Subscript sub = null;
        if (this.token == TokenKind.LBRACKET) {
            sub = new Action.Subscript();
            sub.lbracketPos = this.consumeTokenInData().getStartPosition();
            ArrayList<Token> items = new ArrayList<Token>();
            while (true) {
                if (!this.token.isObject()) {
                    throw this.error("Expected object");
                }
                items.add(this.consumeTokenInData());
                if (this.token != TokenKind.COMMA) break;
                this.consumeTokenInData();
            }
            sub.items = items;
            if (this.token != TokenKind.RBRACKET) {
                throw this.error("Expected ']'");
            }
            sub.rbracketPos = this.consumeTokenInData().getStartPosition();
        }
        if (this.token == TokenKind.EQUAL || this.token == TokenKind.COLON_EQUAL) {
            this.consumeTokenInData();
        }
        this.action.onSetDataStart(setPos, name, sub);
        this.parseSetSpecList();
        assert (this.token == TokenKind.SEMI);
        this.action.onDataEnd(this.consumeAndGetPosition());
    }

    private void parseParameterData() throws SAMPLException {
        assert (this.token == TokenKind.KW_param || this.token == TokenKind.KW_var);
        Token keyword = this.consumeAndGetToken();
        Token defaultValue = null;
        switch (this.token) {
            case KW_default: {
                this.consumeTokenInData();
                if (!this.token.isObject()) {
                    throw this.error("Expected object");
                }
                defaultValue = this.consumeTokenInData();
                if (this.token != TokenKind.COLON) {
                    throw this.error("Expected ':'");
                }
            }
            case COLON: {
                this.consumeToken();
                this.expectKeywordOrIdentifier();
                ArrayList<Token> names = new ArrayList<Token>();
                names.add(this.consumeAndGetToken());
                Token setName = null;
                switch (this.token) {
                    case COLON: {
                        setName = (Token)names.remove(0);
                        this.consumeToken();
                        this.expectKeywordOrIdentifier();
                    }
                    default: {
                        while (this.token.isKeywordOrIdentifier()) {
                            names.add(this.consumeAndGetToken());
                        }
                        if (this.token == TokenKind.EQUAL || this.token == TokenKind.COLON_EQUAL) break;
                        throw this.error("Expected ':='");
                    }
                    case EQUAL: 
                    case COLON_EQUAL: 
                }
                this.consumeTokenInData();
                this.action.onDataStart(keyword, defaultValue, setName, names);
                this.parseMultiValueList();
                break;
            }
            default: {
                Token name = this.consumeTokenInData();
                switch (this.token) {
                    case STRING: {
                        if (!this.isTokenEqualTo("default")) break;
                        this.consumeTokenInData();
                        if (!this.token.isObject()) {
                            throw this.error("Expected object");
                        }
                        defaultValue = this.consumeTokenInData();
                        if (this.token != TokenKind.EQUAL && this.token != TokenKind.COLON_EQUAL) break;
                    }
                    case EQUAL: 
                    case COLON_EQUAL: {
                        this.consumeTokenInData();
                    }
                }
                this.action.onDataStart(keyword, name, defaultValue);
                this.parseParameterSpecList();
            }
        }
        assert (this.token == TokenKind.SEMI);
        this.action.onDataEnd(this.consumeAndGetPosition());
    }

    private void parseSetSpecList() throws SAMPLException {
        while (true) {
            switch (this.token) {
                case LPAREN: 
                case KW_tr: {
                    int trPos = this.parseSetTemplate();
                    if (trPos == NOPOS) break;
                    this.parseTable(trPos);
                    break;
                }
                case NUMBER: 
                case STRING: {
                    this.parseValueList();
                    break;
                }
                case COLON: {
                    this.parseTable(0);
                    break;
                }
                case SEMI: {
                    return;
                }
                default: {
                    throw this.error("Expected ';'");
                }
            }
            if (this.token != TokenKind.COMMA) continue;
            this.consumeTokenInData();
        }
    }

    private void parseParameterSpecList() throws SAMPLException {
        boolean hasComma = false;
        while (true) {
            switch (this.token) {
                case LBRACKET: {
                    this.parseParameterTemplate();
                    break;
                }
                case NUMBER: 
                case STRING: {
                    this.parseValueList();
                    break;
                }
                case LPAREN: {
                    int trPos = this.consumeTokenInData().getStartPosition();
                    if (!this.isTokenEqualTo("tr")) {
                        throw this.error("Expected 'tr'");
                    }
                    this.consumeTokenInData();
                    if (this.token != TokenKind.RPAREN) {
                        throw this.error("Expected ')'");
                    }
                    this.consumeTokenInData();
                    this.parseTable(trPos);
                    break;
                }
                case KW_tr: {
                    int trrPos = this.lexer.getTokenPosition() + 1;
                    this.consumeTokenInData();
                    this.parseTable(trrPos);
                    break;
                }
                case COLON: {
                    this.parseTable(0);
                    break;
                }
                default: {
                    if (hasComma) {
                        throw this.error("Expected parameter data");
                    }
                    if (this.token != TokenKind.SEMI) {
                        throw this.error("Expected ';'");
                    }
                    return;
                }
            }
            if (!(hasComma = this.token == TokenKind.COMMA)) continue;
            this.consumeTokenInData();
        }
    }

    private void parseMultiValueList() throws SAMPLException {
        block5: while (true) {
            switch (this.token) {
                case LBRACKET: {
                    this.parseParameterTemplate();
                    continue block5;
                }
                case NUMBER: 
                case STRING: {
                    this.parseValueList();
                    continue block5;
                }
                case SEMI: {
                    return;
                }
            }
            break;
        }
        throw this.error("Expected ';'");
    }

    private void parseTable(int trPos) throws SAMPLException {
        int colonPos = NOPOS;
        if (this.token == TokenKind.COLON) {
            colonPos = this.consumeTokenInData().getStartPosition();
        }
        ArrayList<Token> objects = new ArrayList<Token>();
        while (this.token.isObject()) {
            objects.add(this.consumeTokenInData());
        }
        this.action.onTableHeader(trPos, colonPos, objects);
        if (this.token != TokenKind.COLON_EQUAL) {
            throw this.error("Expected ':='");
        }
        int colonEqualPos = this.consumeTokenInData().getStartPosition();
        objects = new ArrayList();
        while (this.token.isObject()) {
            objects.add(this.consumeTokenInData());
        }
        this.action.onRowList(colonEqualPos, objects);
    }

    private void parseValueList() throws SAMPLException {
        assert (this.token.isObject() || this.token == TokenKind.DOT);
        ArrayList<Token> objects = new ArrayList<Token>();
        do {
            objects.add(this.consumeTokenInData());
            if (this.token != TokenKind.COMMA) continue;
            this.consumeTokenInData();
        } while (this.token.isObject() || this.token == TokenKind.DOT);
        this.action.onObjectList(objects);
    }

    private int parseSetTemplate() throws SAMPLException {
        assert (this.token == TokenKind.LPAREN || this.token == TokenKind.KW_tr);
        if (this.token == TokenKind.KW_tr) {
            int pos = this.lexer.getTokenPosition();
            this.consumeTokenInData();
            return pos;
        }
        int lparenPos = this.consumeTokenInData().getStartPosition();
        if (this.isTokenEqualTo("tr")) {
            this.consumeTokenInData();
            if (this.token != TokenKind.RPAREN) {
                throw this.error("Expected ')'");
            }
            this.consumeTokenInData();
            return lparenPos;
        }
        List<Token> items = this.parseTemplateItemList();
        if (this.token != TokenKind.RPAREN) {
            throw this.error("Expected ')'");
        }
        int rparenPos = this.consumeTokenInData().getStartPosition();
        if (this.token == TokenKind.COLON_EQUAL) {
            this.consumeTokenInData();
        }
        this.action.onSetTemplate(lparenPos, items, rparenPos);
        return NOPOS;
    }

    private void parseParameterTemplate() throws SAMPLException {
        assert (this.token == TokenKind.LBRACKET);
        int lbracketPos = this.consumeTokenInData().getStartPosition();
        List<Token> items = this.parseTemplateItemList();
        if (this.token != TokenKind.RBRACKET) {
            throw this.error("Expected ']'");
        }
        int rbracketPos = this.consumeTokenInData().getStartPosition();
        if (this.token == TokenKind.COLON_EQUAL) {
            this.consumeTokenInData();
        }
        this.action.onParamTemplate(lbracketPos, items, rbracketPos);
    }

    private List<Token> parseTemplateItemList() throws SAMPLException {
        ArrayList<Token> items = this.skipLists ? null : new ArrayList<Token>();
        while (true) {
            switch (this.token) {
                case NUMBER: 
                case STRING: 
                case STAR: 
                case COLON: {
                    if (this.skipLists) break;
                    items.add(this.lexer.createToken());
                    break;
                }
                default: {
                    throw this.error("Expected template item");
                }
            }
            this.consumeTokenInData();
            if (this.token != TokenKind.COMMA) {
                return items;
            }
            this.consumeTokenInData();
        }
    }

    public Parser(Action act, IdentifierTable identifiers, DiagnosticHandler dh) {
        this.lexer = new Lexer(identifiers);
        this.token = null;
        this.action = act;
        this.diagHandler = dh;
    }

    public void setTokenHandler(TokenHandler th) {
        this.lexer.setTokenHandler(th);
    }

    public void setSkipLists() {
        this.skipLists = true;
    }

    public void parse(Source source, boolean isData) throws SAMPLException {
        this.lexer.setSource(source);
        this.parsingData = isData;
        this.action.onSourceStart(source);
        this.consumeTokenWithRecovery(false);
        while (true) {
            try {
                while (true) {
                    Stmt stmt = null;
                    if (this.parsingData) {
                        switch (this.token) {
                            case KW_param: 
                            case KW_var: {
                                this.parseParameterData();
                                break;
                            }
                            case KW_set: {
                                this.parseSetData();
                                break;
                            }
                            case KW_commands: 
                            case KW_data: 
                            case KW_model: {
                                stmt = this.parseIncludeStmt();
                                break;
                            }
                            case SEMI: {
                                stmt = this.action.onEmptyStmt(this.consumeAndGetToken());
                                break;
                            }
                            default: {
                                this.parsingData = false;
                                break;
                            }
                        }
                    } else {
                        switch (this.token) {
                            case KW_param: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.PARAMETER);
                                break;
                            }
                            case KW_random: {
                                Token random = this.consumeAndGetToken();
                                this.expectAndConsume(TokenKind.KW_param);
                                this.parseDecl(random, DeclKind.RANDOM);
                                break;
                            }
                            case KW_probability: {
                                Token probability = this.consumeAndGetToken();
                                if (this.token == TokenKind.KW_param) {
                                    this.consumeToken();
                                }
                                this.parseDecl(probability, DeclKind.PROBABILITY);
                                break;
                            }
                            case KW_var: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.VARIABLE);
                                break;
                            }
                            case KW_arc: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.ARC);
                                break;
                            }
                            case KW_set: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.SET);
                                break;
                            }
                            case KW_scenarioset: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.SCENARIOSET);
                                break;
                            }
                            case KW_tree: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.TREE);
                                break;
                            }
                            case KW_subj: 
                            case KW_subject: {
                                Token subject = this.consumeAndGetToken();
                                this.expectAndConsume(TokenKind.KW_to);
                                this.parseDecl(subject, DeclKind.CONSTRAINT);
                                break;
                            }
                            case IDENTIFIER: {
                                this.parseDecl(this.lexer.createToken(), DeclKind.CONSTRAINT);
                                break;
                            }
                            case S_DOT_T_DOT: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.CONSTRAINT);
                                break;
                            }
                            case KW_node: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.NODE);
                                break;
                            }
                            case KW_maximize: 
                            case KW_minimize: {
                                this.parseDecl(this.consumeAndGetToken(), DeclKind.OBJECTIVE);
                                break;
                            }
                            case KW_problem: {
                                stmt = this.parseProblemDeclOrStmt(true);
                                break;
                            }
                            case KW_table: {
                                this.parseTableDecl();
                                break;
                            }
                            case KW_commands: 
                            case KW_data: 
                            case KW_model: {
                                stmt = this.parseIncludeStmt();
                                break;
                            }
                            case KW_exit: {
                                this.consumeToken();
                                this.expect(TokenKind.SEMI);
                            }
                            case EOF: 
                            case KW_end: 
                            case KW_q: 
                            case KW_quit: {
                                this.action.onSourceEnd();
                                return;
                            }
                            default: {
                                stmt = this.parseStmt(true, false);
                            }
                        }
                    }
                    if (stmt == null) continue;
                    this.action.onTopLevelStmt(stmt);
                    if (this.token != TokenKind.SEMI) continue;
                    this.consumeToken();
                }
            }
            catch (DiagnosticException e) {
                this.diagHandler.diagnostic(e);
                if (this.token == TokenKind.EOF) continue;
                this.consumeTokenWithRecovery(true);
                continue;
            }
            break;
        }
    }

    public void parse(String filename, boolean isData) throws SAMPLException {
        Source source = null;
        try {
            source = Source.newFileSource(filename);
        }
        catch (IOException e) {
            this.diagHandler.diagnostic(this.error(NOPOS, e.getMessage()));
            return;
        }
        this.parse(source, isData);
    }
}

