/*
 * Decompiled with CFR 0.152.
 */
package sampl.parser;

import java.util.HashMap;
import sampl.parser.Identifier;
import sampl.parser.TokenKind;

public final class IdentifierTable {
    private HashMap<String, Identifier> map;
    private boolean amplOnly;

    public IdentifierTable(boolean parseAMPLOnly) {
        this.amplOnly = parseAMPLOnly;
        this.reset();
    }

    public Identifier get(String name) {
        Identifier id = this.map.get(name);
        if (id != null) {
            return id;
        }
        id = new Identifier(name, TokenKind.IDENTIFIER, null);
        this.map.put(name, id);
        return id;
    }

    public void reset() {
        TokenKind[] kinds = TokenKind.values();
        int firstKeywordIndex = TokenKind.IDENTIFIER.ordinal() + 1;
        this.map = new HashMap(kinds.length - firstKeywordIndex);
        int i = firstKeywordIndex;
        while (i < kinds.length) {
            if (!this.amplOnly || !kinds[i].isSAMPLOnly()) {
                TokenKind kind = kinds[i];
                String name = kind.toString();
                Identifier id = new Identifier(name, kind, null);
                this.map.put(name, id);
            }
            ++i;
        }
    }

    public HashMap<String, Identifier> getMap() {
        return this.map;
    }
}

