/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang.asl;

import com.sun.jna.Callback;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import sampl.SAMPLException;
import sampl.Tuple;
import sampl.lang.Column;
import sampl.lang.ProblemMap;
import sampl.lang.SAMPL;
import sampl.lang.Table;
import sampl.lang.TableMap;
import sampl.lang.asl.DBCol;
import sampl.lang.asl.TMInfo;

public final class TableInfo
extends Structure {
    static int IN = 1;
    static int OUT = 2;
    static int INSET = 4;
    public AddRows addRows;
    public String tname;
    public Pointer strings;
    public Pointer colnames;
    public DBCol.ByReference dbcols;
    public Pointer missing;
    public String errmsg;
    public Pointer vinfo;
    public TMInfo tmi;
    public int nstrings;
    public int arity;
    public int ncols;
    public int flags;
    public NativeLong nrows;
    public Pointer private_;
    public Lookup lookup;
    public AdjustMaxrows adjustMaxrows;
    public ColAlloc colAlloc;
    public NativeLong maxrows;
    private static int DOUBLE_SIZE = Native.getNativeSize(Double.class);

    public TableInfo() {
    }

    private Object getValue(DBCol col, int rowIndex) {
        Pointer ptr;
        if (col.sval != null && (ptr = col.sval.getPointer((long)(Native.POINTER_SIZE * rowIndex))) != null && ptr != this.missing) {
            return ptr.getString(0L);
        }
        return col.dval.getDouble((long)(DOUBLE_SIZE * rowIndex));
    }

    private void setValue(DBCol.ByReference[] cols, String[][] sval, int row, int col, Object value, int numRows) {
        if (value instanceof Double) {
            Pointer dval = cols[col].dval;
            if (dval == null) {
                cols[col].dval = dval = new Memory((long)(DOUBLE_SIZE * numRows));
            }
            dval.setDouble((long)(DOUBLE_SIZE * row), ((Double)value).doubleValue());
        } else {
            if (sval[col] == null) {
                sval[col] = new String[numRows];
            }
            sval[col][row] = (String)value;
        }
    }

    private void initializeForRead(Table table, DBCol.ByReference[] cols) throws SAMPLException {
        this.flags = IN;
        int i = 0;
        while (i < cols.length) {
            cols[i].dval = new Memory((long)DOUBLE_SIZE);
            cols[i].sval = new Memory((long)Native.POINTER_SIZE);
            ++i;
        }
        final TableMap map = (TableMap)table.map();
        final SAMPL env = map.sampl();
        final Set<?> inSet = table.getInSet();
        final Object[] values = new Object[this.ncols];
        this.addRows = new AddRows(){

            @Override
            public int invoke(TableInfo ti, DBCol cols, NativeLong nrows) {
                try {
                    int numKeyCols = ti.arity;
                    int numDataCols = ti.ncols;
                    int numRows = nrows.intValue();
                    int numCols = numKeyCols + numDataCols;
                    DBCol[] colArray = cols.toArray(numCols);
                    Object[] items = null;
                    int i = 0;
                    while (i < numRows) {
                        Tuple key;
                        if (numKeyCols != 1) {
                            items = new Object[numKeyCols];
                        }
                        Object value = null;
                        int j = 0;
                        while (j < numKeyCols) {
                            value = TableInfo.this.getValue(colArray[j], i);
                            if (items != null) {
                                items[j] = value;
                            }
                            ++j;
                        }
                        Tuple tuple = key = items != null ? new Tuple(items) : value;
                        if (inSet == null || inSet.contains(key)) {
                            int k = 0;
                            while (j < numCols) {
                                values[k] = TableInfo.this.getValue(colArray[j], i);
                                ++j;
                                ++k;
                            }
                            map.addRow(env, key, values);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    ti.errmsg = e.getMessage();
                    return 1;
                }
                return 0;
            }
        };
        this.lookup = new Lookup(){

            @Override
            public int invoke(DoubleByReference dval, PointerByReference sval, TableInfo ti) {
                return -1;
            }
        };
        this.adjustMaxrows = new AdjustMaxrows(){

            @Override
            public NativeLong invoke(TableInfo ti, NativeLong newMaxrows) {
                return ti.maxrows;
            }
        };
        this.colAlloc = new ColAlloc(){

            @Override
            public Pointer invoke(TableInfo ti, int ncol, int sval) {
                DBCol.ByReference[] cols = ti.dbcols.toArray(ti.ncols);
                if (sval != 0) {
                    cols[ncol].sval = new Memory((long)Native.POINTER_SIZE);
                    return cols[ncol].sval;
                }
                cols[ncol].dval = new Memory((long)DOUBLE_SIZE);
                return cols[ncol].dval;
            }
        };
    }

    private void initializeForWrite(Table table, DBCol.ByReference[] cols) {
        this.flags = OUT;
        ArrayList<Object> data = new ArrayList<Object>();
        TableMap map = (TableMap)table.map();
        map.collectData(map.sampl(), data);
        int numRows = data.size() / (this.ncols + 1);
        this.maxrows = this.nrows = new NativeLong((long)numRows);
        String[][] sval = new String[cols.length][];
        boolean isTuple = this.arity != 1;
        int i = 0;
        while (i < numRows) {
            int start = i * (this.ncols + 1);
            Object key = data.get(start);
            if (isTuple) {
                Tuple tuple = (Tuple)key;
                int j = 0;
                while (j < this.arity) {
                    this.setValue(cols, sval, i, j, tuple.get(j), numRows);
                    ++j;
                }
            } else {
                this.setValue(cols, sval, i, 0, key, numRows);
            }
            ++start;
            int j = 0;
            while (j < this.ncols) {
                this.setValue(cols, sval, i, this.arity + j, data.get(start + j), numRows);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < cols.length) {
            if (sval[j] != null) {
                cols[j].sval = new StringArray(sval[j]);
            }
            ++j;
        }
    }

    public TableInfo(Table table, List<Column> dataCols, boolean read) throws SAMPLException {
        Object tableDir;
        TableMap map = (TableMap)table.map();
        this.tname = map.name();
        String[] strings = table.getStrings();
        if (strings.length == 0) {
            strings = new String[]{String.valueOf(this.tname) + ".tab"};
        }
        if ((tableDir = ((ProblemMap)map.sampl().getCurrentProblem().map()).getOption("table_dir")) != null) {
            strings[0] = new File(tableDir.toString(), strings[0]).toString();
        }
        this.strings = new StringArray(strings);
        this.nstrings = strings.length;
        this.arity = table.getNumKeyCols();
        this.ncols = dataCols.size();
        int totalNumCols = this.arity + this.ncols;
        String[] colnames = Arrays.copyOf(table.getKeyColNames(), totalNumCols);
        int i = 0;
        while (i < this.ncols) {
            colnames[this.arity + i] = dataCols.get(i).getName();
            ++i;
        }
        this.colnames = new StringArray(colnames);
        this.missing = new Memory(1L);
        final ArrayList memory = new ArrayList();
        this.tmi = new TMInfo(){

            @Override
            public Pointer invoke(long size) {
                Memory mem = new Memory(size);
                memory.add(mem);
                return mem;
            }
        };
        this.dbcols = new DBCol.ByReference();
        DBCol.ByReference[] cols = this.dbcols.toArray(totalNumCols);
        if (read) {
            this.initializeForRead(table, cols);
        } else {
            this.initializeForWrite(table, cols);
        }
    }

    private static interface AddRows
    extends Callback {
        public int invoke(TableInfo var1, DBCol var2, NativeLong var3);
    }

    private static interface AdjustMaxrows
    extends Callback {
        public NativeLong invoke(TableInfo var1, NativeLong var2);
    }

    private static interface ColAlloc
    extends Callback {
        public Pointer invoke(TableInfo var1, int var2, int var3);
    }

    private static interface Lookup
    extends Callback {
        public int invoke(DoubleByReference var1, PointerByReference var2, TableInfo var3);
    }
}

