/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import sampl.Integrality;
import sampl.SAMPLException;
import sampl.lang.Entity;
import sampl.lang.SAMPL;
import sampl.lang.Variable;

public class VariableMap
extends Entity<Variable> {
    private Integrality type;
    private int scenarioIndex;
    private boolean needsExpand;
    private boolean expanded;

    protected void doExpand() {
    }

    int getScenarioIndex() {
        return this.scenarioIndex;
    }

    public VariableMap(SAMPL sampl, String name, Integrality integrality, int scenarioIndex) {
        super(sampl, name);
        this.type = integrality;
        this.scenarioIndex = scenarioIndex;
    }

    public VariableMap(SAMPL sampl, String name, Integrality integrality) {
        this(sampl, name, integrality, -1);
    }

    public VariableMap(SAMPL sampl, String name) {
        this(sampl, name, Integrality.CONTINUOUS, -1);
    }

    public final Variable addVariable(Object key, double lb, double ub, double init) {
        Variable v = new Variable(this, key, lb, ub, init);
        this.map.put(key, v);
        return v;
    }

    public final Variable addVariable(Object key, double value) {
        Variable v = new Variable(this, key, value);
        this.map.put(key, v);
        return v;
    }

    public static Variable newVariable(SAMPL sampl, String name, double lb, double ub, double init) {
        return VariableMap.newVariable(sampl, name, lb, ub, init, Integrality.CONTINUOUS);
    }

    public static Variable newVariable(SAMPL sampl, String name, double lb, double ub, double init, Integrality integrality) {
        VariableMap map = new VariableMap(sampl, name, integrality);
        return map.addVariable(null, lb, ub, init);
    }

    public void setNeedsExpand() {
        this.needsExpand = true;
    }

    public boolean needsExpand() {
        return this.needsExpand;
    }

    public Integrality getType() {
        return this.type;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public double getValue(Object key) throws SAMPLException {
        return ((Variable)this.get(key)).val();
    }

    public boolean put(Object key, double value) {
        this.update();
        Variable var = (Variable)this.map.get(key);
        if (var != null) {
            var.setValue(value);
            return true;
        }
        return false;
    }

    public final void expand() {
        if (this.expanded) {
            return;
        }
        this.doExpand();
        this.expanded = true;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.expanded = !this.needsExpand;
    }

    public void fix() {
        for (Variable var : this.map.values()) {
            var.fix();
        }
    }

    public void fix(double value) {
        for (Variable var : this.map.values()) {
            var.fix(value);
        }
    }

    public void unfix() {
        for (Variable var : this.map.values()) {
            var.unfix();
        }
    }

    public void unfix(double value) {
        for (Variable var : this.map.values()) {
            var.unfix(value);
        }
    }
}

