/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import sampl.Integrality;
import sampl.SAMPLException;
import sampl.Util;
import sampl.lang.AStatus;
import sampl.lang.DiscreteRV;
import sampl.lang.ExprVisitor;
import sampl.lang.IVariable;
import sampl.lang.MapItem;
import sampl.lang.NLConnection;
import sampl.lang.SStatus;
import sampl.lang.VariableMap;

public final class Variable
implements IVariable {
    private VariableMap map;
    private Object key;
    private int index;
    private double val;
    private double init;
    private double lb;
    private double ub;
    private double lrc;
    private double urc;
    private int defeqn;
    private int stage = 1;
    private int astatus;
    private int sstatus;
    private Map<String, Object> suffixes;
    private static final int ASTATUS_FIX = AStatus.FIX.ordinal();
    private static final int ASTATUS_UNUSED = AStatus.UNUSED.ordinal();

    Variable(VariableMap map, Object key, double lb, double ub, double init) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        this.map = map;
        this.key = key;
        this.lb = lb;
        this.ub = ub;
        this.val = this.init = init;
        this.astatus = ASTATUS_UNUSED;
    }

    Variable(VariableMap map, Object key, double value) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        this.map = map;
        this.key = key;
        this.lb = value;
        this.ub = value;
        this.init = 0.0;
        this.val = value;
        this.astatus = ASTATUS_UNUSED;
    }

    int index() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public VariableMap map() {
        return this.map;
    }

    @Override
    public double val() {
        return this.val;
    }

    public void setValue(double val) {
        this.val = val;
    }

    public double init() {
        return this.init;
    }

    public double init0() {
        return this.init;
    }

    public double lb() {
        return this.astatus != ASTATUS_FIX ? this.lb : this.val;
    }

    void setLB(double lb) {
        this.lb = lb;
    }

    DiscreteRV randomlb() {
        return (DiscreteRV)this.getSuffix("randomlb");
    }

    void setLB(DiscreteRV lb) {
        this.lb = Double.NaN;
        this.setSuffix("randomlb", lb);
    }

    boolean hasRandomLB() {
        return Double.isNaN(this.lb);
    }

    public double ub() {
        return this.astatus != ASTATUS_FIX ? this.ub : this.val;
    }

    void setUB(double ub) {
        this.ub = ub;
    }

    DiscreteRV randomub() {
        return (DiscreteRV)this.getSuffix("randomub");
    }

    void setUB(DiscreteRV ub) {
        this.ub = Double.NaN;
        this.setSuffix("randomub", ub);
    }

    boolean hasRandomUB() {
        return Double.isNaN(this.ub);
    }

    public double lb0() {
        return this.lb;
    }

    public double ub0() {
        return this.ub;
    }

    public double lb1() {
        return this.lb();
    }

    public double ub1() {
        return this.ub();
    }

    public double lb2() {
        return this.lb();
    }

    public double ub2() {
        return this.ub();
    }

    public double lslack() {
        return this.val - this.lb;
    }

    public double uslack() {
        return this.ub - this.val;
    }

    public double slack() {
        return Math.min(this.lslack(), this.uslack());
    }

    public double lrc() {
        return this.lrc;
    }

    void setLRC(double value) {
        this.lrc = value;
    }

    public double urc() {
        return this.urc;
    }

    void setURC(double value) {
        this.urc = value;
    }

    public double rc() {
        return this.val - this.lb <= this.ub - this.val ? this.lrc : this.urc;
    }

    public int defeqn() {
        return this.defeqn;
    }

    public double defeqnInternal() {
        return this.defeqn;
    }

    void setDefEqn(int index) {
        this.defeqn = index;
    }

    public double dual() throws SAMPLException {
        return this.defeqn != 0 ? this.map.sampl()._con.get(this.defeqnInternal()).dual() : 0.0;
    }

    public AStatus astatus() {
        return AStatus.map[this.astatus];
    }

    public String astatusInternal() {
        return this.astatus().toString().toLowerCase();
    }

    void setAStatus(AStatus s) {
        this.astatus = s.ordinal();
    }

    public SStatus sstatus() {
        return SStatus.map[this.sstatus];
    }

    public String sstatusInternal() {
        return this.sstatus().toString().toLowerCase();
    }

    void setSStatus(SStatus s) {
        this.sstatus = s.ordinal();
    }

    public Object status() {
        AStatus s = this.astatus();
        return s != AStatus.IN ? s : this.sstatus();
    }

    public String statusInternal() {
        return this.status().toString().toLowerCase();
    }

    public int stage() {
        return this.stage;
    }

    public void setStage(int value) {
        this.stage = value;
    }

    public double stageInternal() {
        return this.stage;
    }

    public void stageInternal(double value) {
        this.stage = (int)value;
    }

    public void fix() {
        if (this.val <= this.lb) {
            this.val = this.lb;
        } else if (this.val >= this.ub) {
            this.val = this.ub;
        }
        this.astatus = ASTATUS_FIX;
    }

    public void fix(double value) {
        this.val = value;
        this.fix();
    }

    public void unfix() {
        this.astatus = ASTATUS_UNUSED;
    }

    public void unfix(double value) {
        this.val = value;
        if (this.val <= this.lb) {
            this.val = this.lb;
        } else if (this.val >= this.ub) {
            this.val = this.ub;
        }
        this.astatus = ASTATUS_UNUSED;
    }

    public String name() {
        return MapItem.name(this.map, this.key, this.map.getScenarioIndex());
    }

    public Object getSuffix(String name) {
        return this.suffixes != null ? this.suffixes.get(name) : null;
    }

    public Object setSuffix(String name, Object value) {
        if (this.suffixes == null) {
            this.suffixes = new HashMap<String, Object>();
        }
        return this.suffixes.put(name, value);
    }

    public String toString() {
        Integrality integrality;
        StringBuilder sb = new StringBuilder();
        sb.append("var ");
        sb.append(this.name());
        if (this.lb != this.ub) {
            if (this.lb != Double.NEGATIVE_INFINITY) {
                sb.append(" >= ");
                sb.append(Util.format(this.lb));
            }
            if (this.ub != Double.POSITIVE_INFINITY) {
                sb.append(" <= ");
                sb.append(Util.format(this.ub));
            }
        } else {
            sb.append(" = ");
            sb.append(Util.format(this.lb));
        }
        if ((integrality = this.map().getType()) == Integrality.INTEGER) {
            sb.append(" integer");
        } else if (integrality == Integrality.BINARY) {
            sb.append(" binary");
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public boolean hasVariables() {
        return true;
    }

    @Override
    public double eval() {
        return this.val;
    }

    @Override
    public void accept(ExprVisitor v) {
        v.visit(this);
    }

    @Override
    public void write(NLConnection c) throws IOException {
        c.write(this);
    }
}

