/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sampl.SAMPLException;
import sampl.lang.BinaryExpr;
import sampl.lang.CallExpr;
import sampl.lang.Constraint;
import sampl.lang.DiscreteRV;
import sampl.lang.ExpandedProblem;
import sampl.lang.Expr;
import sampl.lang.LinearTerm;
import sampl.lang.MPSConnection;
import sampl.lang.NoDataException;
import sampl.lang.Objective;
import sampl.lang.ObjectiveMap;
import sampl.lang.Parameter;
import sampl.lang.Problem;
import sampl.lang.ProblemMap;
import sampl.lang.RandomExprPartitioner;
import sampl.lang.RandomLinearTerm;
import sampl.lang.SolutionReader;
import sampl.lang.SolverConnection;
import sampl.lang.Variable;
import sampl.lang.WeightedSum;

class SMPSConnection
extends MPSConnection {
    private VariableInfo[] varInfo;
    private ObjectiveInfo[] objInfo;
    private ConstraintInfo[] conInfo;
    private int numStages;
    private Parameter prob;
    private List<ChanceConstraint> chanceCons = new ArrayList<ChanceConstraint>();
    private List<ChanceConstraint> iccs = new ArrayList<ChanceConstraint>();

    SMPSConnection() {
    }

    private void writeData(String code, String name1, String name2, double value, String name3) {
        this.writeData(code, name1, name2, SMPSConnection.format(value), name3);
    }

    private static String getScenarioName(int index) {
        return String.format("SCEN%d", index + 1);
    }

    private int linearizeConstraint(List<Constraint> cons, int index) {
        Constraint con = cons.get(index);
        Expr nonlinear = con.getNonlinear();
        if (nonlinear == null && !con.hasRandomLB() && !con.hasRandomUB()) {
            return 1;
        }
        if (this.conInfo[index] == null) {
            this.conInfo[index] = new ConstraintInfo(con, null);
        }
        int stage = 1;
        double constant = 0.0;
        DiscreteRV randomConstant = null;
        if (nonlinear != null) {
            boolean ccOrICC = nonlinear instanceof CallExpr;
            if (ccOrICC) {
                CallExpr call = (CallExpr)nonlinear;
                BinaryExpr binary = (BinaryExpr)call.arg();
                if (binary.getOpCode() == 6) {
                    nonlinear = WeightedSum.newSubtraction(binary.getRHS(), binary.getLHS());
                    this.iccs.add(new ChanceConstraint(index, con.ub()));
                } else {
                    nonlinear = WeightedSum.newSubtraction(binary.getLHS(), binary.getRHS());
                    this.chanceCons.add(new ChanceConstraint(index, con.lb()));
                }
                con.setBounds(0.0, Double.POSITIVE_INFINITY);
                this.conInfo[index] = new ConstraintInfo(con, null);
            }
            RandomExprPartitioner partitioner = new RandomExprPartitioner();
            partitioner.partition(nonlinear);
            List<RandomLinearTerm> randomLinear = partitioner.getRandomLinear();
            List<LinearTerm> linear = partitioner.getLinear();
            if (randomLinear != null || linear != null) {
                ArrayList<LinearTerm> mergedLinear;
                stage = 2;
                this.conInfo[index].randomLinear = randomLinear;
                List oldLinear = con.getLinear();
                int numRandomTerms = 0;
                if (randomLinear != null) {
                    numRandomTerms = randomLinear.size();
                }
                if (linear != null) {
                    numRandomTerms += linear.size();
                }
                if (oldLinear != null) {
                    mergedLinear = new ArrayList(numRandomTerms + oldLinear.size());
                    mergedLinear.addAll(oldLinear);
                } else {
                    mergedLinear = new ArrayList<LinearTerm>(numRandomTerms);
                }
                if (linear != null) {
                    mergedLinear.addAll(linear);
                }
                if (randomLinear != null) {
                    for (RandomLinearTerm term : randomLinear) {
                        double coef = term.getCoefficient().getRealization(0);
                        mergedLinear.add(new LinearTerm(coef, term.getVariable()));
                    }
                }
                con.setLinear(mergedLinear);
                con.setNonlinear(partitioner.getNonlinear());
            }
            constant = partitioner.getConstant();
            randomConstant = partitioner.getRandomConstant();
            if (ccOrICC) {
                if (randomConstant != null) {
                    DiscreteRV rv;
                    this.conInfo[index].randomlb = rv = randomConstant.add(constant);
                    con.setLB(rv.getRealization(0));
                } else {
                    con.setLB(constant);
                }
            } else if (constant != 0.0 || randomConstant != null) {
                throw new AssertionError((Object)"Constraint expression is not normalized");
            }
        }
        if (con.hasRandomLB()) {
            DiscreteRV rv;
            stage = 2;
            this.conInfo[index].randomlb = rv = con.randomlb();
            con.setLB(rv.getRealization(0));
        }
        if (con.hasRandomUB()) {
            DiscreteRV rv;
            stage = 2;
            this.conInfo[index].randomub = rv = con.randomub();
            con.setUB(rv.getRealization(0));
        }
        return stage;
    }

    private void writeScenarios() throws NoDataException {
        Double value;
        this.writeHeader("SCENARIOS", "DISCRETE");
        Iterator it = this.prob.entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry entry = it.next();
            value = (Double)entry.getValue();
            if (value == null) {
                throw new NoDataException(this.prob, entry.getKey());
            }
            this.writeData("SC", SMPSConnection.getScenarioName(0), "'ROOT'", value, "STAGE1");
        }
        int i = 1;
        while (it.hasNext()) {
            int index;
            Object info;
            value = (Double)it.next().getValue();
            this.writeData("SC", SMPSConnection.getScenarioName(i), SMPSConnection.getScenarioName(i - 1), value, "STAGE2");
            int j = 0;
            int n = this.varInfo.length;
            while (j < n) {
                info = this.varInfo[j];
                if (info != null) {
                    if (((VariableInfo)info).randomlb != null) {
                        this.writeBound("LO", j, ((VariableInfo)info).randomlb.getRealization(i));
                    }
                    if (((VariableInfo)info).randomub != null) {
                        this.writeBound("UP", j, ((VariableInfo)info).randomub.getRealization(i));
                    }
                }
                ++j;
            }
            j = 0;
            n = this.objInfo.length;
            while (j < n) {
                info = this.objInfo[j];
                if (info != null && ((ObjectiveInfo)info).randomLinear != null) {
                    for (RandomLinearTerm term : ((ObjectiveInfo)info).randomLinear) {
                        index = term.getVariable().index();
                        this.writeData(SMPSConnection.getColName(index), SMPSConnection.getRowName(this.conInfo.length + j), term.getCoefficient().getRealization(i));
                    }
                }
                ++j;
            }
            j = 0;
            n = this.conInfo.length;
            while (j < n) {
                info = this.conInfo[j];
                if (info != null) {
                    if (((ConstraintInfo)info).randomLinear != null) {
                        for (RandomLinearTerm term : ((ConstraintInfo)info).randomLinear) {
                            index = term.getVariable().index();
                            this.writeData(SMPSConnection.getColName(index), SMPSConnection.getRowName(j), term.getCoefficient().getRealization(i));
                        }
                    }
                    if (((ConstraintInfo)info).randomlb != null) {
                        double range;
                        double lb = ((ConstraintInfo)info).randomlb.getRealization(i);
                        this.writeData("B", SMPSConnection.getRowName(j), lb);
                        if (((ConstraintInfo)info).randomub != null && (range = ((ConstraintInfo)info).randomub.getRealization(i) - lb) != 0.0) {
                            this.writeData("RANGE", SMPSConnection.getRowName(j), range);
                        }
                    } else if (((ConstraintInfo)info).randomub != null) {
                        this.writeData("B", SMPSConnection.getRowName(j), ((ConstraintInfo)info).randomub.getRealization(i));
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    boolean convert(Problem p) throws SAMPLException {
        Problem.Instance pi = p.expand();
        this.numStages = 1;
        int[] stageOffsets = new int[this.numStages + 1];
        for (Variable var : pi.variables()) {
            int stage = var.stage();
            if (stage > this.numStages) {
                this.numStages = stage;
                stageOffsets = Arrays.copyOf(stageOffsets, this.numStages + 1);
            }
            int n = stage;
            stageOffsets[n] = stageOffsets[n] + 1;
        }
        int i = 1;
        while (i <= this.numStages) {
            int n = i;
            stageOffsets[n] = stageOffsets[n] + stageOffsets[i - 1];
            ++i;
        }
        List<Variable> vars = pi.variables();
        Variable[] unorderedVars = new Variable[vars.size()];
        vars.toArray(unorderedVars);
        Variable[] variableArray = unorderedVars;
        int n = unorderedVars.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            Variable var = variableArray[n2];
            int n3 = var.stage() - 1;
            stageOffsets[n3] = stageOffsets[n3] + 1;
            var.setIndex(index);
            vars.set(index, var);
            ++n2;
        }
        this.prob = p.probabilities();
        List<Objective> objs = pi.objectives();
        this.objInfo = new ObjectiveInfo[objs.size()];
        int i2 = 0;
        int n4 = objs.size();
        while (i2 < n4) {
            Objective obj = objs.get(i2);
            Expr nonlinearObj = obj.getNonlinear();
            if (nonlinearObj != null) {
                Object random;
                RandomExprPartitioner partitioner = new RandomExprPartitioner();
                nonlinearObj.accept(partitioner);
                List<RandomLinearTerm> randomLinear = partitioner.getRandomLinear();
                this.objInfo[i2] = new ObjectiveInfo(obj, randomLinear);
                List linearObj = obj.getLinear();
                if (randomLinear != null) {
                    List<LinearTerm> mergedLinear;
                    int numRandomTerms = randomLinear.size();
                    if (linearObj != null) {
                        mergedLinear = new ArrayList(numRandomTerms + linearObj.size());
                        mergedLinear.addAll(linearObj);
                    } else {
                        mergedLinear = new ArrayList<LinearTerm>(numRandomTerms);
                    }
                    int j = 0;
                    while (j < randomLinear.size()) {
                        RandomLinearTerm term = randomLinear.get(j);
                        DiscreteRV coef = term.getCoefficient();
                        Variable var = term.getVariable();
                        if (var.stage() == 1) {
                            mergedLinear.add(new LinearTerm(coef.computeExpectation(this.prob), var));
                            randomLinear.remove(j--);
                        } else {
                            mergedLinear.add(new LinearTerm(coef.getRealization(0), var));
                        }
                        ++j;
                    }
                    mergedLinear = LinearTerm.combineLikeTerms(mergedLinear);
                    obj.setLinear(mergedLinear);
                }
                if ((random = partitioner.getRandomConstant()) != null) {
                    obj.setConstant(obj.constant() + ((DiscreteRV)random).computeExpectation(this.prob));
                }
                obj.setNonlinear(partitioner.getNonlinear());
            }
            ++i2;
        }
        this.varInfo = new VariableInfo[vars.size()];
        i2 = 0;
        n4 = vars.size();
        while (i2 < n4) {
            Variable var = vars.get(i2);
            if (var.stage() != 1) {
                this.varInfo[i2] = new VariableInfo(var);
                if (var.hasRandomLB()) {
                    DiscreteRV rv;
                    this.varInfo[i2].randomlb = rv = var.randomlb();
                    var.setLB(rv.getRealization(0));
                }
                if (var.hasRandomUB()) {
                    DiscreteRV rv;
                    this.varInfo[i2].randomub = rv = var.randomub();
                    var.setUB(rv.getRealization(0));
                }
            }
            ++i2;
        }
        stageOffsets = new int[this.numStages + 1];
        List<Constraint> cons = pi.constraints();
        this.conInfo = new ConstraintInfo[cons.size()];
        int i3 = 0;
        int n5 = cons.size();
        while (i3 < n5) {
            int stage = this.linearizeConstraint(cons, i3);
            Constraint con = cons.get(i3);
            List linear = con.getLinear();
            if (linear != null) {
                for (LinearTerm term : linear) {
                    stage = Math.max(stage, term.getVariable().stage());
                }
            }
            if (stage != 1) {
                if (this.conInfo[i3] == null) {
                    this.conInfo[i3] = new ConstraintInfo(con, null);
                }
                this.conInfo[i3].stage = stage;
            }
            if (stage > this.numStages) {
                this.numStages = stage;
                stageOffsets = Arrays.copyOf(stageOffsets, this.numStages + 1);
            }
            int n6 = stage;
            stageOffsets[n6] = stageOffsets[n6] + 1;
            ++i3;
        }
        i3 = 1;
        while (i3 <= this.numStages) {
            int n7 = i3;
            stageOffsets[n7] = stageOffsets[n7] + stageOffsets[i3 - 1];
            ++i3;
        }
        Constraint[] unorderedCons = new Constraint[cons.size()];
        ConstraintInfo[] unorderedInfo = Arrays.copyOf(this.conInfo, this.conInfo.length);
        cons.toArray(unorderedCons);
        int i4 = 0;
        int n8 = cons.size();
        while (i4 < n8) {
            int index;
            ConstraintInfo info = unorderedInfo[i4];
            int stage = info != null ? info.stage : 1;
            int n9 = stage - 1;
            stageOffsets[n9] = stageOffsets[n9] + 1;
            cons.set(index, unorderedCons[i4]);
            this.conInfo[index] = unorderedInfo[i4];
            ++i4;
        }
        return true;
    }

    @Override
    void restore() {
        Object[] objectArray = this.varInfo;
        int n = this.varInfo.length;
        int n2 = 0;
        while (n2 < n) {
            VariableInfo vi = objectArray[n2];
            if (vi != null) {
                vi.var.setLB(vi.lb);
                vi.var.setUB(vi.ub);
            }
            ++n2;
        }
        objectArray = this.objInfo;
        n = this.objInfo.length;
        n2 = 0;
        while (n2 < n) {
            Object oi = objectArray[n2];
            if (oi != null) {
                ((ObjectiveInfo)oi).obj.setLinear(((ObjectiveInfo)oi).originalLinear);
                ((ObjectiveInfo)oi).obj.setNonlinear(((ObjectiveInfo)oi).originalNonlinear);
                ((ObjectiveInfo)oi).obj.setConstant(((ObjectiveInfo)oi).constant);
            }
            ++n2;
        }
        objectArray = this.conInfo;
        n = this.conInfo.length;
        n2 = 0;
        while (n2 < n) {
            Object ci = objectArray[n2];
            if (ci != null) {
                ((ConstraintInfo)ci).con.setLinear(((ConstraintInfo)ci).originalLinear);
                ((ConstraintInfo)ci).con.setNonlinear(((ConstraintInfo)ci).originalNonlinear);
                ((ConstraintInfo)ci).con.setBounds(((ConstraintInfo)ci).lb, ((ConstraintInfo)ci).ub);
            }
            ++n2;
        }
    }

    @Override
    void writeExpanded(ExpandedProblem ep, SolverConnection.WriterProvider wp) throws IOException, SAMPLException {
        this.writeMPS(ep, wp, ".cor", false);
        String problemName = wp.filenameWithoutExt();
        Constraint[] cons = ep.getConstraints();
        this.writer = new PrintWriter(wp.newWriter(".sto"));
        try {
            this.writeHeader("STOCH", problemName);
            if (!this.chanceCons.isEmpty()) {
                this.writeHeader("CHANCE");
                for (ChanceConstraint cc : this.chanceCons) {
                    this.writeData("G", "CC1", SMPSConnection.getRowName(cc.index), cc.rhs, null);
                }
            }
            if (!this.iccs.isEmpty()) {
                this.writeHeader("ICC");
                for (ChanceConstraint cc : this.iccs) {
                    this.writeData("L", "ICC1", SMPSConnection.getRowName(cc.index), cc.rhs, null);
                }
            }
            if (this.numStages > 1) {
                this.writeScenarios();
            }
            this.writeHeader("ENDATA");
        }
        finally {
            this.writer.close();
        }
        this.writer = new PrintWriter(wp.newWriter(".tim"));
        try {
            this.writeHeader("TIME", problemName);
            this.writeHeader("PERIODS", "EXPLICIT");
            int i = 0;
            while (i < this.numStages) {
                this.writeData("", "", "STAGE" + (i + 1));
                ++i;
            }
            this.writeHeader("ROWS");
            i = 0;
            int n = cons.length;
            while (i < n) {
                ConstraintInfo info = this.conInfo[i];
                int stage = info != null ? info.stage : 1;
                this.writeData(SMPSConnection.getRowName(i), "STAGE" + stage, null);
                ++i;
            }
            i = 0;
            n = ep.getObjectives().length;
            while (i < n) {
                this.writeData(SMPSConnection.getRowName(cons.length + i), "STAGE1", null);
                ++i;
            }
            this.writeHeader("COLUMNS");
            int index = 0;
            Variable[] variableArray = ep.getVariables();
            int n2 = variableArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Variable var = variableArray[n3];
                this.writeData(SMPSConnection.getColName(index++), "STAGE" + var.stage(), null);
                ++n3;
            }
            this.writeHeader("ENDATA");
        }
        finally {
            this.writer.close();
        }
    }

    @Override
    void readSolution(Problem p, String filename) throws IOException {
        SolutionReader reader = new SolutionReader();
        reader.read(filename, Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (((ProblemMap)p.map()).getBooleanOption("solver_msg")) {
            System.out.print(reader.getMessage());
        }
        ExpandedProblem ep = this.expandedProblem();
        Variable[] vars = ep.getVariables();
        int numVars = vars.length;
        double[] primal = reader.getVarSolution().values;
        int numPrimals = Math.min(numVars, primal.length);
        int i = 0;
        while (i < numVars) {
            double value = i < numPrimals ? primal[i] : 0.0;
            Variable var = vars[i];
            var.setValue(value);
            var.setLRC(0.0);
            var.setURC(0.0);
            ++i;
        }
        Objective obj = null;
        Objective[] objs = ep.getObjectives();
        boolean maximization = false;
        if (objs.length != 0) {
            obj = objs[0];
            maximization = ((ObjectiveMap)obj.map()).isMaximization();
            obj.setValue(reader.getObjValue());
        }
        int i2 = 0;
        double[] dual = reader.getConSolution().dualValues;
        Constraint[] cons = ep.getConstraints();
        int numDual = Math.min(cons.length, dual.length);
        Constraint[] constraintArray = cons;
        int n = cons.length;
        int n2 = 0;
        while (n2 < n) {
            int stage;
            Constraint con = constraintArray[n2];
            ConstraintInfo info = this.conInfo[i2];
            int n3 = stage = info != null ? info.stage : 1;
            if (stage == 1) {
                con.computeBodyAndDuals(i2 < numDual ? dual[i2] : 0.0, maximization);
            }
            ++i2;
            ++n2;
        }
        ((ProblemMap)p.map()).sampl().setSolveResult(reader.getResult());
    }

    private class ChanceConstraint {
        int index;
        double rhs;

        ChanceConstraint(int index, double rhs) {
            this.index = index;
            this.rhs = rhs;
        }
    }

    private static class ConstraintInfo {
        Constraint con;
        List<LinearTerm> originalLinear;
        Expr originalNonlinear;
        List<RandomLinearTerm> randomLinear;
        double lb;
        double ub;
        DiscreteRV randomlb;
        DiscreteRV randomub;
        int stage = 1;

        ConstraintInfo(Constraint c, List<RandomLinearTerm> randomLinear) {
            this.con = c;
            this.originalLinear = c.getLinear();
            this.originalNonlinear = c.getNonlinear();
            this.randomLinear = randomLinear;
            this.lb = c.lb();
            this.ub = c.ub();
        }
    }

    private static class ObjectiveInfo {
        Objective obj;
        List<LinearTerm> originalLinear;
        Expr originalNonlinear;
        double constant;
        List<RandomLinearTerm> randomLinear;

        ObjectiveInfo(Objective o, List<RandomLinearTerm> randomLinear) {
            this.obj = o;
            this.originalLinear = o.getLinear();
            this.originalNonlinear = o.getNonlinear();
            this.constant = o.constant();
            this.randomLinear = randomLinear;
        }
    }

    private static class VariableInfo {
        Variable var;
        double lb;
        double ub;
        DiscreteRV randomlb;
        DiscreteRV randomub;

        VariableInfo(Variable v) {
            this.var = v;
            this.lb = v.lb();
            this.ub = v.ub();
        }
    }
}

