/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import sampl.Environment;
import sampl.SAMPLException;
import sampl.Source;
import sampl.Tuple;
import sampl.Util;
import sampl.lang.Block;
import sampl.lang.Constraint;
import sampl.lang.ConstraintMap;
import sampl.lang.Entity;
import sampl.lang.Evaluable;
import sampl.lang.MPSConnection;
import sampl.lang.MapItem;
import sampl.lang.NLConnection;
import sampl.lang.Objective;
import sampl.lang.ObjectiveMap;
import sampl.lang.OutputCopier;
import sampl.lang.Parameter;
import sampl.lang.PiecewiseLinear;
import sampl.lang.Problem;
import sampl.lang.ProblemMap;
import sampl.lang.PromptHandler;
import sampl.lang.SMPSConnection;
import sampl.lang.SetMap;
import sampl.lang.SolverConnection;
import sampl.lang.StreamCopier;
import sampl.lang.Table;
import sampl.lang.TableMap;
import sampl.lang.Translator;
import sampl.lang.Tree;
import sampl.lang.Variable;
import sampl.lang.VariableMap;
import sampl.lang.asl.AMPLExports;

public final class SAMPL {
    private Environment env;
    private Translator translator;
    private Map<String, Entity<?>> entities;
    private Runnable resetHandler;
    PromptHandler promptHandler;
    private HashMap<String, BufferedReader> readers = new HashMap();
    private HashMap<String, PrintWriter> writers = new HashMap();
    public BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    public PrintWriter out = new PrintWriter(System.out, true);
    Problem problem;
    public List<Block> checks = new ArrayList<Block>();
    private boolean writeSolution;
    public static final String SAMPL_DIR = SAMPL.getSAMPLDir();
    ConstraintMap _con;
    Parameter _conname;
    public HandlerInfo _handler_desc;
    public HandlerInfo _handler_lib;
    public HandlerInfo _default_handler_path;
    public HANDLERS _HANDLERS;
    Parameter _ncons;
    Parameter _nobjs;
    Parameter _nvars;
    ObjectiveMap _obj;
    Parameter _objname;
    VariableMap _var;
    Parameter _varname;
    Problem Initial;
    Parameter solve_exitcode;
    Parameter solve_result_num;
    Parameter solve_result;
    public static final Set<Scenario> SCENARIO_SET = new HashSet<Scenario>(Arrays.asList(Scenario.INSTANCE));
    private Random random = new Random(0L);
    private AMPLExports amplExports;

    private static String getSAMPLDir() {
        try {
            return new File(SAMPL.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParent();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public Problem getCurrentProblem() {
        return this.problem;
    }

    public SAMPL() throws SAMPLException {
        this(new Environment());
    }

    public SAMPL(Environment env) throws SAMPLException {
        this.env = env;
        this.reset();
    }

    public ObjectiveMap _obj() {
        return this._obj;
    }

    public Parameter _objname() {
        return this._objname;
    }

    public VariableMap _var() {
        return this._var;
    }

    public Parameter _varname() {
        return this._varname;
    }

    public void interpretFile(String filename) throws IOException, SAMPLException {
        if (this.translator == null) {
            this.translator = new Translator(new Translator.Options(), null, this);
        }
        this.translator.run(Source.newFileSource(filename));
    }

    public void interpretString(String name, String input) throws IOException, SAMPLException {
        if (this.translator == null) {
            this.translator = new Translator(new Translator.Options(), null, this);
        }
        this.translator.run(Source.newStringSource(name, input));
    }

    public static void execute(Block b) throws SAMPLException {
        SAMPL sampl = new SAMPL();
        try {
            b.execute(sampl);
        }
        finally {
            sampl.close();
        }
    }

    public void setResetHandler(Runnable handler) {
        this.resetHandler = handler;
    }

    private void addPredefinedEntity(Entity<?> entity) {
        this.entities.put(entity.name(), entity);
    }

    public void addEntity(Parameter param) {
        this.entities.put(param.name(), param);
    }

    public void addProbability(Parameter param) {
        this.entities.put(param.name(), param);
        this.problem.setProbabilities(param);
    }

    public void addEntity(SetMap set) {
        this.entities.put(set.name(), set);
    }

    public void addEntity(VariableMap var) {
        this.entities.put(var.name(), var);
        var.addDependent(this.problem.map());
        this.problem.add(var);
    }

    public void addEntity(ObjectiveMap obj) {
        this.entities.put(obj.name(), obj);
        obj.addDependent(this.problem.map());
        this.problem.add(obj);
    }

    public void addEntity(ConstraintMap con) {
        this.entities.put(con.name(), con);
        con.addDependent(this.problem.map());
        this.problem.add(con);
    }

    public void addEntity(ProblemMap problem) throws SAMPLException {
        this.entities.put(problem.name(), problem);
        Iterator iterator = problem.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.problem = (Problem)entry.getValue();
        }
    }

    public void addEntity(TableMap table) {
        this.entities.put(table.name(), table);
    }

    public void addEntity(Tree tree) {
        this.entities.put(tree.name(), tree);
    }

    public Entity<?> getEntity(String name) {
        return this.entities.get(name);
    }

    public VariableMap getVariable(String name) {
        Entity<?> entity = this.entities.get(name);
        return entity instanceof VariableMap ? (VariableMap)entity : null;
    }

    public ObjectiveMap getObjective(String name) {
        Entity<?> entity = this.entities.get(name);
        return entity instanceof ObjectiveMap ? (ObjectiveMap)entity : null;
    }

    public ConstraintMap getConstraint(String name) {
        Entity<?> entity = this.entities.get(name);
        return entity instanceof ConstraintMap ? (ConstraintMap)entity : null;
    }

    public void reset() {
        this.entities = new HashMap();
        this._handler_desc = new HandlerInfo(this, "_handler_desc");
        this.addPredefinedEntity(this._handler_desc);
        this._handler_lib = new HandlerInfo(this, "_handler_lib");
        this.addPredefinedEntity(this._handler_lib);
        this._default_handler_path = new HandlerInfo(this, "_default_handler_path");
        this.addPredefinedEntity(this._default_handler_path);
        this._HANDLERS = new HANDLERS(this);
        this.addPredefinedEntity(this._HANDLERS);
        this._nvars = new Parameter(this, "_nvars", true){

            @Override
            protected void init() {
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                this.putInitial(null, pi.variables().size());
            }
        };
        this.addPredefinedEntity(this._nvars);
        this._var = new VariableMap(this, "_var"){

            @Override
            protected void init() {
                int index = 0;
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                for (Variable v : pi.variables()) {
                    this.map.put(Double.valueOf(++index), v);
                }
            }
        };
        this.addPredefinedEntity(this._var);
        this._varname = new Parameter(this, "_varname", true){

            @Override
            protected void init() {
                int index = 0;
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                for (Variable v : pi.variables()) {
                    this.map.put(Double.valueOf(++index), v.name());
                }
            }
        };
        this.addPredefinedEntity(this._varname);
        this._nobjs = new Parameter(this, "_nobjs", true){

            @Override
            protected void init() {
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                this.putInitial(null, pi.objectives().size());
            }
        };
        this.addPredefinedEntity(this._nobjs);
        this._obj = new ObjectiveMap(this, "_obj", false){

            @Override
            protected void init() {
                int index = 0;
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                for (Objective o : pi.objectives()) {
                    this.map.put(Double.valueOf(++index), o);
                }
            }
        };
        this.addPredefinedEntity(this._obj);
        this._objname = new Parameter(this, "_objname", true){

            @Override
            protected void init() {
                int index = 0;
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                for (Objective o : pi.objectives()) {
                    this.map.put(Double.valueOf(++index), o.name());
                }
            }
        };
        this.addPredefinedEntity(this._objname);
        this._ncons = new Parameter(this, "_ncons", true){

            @Override
            protected void init() {
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                this.putInitial(null, pi.constraints().size());
            }
        };
        this.addPredefinedEntity(this._ncons);
        this._con = new ConstraintMap(this, "_con", false){

            @Override
            protected void init() {
                int index = 0;
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                for (Constraint c : pi.constraints()) {
                    this.map.put(Double.valueOf(++index), c);
                }
            }
        };
        this.addPredefinedEntity(this._con);
        this._conname = new Parameter(this, "_conname", true){

            @Override
            protected void init() {
                int index = 0;
                Problem.Instance pi = this.sampl().getCurrentProblem().expand();
                for (Constraint c : pi.constraints()) {
                    this.map.put(new Double(++index), c.name());
                }
            }
        };
        this.addPredefinedEntity(this._conname);
        this.Initial = this.Initial == null ? ProblemMap.newProblem(this, "Initial") : ((ProblemMap)this.Initial.map()).reset();
        this.addPredefinedEntity(this.Initial.map());
        this.solve_exitcode = Parameter.newParameter(this, "solve_exitcode");
        this.addPredefinedEntity(this.solve_exitcode);
        this.solve_result_num = Parameter.newParameter(this, "solve_result_num");
        this.addPredefinedEntity(this.solve_result_num);
        this.solve_result = Parameter.newParameter(this, "solve_result");
        this.addPredefinedEntity(this.solve_result);
        this.problem = this.Initial;
        this.solve_result.put(null, "?");
        this.solve_result_num.put((Object)null, -1.0);
        this.solve_exitcode.put((Object)null, -1.0);
        this.random.setSeed(0L);
        if (this.resetHandler != null) {
            this.resetHandler.run();
        }
        this.checks.clear();
    }

    public static double piecewiseLinear(double[] breakpoints, double[] slopes, double value) {
        double[] intercepts = PiecewiseLinear.computeIntercepts(breakpoints, slopes);
        return PiecewiseLinear.getValue(breakpoints, slopes, intercepts, value);
    }

    public void shell(String command) throws IOException, InterruptedException {
        if (command == null) {
            String string = command = Platform.getOSType() != 2 ? "sh -i +m" : "cmd.exe";
        }
        if (this.promptHandler != null) {
            this.promptHandler.setPrompt("");
        }
        Process process = Runtime.getRuntime().exec(command);
        Thread outThread = new Thread(new OutputCopier(process));
        outThread.start();
        StreamCopier copier = new StreamCopier(System.in, process.getOutputStream());
        Thread inThread = new Thread(copier);
        inThread.start();
        process.waitFor();
        copier.stop = true;
        outThread.interrupt();
        outThread.join();
        if (this.promptHandler == null) {
            return;
        }
        this.promptHandler.setPrompt("sampl: ");
        if (copier.stopped) {
            return;
        }
        System.out.print("sampl: ");
        inThread.join();
    }

    public static double[] listToArray(List<Double> list) {
        int numItems = list.size();
        double[] array = new double[numItems];
        int i = 0;
        while (i < numItems) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public void expand(Writer out) throws IOException {
        this.problem.expand();
        for (ObjectiveMap objectiveMap : this.problem.objectives()) {
            objectiveMap.expand(out);
        }
        for (ConstraintMap constraintMap : this.problem.constraints()) {
            constraintMap.expand(out);
        }
    }

    void setSolveResult(int result) {
        this.solve_result_num.put((Object)null, result);
        String resultStr = result >= 0 && result < 100 ? "solved" : (result < 200 ? "solved?" : (result < 300 ? "infeasible" : (result < 400 ? "unbounded" : (result < 500 ? "limit" : "failure"))));
        this.solve_result.put(null, resultStr);
    }

    private void runSolver(Problem p, String filename, String ... args) throws IOException, InterruptedException, SAMPLException {
        int n;
        Process process;
        this.setSolveResult(999);
        this.solve_exitcode.put((Object)null, 383.0);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.redirectErrorStream(true);
        Map<String, String> env = pb.environment();
        for (Map.Entry<String, ProblemMap.Option> entry : ((ProblemMap)p.map()).options()) {
            env.put(entry.getKey(), entry.getValue().getValue().toString());
        }
        String binDir = new File(this.env.getBinDir()).getPath();
        File executable = new File(binDir, args[0]);
        if (executable.exists()) {
            args[0] = executable.getPath();
        } else {
            executable = new File(binDir, String.valueOf(args[0]) + ".exe");
            if (executable.exists()) {
                args[0] = executable.getPath();
            }
        }
        try {
            process = pb.command(args).start();
        }
        catch (IOException e) {
            throw new SAMPLException("Cannot run program \"" + args[0] + "\"");
        }
        process.getOutputStream().close();
        InputStreamReader in = new InputStreamReader(process.getInputStream());
        PrintWriter out = filename != null ? this.getWriter(filename, false) : this.out;
        char[] buffer = new char[4096];
        while ((n = in.read(buffer)) != -1) {
            int start = 0;
            while (start < n && buffer[start] == '\b') {
                ++start;
            }
            out.write(buffer, start, n - start);
            out.flush();
        }
        process.waitFor();
        this.solve_exitcode.put((Object)null, process.exitValue());
    }

    public void solve() throws IOException, SAMPLException, InterruptedException {
        this.solve((Problem)null, (String)null);
    }

    public void solve(Problem p, String filename) throws IOException, SAMPLException, InterruptedException {
        String outopt;
        if (p != null) {
            this.problem = p;
            this.problem.invalidate();
        } else {
            p = this.problem;
        }
        ProblemMap map = (ProblemMap)p.map();
        String solverName = map.getOption("solver").toString();
        boolean smps = "fortsp".toLowerCase().equals(solverName);
        String ext = smps ? ".cor" : ".nl";
        File stub = null;
        boolean keepSolution = false;
        if (this.writeSolution && !(outopt = map.getOption("outopt").toString()).isEmpty()) {
            stub = new File(String.valueOf(outopt.substring(1)) + ext);
            keepSolution = true;
        }
        if (stub == null) {
            stub = File.createTempFile("ampl", ext, new File("."));
        }
        String path = stub.getPath();
        String pathWithoutExt = path.substring(0, path.length() - ext.length());
        String solPath = null;
        if (!smps) {
            try {
                NLConnection solver = new NLConnection();
                solver.write(p, pathWithoutExt);
                solPath = String.valueOf(pathWithoutExt) + ".sol";
                this.runSolver(p, filename, solverName, path, "-AMPL");
                try {
                    solver.readSolution(p, solPath);
                }
                catch (FileNotFoundException e) {
                    String message = String.valueOf(solverName) + " hasn't produced a solution file";
                    if (solverName.endsWith("cplex")) {
                        message = String.valueOf(message) + "; you might need to use cplexamp instead of cplex";
                    }
                    throw new SAMPLException(message, e);
                }
            }
            catch (Throwable throwable) {
                if (!keepSolution) {
                    stub.delete();
                    if (solPath != null) {
                        new File(solPath).delete();
                    }
                }
                throw throwable;
            }
            if (!keepSolution) {
                stub.delete();
                if (solPath != null) {
                    new File(solPath).delete();
                }
            }
            return;
        }
        try {
            SMPSConnection solver = new SMPSConnection();
            solver.write(p, pathWithoutExt);
            List<Objective> objs = p.expand().objectives();
            boolean max = objs.isEmpty() ? false : ((ObjectiveMap)objs.get(0).map()).isMaximization();
            String s = max ? "maximize" : "minimize";
            Object options = map.getOption("fortsp_options");
            ArrayList<String> args = new ArrayList<String>(3);
            args.add(solverName);
            args.add("--smps-obj-sense=" + s);
            args.add("--sol-format=ampl");
            solPath = String.valueOf(pathWithoutExt) + ".sol";
            args.add("--sol-file=" + solPath);
            if (options != null) {
                String[] stringArray = ((String)options).split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    args.add("--" + option.replace('_', '-'));
                    ++n2;
                }
            }
            args.add(pathWithoutExt);
            String[] argArray = new String[args.size()];
            args.toArray(argArray);
            this.runSolver(p, filename, argArray);
            solver.readSolution(p, solPath);
        }
        finally {
            if (!keepSolution) {
                new File(String.valueOf(pathWithoutExt) + ".cor").delete();
                new File(String.valueOf(pathWithoutExt) + ".sto").delete();
                new File(String.valueOf(pathWithoutExt) + ".tim").delete();
                if (solPath != null) {
                    new File(solPath).delete();
                }
            }
        }
    }

    public void solve(Objective o, String filename) throws IOException, SAMPLException, InterruptedException {
        this.solve((Problem)null, filename);
    }

    public void solution(String filename) throws IOException, SAMPLException {
        SolverConnection sc = this.problem.probabilities() != null ? new SMPSConnection() : new NLConnection();
        sc.write(this.problem, (SolverConnection.WriterProvider)null);
        sc.readSolution(this.problem, filename);
    }

    public void write(String arg) throws SAMPLException, IOException {
        SolverConnection solver;
        if (arg == null || arg.isEmpty()) {
            throw new SAMPLException("Output type is not specified");
        }
        char type = arg.charAt(0);
        if (type == 'g') {
            solver = new NLConnection();
        } else if (type == 'm') {
            solver = new MPSConnection();
        } else if (type == 's') {
            solver = new SMPSConnection();
        } else {
            throw new SAMPLException("Invalid output type `" + type + "'");
        }
        this.writeSolution = true;
        ((ProblemMap)this.problem.map()).setOption("outopt", arg);
        solver.write(this.problem, arg.substring(1));
    }

    public double Normal(double mean, double variance) {
        return Math.sqrt(variance) * this.random.nextGaussian() + mean;
    }

    public double Normal01() {
        return this.random.nextGaussian();
    }

    public double Uniform(double a, double b) {
        return this.random.nextDouble() * (b - a) + a;
    }

    public double Uniform01() {
        return this.random.nextDouble();
    }

    void loadHandlers() {
        if (this.amplExports == null) {
            this.amplExports = new AMPLExports(this);
        }
    }

    public void read(Table t) throws SAMPLException {
        this.loadHandlers();
        this.amplExports.invokeTableHandlers(t, true);
    }

    public void read(TableMap map) throws SAMPLException {
        this.loadHandlers();
        for (Map.Entry entry : map.entrySet()) {
            this.amplExports.invokeTableHandlers((Table)entry.getValue(), true);
        }
    }

    public void write(Table t) throws SAMPLException {
        this.loadHandlers();
        this.amplExports.invokeTableHandlers(t, false);
    }

    public void write(TableMap map) throws SAMPLException {
        this.loadHandlers();
        for (Map.Entry entry : map.entrySet()) {
            this.amplExports.invokeTableHandlers((Table)entry.getValue(), false);
        }
    }

    private static void printOption(Writer out, String name, Object value) throws IOException {
        out.append("option ");
        out.append(name);
        if (value != null) {
            out.append(' ');
            if (value.equals("")) {
                out.append("''");
            } else {
                SAMPL.print(out, value);
            }
            out.append(';');
        } else {
            out.append(" ''; #not defined");
        }
        out.append(Util.NEWLINE);
    }

    public void option() throws IOException {
        for (Map.Entry<String, ProblemMap.Option> opt : ((ProblemMap)this.problem.map()).options()) {
            SAMPL.printOption(this.out, opt.getKey(), opt.getValue().getValue());
        }
    }

    public void option(ProblemMap map, String name) throws SAMPLException, IOException {
        if (map == null) {
            map = (ProblemMap)this.problem.map();
        }
        SAMPL.printOption(this.out, name, map.getOption(name));
    }

    public void option(ProblemMap map, String name, Object value) throws SAMPLException {
        if (map == null) {
            map = (ProblemMap)this.problem.map();
        }
        map.setOption(name, value);
    }

    public void setOption(String name, Object value) throws SAMPLException {
        ((ProblemMap)this.problem.map()).setOption(name, value);
    }

    public static void checkInteger(Parameter param, Object key) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value == null) {
            return;
        }
        double num = (Double)value;
        if (Math.rint(num) != num) {
            String name = MapItem.name(param, key);
            throw new SAMPLException(String.valueOf(name) + " is not integer");
        }
    }

    public static void checkBinary(Parameter param, Object key) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value == null) {
            return;
        }
        double num = (Double)value;
        if (num != 0.0 && num != 1.0) {
            String name = MapItem.name(param, key);
            throw new SAMPLException(String.valueOf(name) + " is not binary");
        }
    }

    public static void checkLess(Parameter param, Object key, double rhs) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value == null) {
            return;
        }
        double num = (Double)value;
        if (!(num < rhs)) {
            String name = MapItem.name(param, key);
            throw new SAMPLException(String.valueOf(name) + " is not < " + rhs);
        }
    }

    public static void checkLessEqual(Parameter param, Object key, double rhs) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value == null) {
            return;
        }
        double num = (Double)value;
        if (!(num <= rhs)) {
            String name = MapItem.name(param, key);
            throw new SAMPLException(String.valueOf(name) + " is not <= " + rhs);
        }
    }

    public static void checkGreater(Parameter param, Object key, double rhs) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value == null) {
            return;
        }
        double num = (Double)value;
        if (!(num > rhs)) {
            String name = MapItem.name(param, key);
            throw new SAMPLException(String.valueOf(name) + " is not > " + rhs);
        }
    }

    public static void checkGreaterEqual(Parameter param, Object key, double rhs) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value == null) {
            return;
        }
        double num = (Double)value;
        if (!(num >= rhs)) {
            String name = MapItem.name(param, key);
            throw new SAMPLException(String.valueOf(name) + " is not >= " + rhs);
        }
    }

    public static void checkNotEqual(Parameter param, Object key, double rhs) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value == null) {
            return;
        }
        double num = (Double)value;
        if (num == rhs) {
            String name = MapItem.name(param, key);
            throw new SAMPLException(String.valueOf(name) + " is not != " + rhs);
        }
    }

    public static void checkNotEqual(Parameter param, Object key, Object rhs) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value != null && value.equals(rhs)) {
            String name = MapItem.name(param, key);
            throw new SAMPLException(String.valueOf(name) + " is not != " + rhs);
        }
    }

    public static void checkIn(Parameter param, Object key, Set<?> set, String setName) throws SAMPLException {
        Object value = param.getUnchecked(key);
        if (value == null || set.contains(value)) {
            return;
        }
        String name = MapItem.name(param, key);
        throw new SAMPLException(String.valueOf(name) + " is not in " + setName);
    }

    public static void checkWithin(SetMap map, Object key, Set<?> set, String setName) throws SAMPLException {
        Set<?> value = map.getUnchecked(key);
        if (value == null || set.containsAll(value)) {
            return;
        }
        String name = MapItem.name(map, key);
        throw new SAMPLException(String.valueOf(name) + " is not within " + setName);
    }

    public static void checkIndexing(Parameter p, Set<Object> keys) {
        for (Map.Entry entry : p.entrySet()) {
            keys.remove(entry.getKey());
        }
        for (Object key : keys) {
            p.insert(key, null);
        }
    }

    public static void check(boolean value, String str) throws SAMPLException {
        if (!value) {
            throw new SAMPLException("check failed: " + str);
        }
    }

    public void runChecks() throws SAMPLException {
        for (Block check : this.checks) {
            check.execute(this);
        }
    }

    public static void printf(PrintWriter out, String format, Object ... args) {
        int argIndex = 0;
        int i = 0;
        int n = format.length();
        while (i < n) {
            char c = format.charAt(i);
            if (c == '%') {
                c = format.charAt(++i);
                switch (c) {
                    case 'X': 
                    case 'd': 
                    case 'o': 
                    case 'u': 
                    case 'x': {
                        Object arg = args[argIndex++];
                        if (arg instanceof Double) {
                            arg = (int)((Double)arg).doubleValue();
                        }
                        out.format("%" + c, arg);
                        break;
                    }
                    case '%': 
                    case 'E': 
                    case 'G': 
                    case 'Q': 
                    case 'c': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'q': 
                    case 's': {
                        out.format("%" + c, args[argIndex++]);
                    }
                }
            } else if (c == '\\') {
                if ((c = format.charAt(++i)) != 'n') {
                    out.print('\\');
                    out.print(c);
                } else {
                    out.println();
                }
            } else {
                out.print(c);
            }
            ++i;
        }
        out.flush();
    }

    public static void print(Exception e) {
        System.out.println(e.getMessage());
    }

    public static void print(PrintWriter out, double d) {
        out.print(Util.format(d));
    }

    public static void print(Writer out, Object obj) throws IOException {
        if (obj instanceof Double) {
            obj = Util.format((Double)obj);
        }
        out.append(Util.toSystemNewlines(obj.toString()));
    }

    public static void display(PrintWriter out, String prefix, boolean value) {
        out.print(prefix);
        out.println(value ? 1 : 0);
    }

    public static void display(PrintWriter out, Object key, boolean value) {
        out.print(key);
        out.print("  ");
        out.println(value);
    }

    public static void display(PrintWriter out, String prefix, double value) {
        out.print(prefix);
        out.println(Util.format(value));
    }

    public static void display(PrintWriter out, Object key, double value) {
        out.print(key);
        out.print("  ");
        out.println(value);
    }

    public static void display(PrintWriter out, String prefix, Object value) {
        out.print(prefix);
        out.println(value);
    }

    public static void display(PrintWriter out, Object key, Object value) {
        out.print(key);
        out.print("  ");
        out.println(value);
    }

    public static void display(PrintWriter out, String prefix, String value) {
        out.print(prefix);
        out.println(value);
    }

    public static void display(PrintWriter out, Object key, Set<Object> value) {
        out.print(key);
        out.print("  ");
        out.println(value);
    }

    public static void display(PrintWriter out, String prefix, Set<Object> set) throws IOException {
        out.print(prefix);
        boolean first = true;
        for (Object obj : set) {
            if (!first) {
                out.print(' ');
            } else {
                first = false;
            }
            SAMPL.print((Writer)out, obj);
        }
        out.println(';');
    }

    public static void display(PrintWriter out, SetMap map) {
        String prefix = "set " + map.name() + '[';
        for (Map.Entry entry : map.entrySet()) {
            out.print(prefix);
            out.print(SAMPL.formatKey(entry.getKey()));
            out.print("] :=");
            for (Object item : (Set)entry.getValue()) {
                out.print(' ');
                out.print(item);
            }
            out.println(";");
        }
    }

    public static void display(PrintWriter out, String prefix, Entity<?> entity, String suffix) throws Exception {
        entity.update();
        if (!entity.hasData()) {
            out.println("No data for " + entity.name());
            return;
        }
        out.println(prefix);
        Method method = null;
        for (Map.Entry<Object, ?> entry : entity.entrySet()) {
            Object key;
            Object value = entry.getValue();
            if (value == null) continue;
            if (suffix != null && method == null) {
                Class<?> cls = value.getClass();
                method = cls.getMethod(suffix, new Class[0]);
            }
            if ((key = entry.getKey()) instanceof Tuple) {
                Tuple tuple = (Tuple)key;
                int i = 0;
                int n = tuple.size();
                while (i < n) {
                    out.print(SAMPL.formatValue(tuple.get(i)));
                    out.print(' ');
                    ++i;
                }
            } else {
                out.print(SAMPL.formatValue(key));
            }
            out.print("  ");
            if (suffix != null) {
                out.println(SAMPL.formatValue(method.invoke(value, new Object[0])));
                continue;
            }
            if (value instanceof Evaluable) {
                out.println(SAMPL.formatValue(((Evaluable)value).eval()));
                continue;
            }
            out.println(SAMPL.formatValue(value));
        }
        out.println(";");
    }

    public static String formatKey(Object key) {
        if (key instanceof Double) {
            return Util.format((Double)key);
        }
        if (key instanceof String) {
            return "'" + key + "'";
        }
        return key.toString();
    }

    public static String formatValue(Object value) {
        if (value instanceof Double) {
            return Util.format((Double)value);
        }
        return value.toString();
    }

    public static double readNumeric(BufferedReader reader) throws SAMPLException {
        try {
            String line = reader.readLine();
            if (line == null) {
                throw new SAMPLException("Unexpected end of file");
            }
            return Double.parseDouble(line);
        }
        catch (IOException e) {
            throw new SAMPLException(e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new SAMPLException("Invalid number format");
        }
    }

    public static Object readSymbolic(BufferedReader reader) throws SAMPLException {
        try {
            String line = reader.readLine();
            if (line == null) {
                throw new SAMPLException("Unexpected end of file");
            }
            try {
                return Double.valueOf(line);
            }
            catch (NumberFormatException e) {
                return line;
            }
        }
        catch (IOException e) {
            throw new SAMPLException(e.getMessage());
        }
    }

    public static boolean convertToBoolean(Object obj) throws SAMPLException {
        if (obj instanceof Double) {
            return (Double)obj != 0.0;
        }
        throw new SAMPLException(String.format("Can't convert '%s' to number", obj));
    }

    public static String convertToString(double d) {
        String s = Double.toString(d);
        return s.endsWith(".0") ? s.substring(0, s.length() - 2) : s;
    }

    public static String convertToString(Object o) {
        return o instanceof String ? (String)o : SAMPL.convertToString((Double)o);
    }

    public static double card(Set<?> set) {
        return set.size();
    }

    public static Set<Object> union(Set<?> a, Set<?> b) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(a);
        result.addAll(b);
        return result;
    }

    public static Set<Object> diff(Set<?> a, Set<?> b) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(a);
        result.removeAll(b);
        return result;
    }

    public static Set<Object> symdiff(Set<?> a, Set<?> b) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(a);
        result.addAll(b);
        LinkedHashSet tmp = new LinkedHashSet(a);
        tmp.retainAll(b);
        result.removeAll(tmp);
        return result;
    }

    public static Set<Tuple> cross(Set<?> a, Set<?> b, int aDimen, int bDimen) {
        LinkedHashSet<Tuple> result = new LinkedHashSet<Tuple>(a.size() * b.size());
        Object[] items = new Object[aDimen + bDimen];
        for (Object i : a) {
            for (Object j : b) {
                if (aDimen == 1) {
                    items[0] = i;
                } else {
                    ((Tuple)i).insert(items, 0);
                }
                if (bDimen == 1) {
                    items[aDimen] = j;
                } else {
                    ((Tuple)j).insert(items, aDimen);
                }
                result.add(new Tuple(items));
            }
        }
        return result;
    }

    public void problem(Problem p) {
        if (p != null) {
            this.problem = p;
        } else {
            System.out.println("problem " + this.problem.name() + ";");
        }
    }

    public void setIn(InputStream in) {
        System.setIn(in);
        this.in = new BufferedReader(new InputStreamReader(in));
    }

    public void setOut(PrintStream out) {
        System.setOut(out);
        this.out = new PrintWriter(out);
    }

    public BufferedReader getReader(String filename) throws FileNotFoundException {
        if (filename.equals("-")) {
            return this.in;
        }
        BufferedReader reader = this.readers.get(filename);
        if (reader == null) {
            reader = new BufferedReader(new FileReader(filename));
            this.readers.put(filename, reader);
        }
        return reader;
    }

    public PrintWriter getWriter(String filename, boolean append) throws IOException {
        PrintWriter writer = this.writers.get(filename);
        if (writer == null) {
            String path = !new File(filename).isAbsolute() ? new File(this.env.getWorkingDir(), filename).toString() : filename;
            writer = new PrintWriter(new FileWriter(path, append));
            this.writers.put(filename, writer);
        }
        return writer;
    }

    public void close() {
        this.writeSolution = false;
        this.out.flush();
        for (BufferedReader r : this.readers.values()) {
            try {
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.readers.clear();
        for (PrintWriter w : this.writers.values()) {
            w.close();
        }
        this.writers.clear();
    }

    public final class HANDLERS
    extends SetMap {
        @Override
        protected void init() {
            this.putDefault(null, new HashSet<Object>());
            SAMPL.this.loadHandlers();
        }

        HANDLERS(SAMPL s) {
            super(s, "_HANDLERS", true);
        }
    }

    public final class HandlerInfo
    extends Parameter {
        @Override
        protected void init() {
            SAMPL.this.loadHandlers();
        }

        HandlerInfo(SAMPL s, String name) {
            super(s, name, true);
        }
    }

    public static enum Scenario {
        INSTANCE{

            public String toString() {
                return "?";
            }
        };

    }
}

