/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.ArrayList;
import java.util.List;
import sampl.lang.BinaryExpr;
import sampl.lang.CallExpr;
import sampl.lang.Constraint;
import sampl.lang.DiscreteRV;
import sampl.lang.Expr;
import sampl.lang.ExprBuilder;
import sampl.lang.ExprVisitor;
import sampl.lang.LinearTerm;
import sampl.lang.Number;
import sampl.lang.PiecewiseLinear;
import sampl.lang.ProblemExpander;
import sampl.lang.SymmetricRV;
import sampl.lang.Variable;
import sampl.lang.WeightedSum;

class RobustConverter {
    private UncertainTermExtractor extractor = new UncertainTermExtractor();
    private ProblemExpander pe;
    private List<ConstraintInfo> conInfo;

    RobustConverter(ProblemExpander pe) {
        this.pe = pe;
        this.conInfo = new ArrayList<ConstraintInfo>();
    }

    final Variable addVariable(double lb, double ub) {
        return this.pe.addAuxVariable(lb, ub);
    }

    final Constraint addConstraint(double lb, double ub) {
        return this.pe.addAuxConstraint(lb, ub);
    }

    final Variable convertRangeConstraint(Constraint con) {
        Variable var = this.addVariable(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        con.addTerm(-1.0, var);
        con.setBounds(0.0, 0.0);
        return var;
    }

    final Variable buildAbsConstraints(UncertainTerm term) {
        Variable auxVar = this.addVariable(0.0, Double.POSITIVE_INFINITY);
        Constraint auxCon = this.addConstraint(0.0, Double.POSITIVE_INFINITY);
        auxCon.addTerm(1.0, term.var);
        auxCon.addTerm(1.0, auxVar);
        auxCon = this.addConstraint(0.0, Double.POSITIVE_INFINITY);
        auxCon.addTerm(-1.0, term.var);
        auxCon.addTerm(1.0, auxVar);
        return auxVar;
    }

    void convert(Constraint con, List<UncertainTerm> terms) {
    }

    final void convert(Constraint con) {
        this.conInfo.add(new ConstraintInfo(con));
        this.extractor.extract(con);
        ArrayList<LinearTerm> linear = con.getLinear();
        if (linear == null && !this.extractor.terms.isEmpty()) {
            linear = new ArrayList<LinearTerm>();
            con.setLinear(linear);
        }
        for (UncertainTerm term : this.extractor.terms) {
            linear.add(new LinearTerm(term.coeff.getMean(), term.var));
        }
        if (con.lb() != Double.NEGATIVE_INFINITY || con.ub() != Double.POSITIVE_INFINITY) {
            this.convert(con, this.extractor.terms);
        }
    }

    final void restore() {
        for (ConstraintInfo ci : this.conInfo) {
            ci.restore();
        }
    }

    private static class ConstraintInfo {
        private Constraint con;
        private List<LinearTerm> savedLinear;
        private Expr savedNonlinear;
        private double savedLB;
        private double savedUB;

        ConstraintInfo(Constraint con) {
            this.con = con;
            this.savedNonlinear = con.getNonlinear();
            List linear = con.getLinear();
            this.savedLinear = linear != null ? new ArrayList(linear) : null;
            this.savedLB = con.lb();
            this.savedUB = con.ub();
        }

        void restore() {
            this.con.setLinear(this.savedLinear);
            this.con.setNonlinear(this.savedNonlinear);
            this.con.setBounds(this.savedLB, this.savedUB);
        }
    }

    static class UncertainTerm {
        SymmetricRV coeff;
        Variable var;

        UncertainTerm(SymmetricRV coeff, Variable var) {
            this.coeff = coeff;
            this.var = var;
        }
    }

    private static class UncertainTermExtractor
    implements ExprVisitor {
        private ExprBuilder eb;
        private List<UncertainTerm> terms;

        private UncertainTermExtractor() {
        }

        void extract(Constraint con) {
            Expr nonlinear = con.getNonlinear();
            this.terms = new ArrayList<UncertainTerm>();
            if (nonlinear == null) {
                return;
            }
            this.eb = new ExprBuilder();
            nonlinear.accept(this);
            con.setNonlinear(this.eb.toExpr());
        }

        @Override
        public void visit(Number num) {
            this.eb.add(num);
        }

        @Override
        public void visit(Variable var) {
            assert (false) : "Variable can't be a summand in a nonlinear expression.";
        }

        @Override
        public void visit(BinaryExpr expr) {
            Expr lhs = expr.getLHS();
            Expr rhs = expr.getRHS();
            if (expr.getOpCode() == 2) {
                if (lhs instanceof SymmetricRV && rhs instanceof Variable) {
                    this.terms.add(new UncertainTerm((SymmetricRV)lhs, (Variable)rhs));
                    return;
                }
                if (lhs instanceof Variable && rhs instanceof SymmetricRV) {
                    this.terms.add(new UncertainTerm((SymmetricRV)rhs, (Variable)lhs));
                    return;
                }
            }
            this.eb.add(expr);
        }

        @Override
        public void visit(WeightedSum expr) {
            int i = 0;
            int n = expr.size();
            while (i < n) {
                expr.getExpr(i).accept(this);
                ++i;
            }
        }

        @Override
        public void visit(PiecewiseLinear pl) {
            this.eb.add(pl);
        }

        @Override
        public void visit(CallExpr expr) {
            this.eb.add(expr);
        }

        @Override
        public void visit(DiscreteRV rv) {
            assert (false) : "Discrete RV can't occur in a robust constraint.";
        }

        @Override
        public void visit(SymmetricRV rv) {
            this.eb.add(rv);
        }
    }
}

