/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sampl.SAMPLException;
import sampl.lang.Entity;
import sampl.lang.Problem;
import sampl.lang.PromptHandler;
import sampl.lang.SAMPL;

public class ProblemMap
extends Entity<Problem> {
    private Map<String, Option> options = new HashMap<String, Option>();

    private static String invalidValueErrorMessage(String name, Object value) {
        return "Non-numeric value for option " + name + ": " + value;
    }

    private void initOption(String name, Option option) {
        SAMPL sampl = this.sampl();
        String value = sampl.getEnvironment().getVariable(name);
        if (value != null && !option.setValue(value)) {
            sampl.out.println(ProblemMap.invalidValueErrorMessage(name, value));
        }
        this.options.put(name, option);
    }

    private void initOption(String name, double value) {
        this.initOption(name, new NumericOption(value));
    }

    private void initOption(String name, String value) {
        this.initOption(name, new SymbolicOption(value));
    }

    public ProblemMap(SAMPL sampl, String name) {
        super(sampl, name);
        Problem p = sampl.getCurrentProblem();
        if (p == null) {
            this.initOption("ampl_include", ".");
            this.initOption("solver", "lpsolve");
            this.initOption("solver_msg", 1.0);
            this.initOption("objective_precision", 10.0);
            this.initOption("relax_integrality", 0.0);
            this.initOption("outopt", "");
            this.initOption("pl_linearize", 1.0);
            this.initOption("solve_result_table", "\n0\tsolved\n100\tsolved?\n200\tinfeasible\n300\tunbounded\n400\tlimit\n500\tfailure\n");
            this.initOption("prompt1", new PromptOption("sampl: "));
            this.initOption("nl_permute", 3.0);
        } else {
            for (Map.Entry<String, Option> e : ((ProblemMap)p.map()).options()) {
                this.options.put(e.getKey(), e.getValue().clone());
            }
        }
    }

    public static Problem newProblem(SAMPL sampl, String name) {
        return new ProblemMap(sampl, name).addProblem(null);
    }

    public final Problem addProblem(Object key) {
        Problem p = new Problem(this, key);
        Problem old = this.map.put(key, p);
        if (old == null) {
            return p;
        }
        this.map.put(key, old);
        return old;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        for (Map.Entry entry : this.entrySet()) {
            ((Problem)entry.getValue()).invalidate();
        }
    }

    public Object getOption(String name) {
        Option option = this.options.get(name);
        return option != null ? option.getValue() : this.sampl().getEnvironment().getVariable(name);
    }

    public boolean getBooleanOption(String name) {
        Option opt = this.options.get(name);
        return opt != null && opt.getNumericValue() != 0.0;
    }

    public int getIntOption(String name) {
        Option opt = this.options.get(name);
        return opt != null ? (int)opt.getNumericValue() : 0;
    }

    public void setOption(String name, Object value) throws SAMPLException {
        Option option = this.options.get(name);
        if (option != null) {
            if (option.setValue(value)) {
                return;
            }
            throw new SAMPLException(ProblemMap.invalidValueErrorMessage(name, value));
        }
        this.options.put(name, new SymbolicOption(value));
    }

    Set<Map.Entry<String, Option>> options() {
        return this.options.entrySet();
    }

    Problem reset() {
        return this.map.put(null, new Problem(this, (Object)null));
    }

    private static class NumericOption
    extends Option {
        private double value;

        public NumericOption(double value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean setValue(Object value) {
            if (value instanceof Double) {
                this.value = (Double)value;
                return true;
            }
            try {
                this.value = Double.parseDouble(value.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        @Override
        double getNumericValue() {
            return this.value;
        }
    }

    static abstract class Option
    implements Cloneable {
        Option() {
        }

        abstract Object getValue();

        abstract boolean setValue(Object var1);

        double getNumericValue() {
            throw new UnsupportedOperationException();
        }

        protected Option clone() {
            try {
                return (Option)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private class PromptOption
    extends SymbolicOption {
        public PromptOption(Object value) {
            super(value);
        }

        @Override
        public boolean setValue(Object value) {
            PromptHandler reader = ProblemMap.this.sampl().promptHandler;
            if (reader != null) {
                reader.setPrompt(value.toString());
            }
            return super.setValue(value);
        }
    }

    private static class SymbolicOption
    extends Option {
        private Object value;

        public SymbolicOption(Object value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean setValue(Object value) {
            this.value = value;
            return true;
        }
    }
}

