/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.Writer;
import sampl.SAMPLException;
import sampl.Util;
import sampl.lang.Entity;
import sampl.lang.NoDataException;
import sampl.lang.Objective;
import sampl.lang.SAMPL;

public class ObjectiveMap
extends Entity<Objective> {
    private boolean maximization;
    private boolean expanded;

    protected void doExpand() {
    }

    public ObjectiveMap(SAMPL env, String name, boolean maximization) {
        super(env, name);
        this.maximization = maximization;
    }

    public Objective addObjective(Object key) {
        Objective o = new Objective(this, key);
        this.map.put(key, o);
        return o;
    }

    public static Objective newObjective(SAMPL sampl, String name, boolean maximization) {
        return new ObjectiveMap(sampl, name, maximization).addObjective(null);
    }

    public boolean isMaximization() {
        return this.maximization;
    }

    public final void expand() {
        if (this.expanded) {
            return;
        }
        this.doExpand();
        this.expanded = true;
    }

    public double getValue(Object key) {
        this.update();
        return ((Objective)this.map.get(key)).val();
    }

    @Override
    public Objective get(Object key) throws SAMPLException {
        Objective value;
        if (!this.isValid()) {
            this.update();
            this.sampl().problem.expand();
        }
        if ((value = (Objective)this.map.get(key)) != null) {
            return value;
        }
        throw new NoDataException(this, key, true);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.expanded = false;
    }

    public void expand(Writer writer) throws IOException {
        this.sampl().problem.expand();
        for (Objective o : this.map.values()) {
            o.expand(writer);
            writer.write(Util.NEWLINE);
        }
    }
}

