/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import sampl.DiagnosticException;
import sampl.Integrality;
import sampl.SAMPLException;
import sampl.Source;
import sampl.Util;
import sampl.lang.BinaryExpr;
import sampl.lang.BinaryOp;
import sampl.lang.ConstraintMap;
import sampl.lang.Expr;
import sampl.lang.ExprBuilder;
import sampl.lang.Number;
import sampl.lang.ObjectiveMap;
import sampl.lang.PiecewiseLinear;
import sampl.lang.SAMPL;
import sampl.lang.Variable;
import sampl.lang.VariableMap;
import sampl.lang.WeightedSum;

public final class NLReader {
    private Source source;
    private BufferedReader in;
    private StringBuilder sb = new StringBuilder();
    private int ch;
    private int lineNumber;
    private VariableMap vars;
    private ObjectiveMap objs;
    private ConstraintMap cons;

    SAMPLException error(String message, Object ... args) {
        message = String.format(message, args);
        return new DiagnosticException(message, this.source, this.lineNumber - 1, 0);
    }

    private int readCode() throws IOException {
        int code = this.ch;
        this.ch = this.in.read();
        return code;
    }

    private String readString() throws IOException, SAMPLException {
        while (this.ch == 32 || this.ch == 9) {
            this.ch = this.in.read();
        }
        if (this.ch == -1) {
            throw this.error("Unexpected EOF", new Object[0]);
        }
        this.sb.setLength(0);
        while (this.ch != 10 && this.ch != 13 && this.ch != 32 && this.ch != 9 && this.ch != -1) {
            this.sb.append((char)this.ch);
            this.ch = this.in.read();
        }
        return this.sb.toString();
    }

    private int readInt() throws IOException, SAMPLException {
        try {
            return Integer.parseInt(this.readString());
        }
        catch (NumberFormatException e) {
            throw this.error("Expected integer", new Object[0]);
        }
    }

    private double readDouble() throws IOException, SAMPLException {
        try {
            return Double.parseDouble(this.readString());
        }
        catch (NumberFormatException e) {
            throw this.error("Expected double", new Object[0]);
        }
    }

    private void readInts(int numInts) throws IOException, SAMPLException {
        int i = 0;
        while (i < numInts) {
            this.readInt();
            ++i;
        }
        this.skipToEndOfLine();
    }

    private Expr handleExpr(ExprBuilder eb, Expr expr) {
        if (eb != null) {
            eb.add(1.0, expr);
        }
        return expr;
    }

    private Expr readExpr(ExprBuilder eb) throws IOException, SAMPLException {
        int code = this.readCode();
        switch (code) {
            case 110: {
                double value = this.readDouble();
                this.skipToEndOfLine();
                if (eb == null) {
                    return new Number(value);
                }
                eb.add(value);
                return null;
            }
            case 118: {
                int varIndex = this.readInt();
                this.skipToEndOfLine();
                return this.handleExpr(eb, (Expr)this.vars.get(varIndex));
            }
            case 111: {
                int op = this.readInt();
                this.skipToEndOfLine();
                switch (op) {
                    case 0: {
                        if (eb == null) {
                            eb = new ExprBuilder();
                        }
                        this.readExpr(eb);
                        this.readExpr(eb);
                        return eb.toExpr();
                    }
                    case 2: {
                        return this.handleExpr(eb, new BinaryExpr(BinaryOp.MUL, this.readExpr(null), this.readExpr(null)));
                    }
                    case 5: {
                        return this.handleExpr(eb, new BinaryExpr(BinaryOp.POW, this.readExpr(null), this.readExpr(null)));
                    }
                    case 16: {
                        return WeightedSum.newNegation(this.readExpr(null));
                    }
                    case 64: {
                        int numSlopes = this.readInt();
                        this.skipToEndOfLine();
                        double[] breakpoints = new double[numSlopes - 1];
                        double[] slopes = new double[numSlopes];
                        int i = 0;
                        int n = numSlopes - 1;
                        while (i < n) {
                            slopes[i] = ((Number)this.readExpr(null)).value();
                            breakpoints[i] = ((Number)this.readExpr(null)).value();
                            ++i;
                        }
                        slopes[numSlopes - 1] = ((Number)this.readExpr(null)).value();
                        Variable var = (Variable)this.readExpr(null);
                        return this.handleExpr(eb, new PiecewiseLinear(breakpoints, slopes, var));
                    }
                }
                throw this.error("Invalid opcode %d", op);
            }
        }
        throw this.error("Invalid expression code '%c'", Character.valueOf((char)code));
    }

    private void skipToEndOfLine() throws IOException {
        while (this.ch != 10 && this.ch != -1) {
            this.ch = this.in.read();
        }
        if (this.ch == 10) {
            ++this.lineNumber;
        }
        this.ch = this.in.read();
    }

    /*
     * Unable to fully structure code
     */
    private void readSections() throws IOException, SAMPLException {
        numVars = this.vars.size();
        numCons = this.cons.size();
        block25: while (true) {
            code = this.readCode();
            switch (code) {
                case 67: {
                    con = this.cons.get(this.readInt());
                    this.skipToEndOfLine();
                    eb = new ExprBuilder();
                    this.readExpr(eb);
                    con.setExpr(eb, 0.0, 0.0);
                    continue block25;
                }
                case 79: {
                    obj = this.objs.get(this.readInt());
                    type = this.readInt();
                    if (type != 0 && type != 1) {
                        throw this.error("Invalid objective type", new Object[0]);
                    }
                    this.skipToEndOfLine();
                    eb = new ExprBuilder();
                    this.readExpr(eb);
                    obj.setExpr(eb);
                    continue block25;
                }
                case 98: {
                    this.skipToEndOfLine();
                    i = 0;
                    while (true) {
                        if (i >= numVars) continue block25;
                        rangeCode = this.readInt();
                        lb = -Infinity;
                        ub = Infinity;
                        switch (rangeCode) {
                            case 0: {
                                lb = this.readDouble();
                                ub = this.readDouble();
                                break;
                            }
                            case 1: {
                                ub = this.readDouble();
                                break;
                            }
                            case 2: {
                                lb = this.readDouble();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                lb = ub = this.readDouble();
                                break;
                            }
                            default: {
                                throw this.error("Invalid bound code %d", new Object[]{rangeCode});
                            }
                        }
                        this.skipToEndOfLine();
                        var = (Variable)this.vars.get(i);
                        var.setLB(lb);
                        var.setUB(ub);
                        ++i;
                    }
                }
                case 114: {
                    this.skipToEndOfLine();
                    i = 0;
                    while (true) {
                        if (i >= numCons) continue block25;
                        rangeCode = this.readInt();
                        lb = -Infinity;
                        ub = Infinity;
                        switch (rangeCode) {
                            case 0: {
                                lb = this.readDouble();
                                ub = this.readDouble();
                                break;
                            }
                            case 1: {
                                ub = this.readDouble();
                                break;
                            }
                            case 2: {
                                lb = this.readDouble();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 4: {
                                lb = ub = this.readDouble();
                                break;
                            }
                            case 5: {
                                this.readInt();
                                this.readInt();
                                break;
                            }
                            default: {
                                throw this.error("Invalid range code %d", new Object[]{rangeCode});
                            }
                        }
                        this.skipToEndOfLine();
                        this.cons.get(i).setBounds(lb, ub);
                        ++i;
                    }
                }
                case 107: {
                    numCounts = this.readInt();
                    this.skipToEndOfLine();
                    i = 0;
                    while (true) {
                        if (i >= numCounts) continue block25;
                        this.skipToEndOfLine();
                        ++i;
                    }
                }
                case 74: {
                    con = this.cons.get(this.readInt());
                    numCoefs = this.readInt();
                    this.skipToEndOfLine();
                    i = 0;
                    while (true) {
                        if (i >= numCoefs) continue block25;
                        varIndex = this.readInt();
                        coef = this.readDouble();
                        this.skipToEndOfLine();
                        con.addTerm(coef, (Variable)this.vars.get(varIndex));
                        ++i;
                    }
                }
                case 71: {
                    obj = this.objs.get(this.readInt());
                    numCoefs = this.readInt();
                    this.skipToEndOfLine();
                    i = 0;
                    while (true) {
                        if (i < numCoefs) ** break;
                        continue block25;
                        varIndex = this.readInt();
                        coef = this.readDouble();
                        this.skipToEndOfLine();
                        if (coef != 0.0) {
                            obj.addTerm(coef, (Variable)this.vars.get(varIndex));
                        }
                        ++i;
                    }
                }
                case -1: {
                    return;
                }
            }
            break;
        }
        throw this.error("Invalid segment type '%c'", new Object[]{Character.valueOf((char)code)});
    }

    public void read(SAMPL env, Source source) throws SAMPLException {
        try {
            this.source = source;
            this.in = new BufferedReader(source.getReader());
            try {
                this.ch = this.in.read();
                this.lineNumber = 1;
                int code = this.readCode();
                if (code == -1) {
                    throw this.error("Unexpected EOF", new Object[0]);
                }
                if (code != 103) {
                    throw this.error("Invalid format code '%c'", Character.valueOf('g'));
                }
                int numOptions = this.readInt();
                this.readInts(numOptions);
                int numVars = this.readInt();
                this.vars = new NLVariableMap(env);
                this.vars.update();
                int i = 0;
                while (i < numVars) {
                    this.vars.addVariable(i, 0.0, 0.0, 0.0);
                    ++i;
                }
                int numCons = this.readInt();
                this.cons = new NLConstraintMap(env);
                this.cons.update();
                int i2 = 0;
                while (i2 < numCons) {
                    this.cons.addConstraint(i2, 0.0);
                    ++i2;
                }
                int numObjs = this.readInt();
                this.objs = new NLObjectiveMap(env);
                this.objs.update();
                int i3 = 0;
                while (i3 < numObjs) {
                    this.objs.addObjective(i3);
                    ++i3;
                }
                this.readInts(2);
                this.readInts(2);
                this.readInts(2);
                this.readInts(3);
                this.readInts(4);
                this.readInts(5);
                this.readInts(2);
                this.readInts(2);
                this.readInts(5);
                this.readSections();
            }
            finally {
                this.in.close();
            }
        }
        catch (IOException e) {
            throw new SAMPLException(e);
        }
    }

    public void dump(Writer out) throws IOException {
        for (Map.Entry entry : this.vars.entrySet()) {
            out.append(((Variable)entry.getValue()).toString()).append(Util.NEWLINE);
        }
        out.write(Util.NEWLINE);
        this.objs.expand(out);
        this.cons.expand(out);
    }

    private class NLConstraintMap
    extends ConstraintMap {
        NLConstraintMap(SAMPL env) {
            super(env, "c", false);
        }

        @Override
        protected void init() {
        }
    }

    private class NLObjectiveMap
    extends ObjectiveMap {
        NLObjectiveMap(SAMPL env) {
            super(env, "o", false);
        }

        @Override
        protected void init() {
        }
    }

    private class NLVariableMap
    extends VariableMap {
        NLVariableMap(SAMPL env) {
            super(env, "x", Integrality.CONTINUOUS);
        }

        @Override
        protected void init() {
        }
    }
}

