/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashSet;
import java.util.List;
import sampl.Integrality;
import sampl.SAMPLException;
import sampl.lang.Constraint;
import sampl.lang.ExpandedProblem;
import sampl.lang.LinearTerm;
import sampl.lang.Objective;
import sampl.lang.SolverConnection;
import sampl.lang.Variable;

public class MPSConnection
extends SolverConnection {
    PrintWriter writer;
    private boolean hasBounds;
    double[] rhs;

    static String format(double value) {
        String valueStr = Double.toString(value);
        if (valueStr.endsWith(".0")) {
            valueStr = valueStr.substring(0, valueStr.length() - 2);
        }
        if (valueStr.length() > 12) {
            BigDecimal bd = new BigDecimal(value, MathContext.DECIMAL32);
            valueStr = bd.stripTrailingZeros().toString();
        }
        return valueStr;
    }

    static String getColName(int index) {
        return String.format("C%04d", index + 1);
    }

    static String getRowName(int index) {
        return String.format("R%04d", index + 1);
    }

    void writeHeader(String name) {
        this.writer.println(name);
    }

    void writeHeader(String name1, String name2) {
        this.writer.format("%-14s%s%n", name1, name2);
    }

    void writeData(String code, String name) {
        this.writer.format(" %-2s %s%n", code, name);
    }

    void writeData(String code, String name1, String name2, String value, String name3) {
        this.writer.format(" %-2s %-8s  %-8s  %s", code, name1, name2, value);
        if (name3 != null) {
            this.writer.format("%" + (15 - value.length()) + "s%s%n", "", name3);
        } else {
            this.writer.println();
        }
    }

    void writeData(String name1, String name2, double value) {
        this.writeData("", name1, name2, MPSConnection.format(value), null);
    }

    void writeData(String name1, String name2, String name3) {
        this.writer.format("    %-8s  %-8s", name1, name2);
        if (name3 != null) {
            this.writer.format("                 %s%n", name3);
        } else {
            this.writer.println();
        }
    }

    void writeBound(String code, int colIndex, double value) {
        if (!this.hasBounds) {
            this.hasBounds = true;
            this.writeHeader("BOUNDS");
        }
        this.writer.format(" %-2s %-8s  %-8s", code, "BOUND", MPSConnection.getColName(colIndex));
        if (value != 0.0) {
            this.writer.print("  ");
            this.writer.println(MPSConnection.format(value));
        } else {
            this.writer.println();
        }
    }

    void writeMPS(ExpandedProblem ep, SolverConnection.WriterProvider wp, String suffix, boolean allowEmptyRHS) throws IOException, SAMPLException {
        if (ep.numNonlinearCons() != 0 || ep.numNonlinearObjs() != 0) {
            throw new SAMPLException("MPS can't be written because problem is nonlinear");
        }
        this.writer = new PrintWriter(wp.newWriter(suffix));
        try {
            List linear;
            this.writeHeader("NAME", wp.filenameWithoutExt());
            this.writeHeader("ROWS");
            Constraint[] cons = ep.getConstraints();
            int numCons = cons.length;
            this.rhs = new double[numCons];
            int rangeIndex = 0;
            int[] rangeCons = null;
            double[] ranges = null;
            if (ep.numRanges() != 0) {
                rangeCons = new int[ep.numRanges()];
                ranges = new double[ep.numRanges()];
            }
            int i = 0;
            while (i < numCons) {
                String code;
                Constraint con = cons[i];
                double lb = con.lb();
                double ub = con.ub();
                if (lb == Double.NEGATIVE_INFINITY) {
                    if (ub != Double.POSITIVE_INFINITY) {
                        this.rhs[i] = ub;
                        code = "L";
                    } else {
                        code = "N";
                    }
                } else {
                    code = "G";
                    this.rhs[i] = lb;
                    if (ub != Double.POSITIVE_INFINITY) {
                        if (lb != ub) {
                            rangeCons[rangeIndex] = i;
                            ranges[rangeIndex++] = ub - lb;
                        } else {
                            code = "E";
                        }
                    }
                }
                this.writeData(code, MPSConnection.getRowName(i));
                ++i;
            }
            Objective[] objs = ep.getObjectives();
            int i2 = 0;
            int n = objs.length;
            while (i2 < n) {
                this.writeData("N", MPSConnection.getRowName(numCons + i2));
                ++i2;
            }
            Variable[] vars = ep.getVariables();
            int numVars = vars.length;
            HashSet<Integer> intVars = null;
            int[] numVarLinearTerms = ep.numVarLinearTerms();
            int[] colOffsets = new int[numVars + 1];
            int i3 = 0;
            while (i3 < numVars) {
                Variable var = vars[i3];
                if (var.map().getType() != Integrality.CONTINUOUS) {
                    if (intVars == null) {
                        intVars = new HashSet<Integer>();
                    }
                    intVars.add(i3);
                }
                colOffsets[i3 + 1] = numVarLinearTerms[i3];
                ++i3;
            }
            double objConst = 0.0;
            Objective[] objectiveArray = objs;
            int n2 = objs.length;
            int n3 = 0;
            while (n3 < n2) {
                Objective obj = objectiveArray[n3];
                List linear2 = obj.getLinear();
                if (linear2 != null) {
                    for (LinearTerm term : linear2) {
                        int varIndex = term.getVariable().index();
                        int n4 = varIndex + 1;
                        colOffsets[n4] = colOffsets[n4] + 1;
                    }
                }
                objConst = obj.constant();
                ++n3;
            }
            int i4 = 0;
            while (i4 < numVars) {
                int n5 = i4 + 1;
                colOffsets[n5] = colOffsets[n5] + colOffsets[i4];
                ++i4;
            }
            int[] rowIndices = new int[ep.numConNonzeros() + ep.numObjNonzeros()];
            double[] values = new double[ep.numConNonzeros() + ep.numObjNonzeros()];
            int i5 = 0;
            int n6 = cons.length;
            while (i5 < n6) {
                Constraint con = cons[i5];
                linear = con.getLinear();
                if (linear != null) {
                    for (LinearTerm term : con.getLinear()) {
                        int n7 = term.getVariable().index();
                        colOffsets[n7] = colOffsets[n7] + 1;
                        rowIndices[itemIndex] = i5;
                        values[itemIndex] = term.getCoefficient();
                    }
                }
                ++i5;
            }
            i5 = 0;
            n6 = objs.length;
            while (i5 < n6) {
                Objective obj = objs[i5];
                linear = obj.getLinear();
                if (linear != null) {
                    for (LinearTerm term : linear) {
                        int n8 = term.getVariable().index();
                        colOffsets[n8] = colOffsets[n8] + 1;
                        rowIndices[itemIndex] = numCons + i5;
                        values[itemIndex] = term.getCoefficient();
                    }
                }
                ++i5;
            }
            this.writeHeader("COLUMNS");
            int j = 0;
            int i6 = 0;
            while (i6 < numVars) {
                boolean isInt;
                String colName = MPSConnection.getColName(i6);
                boolean bl = isInt = intVars != null && intVars.contains(i6);
                if (isInt) {
                    this.writeData("INT1", "'MARKER'", "'INTORG'");
                }
                int n9 = colOffsets[i6];
                while (j < n9) {
                    this.writeData(colName, MPSConnection.getRowName(rowIndices[j]), values[j]);
                    ++j;
                }
                if (isInt) {
                    this.writeData("INT1END", "'MARKER'", "'INTEND'");
                }
                ++i6;
            }
            if (objConst != 0.0) {
                this.writeData(MPSConnection.getColName(numVars), MPSConnection.getRowName(numCons), 1.0);
            }
            this.writeHeader("RHS");
            boolean emptyRHS = true;
            int i7 = 0;
            while (i7 < numCons) {
                if (this.rhs[i7] != 0.0) {
                    this.writeData("B", MPSConnection.getRowName(i7), this.rhs[i7]);
                    emptyRHS = false;
                }
                ++i7;
            }
            if (emptyRHS && !allowEmptyRHS) {
                i7 = 0;
                while (i7 < numCons) {
                    if (cons[i7].lb() == 0.0) {
                        this.writeData("B", MPSConnection.getRowName(0), 0.0);
                        break;
                    }
                    ++i7;
                }
            }
            if (ep.numRanges() != 0) {
                this.writeHeader("RANGES");
                i7 = 0;
                while (i7 < ep.numRanges()) {
                    this.writeData("RANGE", MPSConnection.getRowName(rangeCons[i7]), ranges[i7]);
                    ++i7;
                }
            }
            int index = -1;
            Variable[] variableArray = vars;
            int n10 = vars.length;
            int n11 = 0;
            while (n11 < n10) {
                block46: {
                    double ub;
                    block47: {
                        double lb;
                        block44: {
                            block45: {
                                Variable var = variableArray[n11];
                                ++index;
                                lb = var.lb();
                                ub = var.ub();
                                if (lb != Double.NEGATIVE_INFINITY) break block44;
                                if (ub != Double.POSITIVE_INFINITY) break block45;
                                this.writeBound("FR", index, 0.0);
                                break block46;
                            }
                            this.writeBound("MI", index, 0.0);
                            break block47;
                        }
                        if (lb != 0.0) {
                            this.writeBound("LO", index, lb);
                        }
                    }
                    if (ub != Double.POSITIVE_INFINITY && ub != 0.0) {
                        this.writeBound("UP", index, ub);
                    }
                }
                ++n11;
            }
            if (objConst != 0.0) {
                this.writeBound("LO", numVars, objConst);
                this.writeBound("UP", numVars, objConst);
            }
            this.writeHeader("ENDATA");
        }
        finally {
            this.writer.close();
        }
    }

    @Override
    void writeExpanded(ExpandedProblem ep, SolverConnection.WriterProvider wp) throws IOException, SAMPLException {
        this.writeMPS(ep, wp, ".mps", true);
    }
}

