/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.ArrayList;
import java.util.List;
import sampl.lang.DiscreteRV;
import sampl.lang.Expr;
import sampl.lang.LinearTerm;
import sampl.lang.Variable;
import sampl.lang.WeightedSum;

public final class ExprBuilder {
    private WeightedSum.Builder sum = new WeightedSum.Builder();
    private double constant;
    private double multiplier = 1.0;
    private Expr nonlinear;
    private DiscreteRV constNonlinear;

    public final void neg() {
        this.multiplier = -this.multiplier;
    }

    public final void setMultiplier(double value) {
        this.multiplier = value;
    }

    public final void add(double coef, Expr expr) {
        this.sum.addTerm(this.multiplier * coef, expr);
    }

    public final void add(double constant) {
        this.constant += this.multiplier * constant;
    }

    public final void add(Expr expr) {
        this.sum.addTerm(this.multiplier, expr);
    }

    public final double mul(double value) {
        double old = this.multiplier;
        this.multiplier *= value;
        return old;
    }

    public final double div(double value) {
        double old = this.multiplier;
        this.multiplier /= value;
        return old;
    }

    public final Expr toExpr() {
        WeightedSum result = this.sum.toSum();
        if (result.size() == 0) {
            return null;
        }
        if (result.size() == 1 && result.getWeight(0) == 1.0) {
            return result.getExpr(0);
        }
        return result;
    }

    public final double getConstant() {
        return this.constant;
    }

    public final List<LinearTerm> getLinear(boolean separateConstNonlinear) {
        WeightedSum.Builder sumNonlinear = null;
        ArrayList<LinearTerm> linear = new ArrayList<LinearTerm>(this.sum.size());
        int i = 0;
        int n = this.sum.size();
        while (i < n) {
            Expr expr = this.sum.getExpr(i);
            if (expr instanceof Variable) {
                linear.add(new LinearTerm(this.sum.getWeight(i), (Variable)expr));
            } else if (separateConstNonlinear && !expr.hasVariables()) {
                double coef = -this.sum.getWeight(i);
                this.constNonlinear = this.constNonlinear != null ? this.constNonlinear.addScaled(coef, (DiscreteRV)expr) : ((DiscreteRV)expr).mul(coef);
            } else {
                if (sumNonlinear == null) {
                    sumNonlinear = new WeightedSum.Builder();
                }
                sumNonlinear.addTerm(this.sum.getWeight(i), expr);
            }
            ++i;
        }
        if (sumNonlinear != null) {
            this.nonlinear = sumNonlinear.size() == 1 && sumNonlinear.getWeight(0) == 1.0 ? sumNonlinear.getExpr(0) : sumNonlinear.toSum();
        }
        if (this.constNonlinear instanceof DiscreteRV) {
            this.constNonlinear = this.constNonlinear.add(-this.constant);
            this.constant = 0.0;
        }
        return linear.isEmpty() ? null : linear;
    }

    public final Expr getNonlinear() {
        return this.nonlinear;
    }

    public final Expr getConstNonlinear() {
        return this.constNonlinear;
    }
}

