/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import sampl.SAMPLException;
import sampl.lang.NoDataException;
import sampl.lang.SAMPL;

public abstract class Entity<T> {
    private SAMPL sampl;
    private String name;
    protected Map<Object, T> map = new LinkedHashMap<Object, T>(1);
    static final int IS_VALID = 1;
    static final int NO_DATA = 2;
    private int flags;
    private ArrayList<Entity<?>> dependents = new ArrayList();

    final void invalidateDependents() {
        for (Entity<?> e : this.dependents) {
            if (!e.isValid()) continue;
            e.invalidate();
            e.invalidateDependents();
        }
    }

    private void getAllDependents(Set<Entity<?>> deps) {
        deps.addAll(this.dependents);
        for (Entity<?> d : this.dependents) {
            super.getAllDependents(deps);
        }
    }

    protected void init() {
    }

    final void update() {
        if (this.isValid()) {
            return;
        }
        this.flags |= 1;
        this.init();
    }

    public Entity(SAMPL sampl, String name) {
        this.sampl = sampl;
        this.name = name;
    }

    public final SAMPL sampl() {
        return this.sampl;
    }

    public final String name() {
        return this.name;
    }

    public final boolean isValid() {
        return (this.flags & 1) != 0;
    }

    public void invalidate() {
        this.flags &= 0xFFFFFFFE;
    }

    public final boolean hasData() {
        return (this.flags & 2) == 0;
    }

    final void setNoData() {
        this.flags |= 2;
    }

    final void clearNoData() {
        this.flags &= 0xFFFFFFFD;
    }

    public final int size() {
        this.update();
        return this.map.size();
    }

    public final Set<Map.Entry<Object, T>> entrySet() {
        this.update();
        return this.map.entrySet();
    }

    public final void addDependent(Entity<?> dep) {
        this.dependents.add(dep);
    }

    public void xref(PrintWriter out) {
        out.print("# ");
        LinkedHashSet allDeps = new LinkedHashSet();
        this.getAllDependents(allDeps);
        int size = allDeps.size();
        out.print(size);
        out.print(size != 1 ? " entities depend on " : " entity depends on ");
        out.print(this.name);
        out.println(":");
        for (Entity entity : allDeps) {
            out.println(entity.name);
        }
        out.println();
    }

    public final void prepareForAssignment() {
        this.flags &= 0xFFFFFFFD;
        if (this.isValid()) {
            this.invalidateDependents();
        } else {
            this.update();
        }
    }

    public T get(Object key) throws SAMPLException {
        T value;
        if (!this.isValid()) {
            this.update();
        }
        if ((value = this.map.get(key)) != null) {
            return value;
        }
        throw new NoDataException(this, key, true);
    }
}

