/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import sampl.Util;
import sampl.lang.AStatus;
import sampl.lang.ConstraintMap;
import sampl.lang.DiscreteRV;
import sampl.lang.Evaluable;
import sampl.lang.Expr;
import sampl.lang.ExprBuilder;
import sampl.lang.ExprPrinter;
import sampl.lang.LinearTerm;
import sampl.lang.MapItemWithExpr;
import sampl.lang.Number;
import sampl.lang.WeightedSum;

public final class Constraint
extends MapItemWithExpr<ConstraintMap>
implements Evaluable {
    private double lb = Double.NEGATIVE_INFINITY;
    private double ub = Double.POSITIVE_INFINITY;
    private double dinit;
    private double dual;
    private double body;
    private int defvar;
    private double robustness;
    private int dualFlags;
    private static int LDUAL_FLAG = 1;
    private static int UDUAL_FLAG = 2;

    Constraint(ConstraintMap map, Object key, double dinit) {
        super(map, key);
        this.dinit = this.dual = dinit;
    }

    public double lb() {
        return this.lb;
    }

    void setLB(double lb) {
        this.lb = lb;
    }

    DiscreteRV randomlb() {
        return (DiscreteRV)this.getSuffix("randomlb");
    }

    void setLB(DiscreteRV lb) {
        this.lb = Double.NaN;
        this.setSuffix("randomlb", lb);
    }

    boolean hasRandomLB() {
        return Double.isNaN(this.lb);
    }

    public double ub() {
        return this.ub;
    }

    void setUB(double ub) {
        this.ub = ub;
    }

    DiscreteRV randomub() {
        return (DiscreteRV)this.getSuffix("randomub");
    }

    void setUB(DiscreteRV ub) {
        this.ub = Double.NaN;
        this.setSuffix("randomub", ub);
    }

    boolean hasRandomUB() {
        return Double.isNaN(this.ub);
    }

    public double lbs() {
        return this.lb();
    }

    public double ubs() {
        return this.ub();
    }

    public void setBounds(double lb, double ub) {
        this.lb = lb;
        this.ub = ub;
    }

    public double ldual() {
        return (this.dualFlags & LDUAL_FLAG) != 0 ? this.dual : 0.0;
    }

    public double udual() {
        return (this.dualFlags & UDUAL_FLAG) != 0 ? this.dual : 0.0;
    }

    public double dual() {
        return this.dual;
    }

    public double dinit() {
        return this.dinit;
    }

    public double dinit0() {
        return this.dinit;
    }

    public double body() {
        return this.body;
    }

    public double lslack() {
        return this.body - this.lb;
    }

    public double uslack() {
        return this.ub - this.body;
    }

    public double slack() {
        return Math.min(this.lslack(), this.uslack());
    }

    public int defvar() {
        return this.defvar;
    }

    public double defvarInternal() {
        return this.defvar;
    }

    void setDefVar(int index) {
        this.defvar = index;
    }

    public Object status() {
        AStatus s = this.astatus();
        return s != AStatus.IN ? s : this.sstatus();
    }

    public String statusInternal() {
        return this.status().toString().toLowerCase();
    }

    public double robustness() {
        return this.robustness;
    }

    public void setRobustness(double robustness) {
        this.robustness = robustness;
    }

    public void setExpr(ExprBuilder eb, double lb, double ub) {
        this.setLinear(eb.getLinear(true));
        this.setNonlinear(eb.getNonlinear());
        double constant = eb.getConstant();
        lb -= constant;
        ub -= constant;
        Expr constNonlinear = eb.getConstNonlinear();
        if (constNonlinear != null) {
            if (lb != Double.NEGATIVE_INFINITY) {
                this.setLB((DiscreteRV)(lb != 0.0 ? WeightedSum.newAddition(new Number(lb), constNonlinear) : constNonlinear));
            }
            if (ub != Double.POSITIVE_INFINITY) {
                this.setUB((DiscreteRV)(ub != 0.0 ? WeightedSum.newAddition(new Number(ub), constNonlinear) : constNonlinear));
            }
        } else {
            this.lb = lb;
            this.ub = ub;
        }
    }

    void computeBodyAndDuals(double dual, boolean maximization) {
        this.dual = dual;
        this.computeBodyAndDuals(maximization);
    }

    void computeBodyAndDuals(boolean maximization) {
        Expr nonlinear;
        double body = 0.0;
        List linear = this.getLinear();
        if (linear != null) {
            for (LinearTerm term : linear) {
                body += term.getCoefficient() * term.getVariable().val();
            }
        }
        if ((nonlinear = this.getNonlinear()) != null) {
            body += nonlinear.eval();
        }
        this.body = body;
        this.dualFlags = this.lb == Double.NEGATIVE_INFINITY ? (this.ub != Double.POSITIVE_INFINITY ? UDUAL_FLAG : 0) : (this.ub == Double.POSITIVE_INFINITY ? LDUAL_FLAG : (this.lb != this.ub ? (body - this.lb >= this.ub - body ? UDUAL_FLAG : LDUAL_FLAG) : (maximization ? (this.dual > 0.0 ? UDUAL_FLAG : LDUAL_FLAG) : (this.dual < 0.0 ? UDUAL_FLAG : LDUAL_FLAG))));
    }

    private void printHead(Writer writer) throws IOException {
        writer.append("s.t. ").append(this.name()).append(':');
    }

    private void writelb(Writer writer) throws IOException {
        writer.append(this.hasRandomLB() ? this.randomlb().toString() : Util.format(this.lb));
    }

    private void expandExpr(Writer writer) throws IOException {
        boolean printUB;
        boolean bl = printUB = this.ub != Double.POSITIVE_INFINITY;
        if (printUB && this.lb != Double.NEGATIVE_INFINITY && this.lb != this.ub) {
            this.writelb(writer);
            writer.append(" <= ");
        }
        ExprPrinter.print(writer, this.getNonlinear(), this.getLinear(), 0.0);
        if (printUB) {
            writer.append(this.lb != this.ub ? " <= " : " = ");
            writer.append(this.hasRandomUB() ? this.randomub().toString() : Util.format(this.ub));
        } else if (this.lb != Double.NEGATIVE_INFINITY) {
            writer.append(" >= ");
            this.writelb(writer);
        } else {
            writer.append(" /* = free row */");
        }
    }

    public void expand(Writer writer) throws IOException {
        this.printHead(writer);
        writer.append(Util.NEWLINE).append('\t');
        this.expandExpr(writer);
        writer.append(';').append(Util.NEWLINE);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.printHead(writer);
            writer.append(' ');
            this.expandExpr(writer);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        writer.append(';');
        return writer.toString();
    }

    @Override
    public double eval() {
        return this.dual;
    }
}

