/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

enum BinaryOp {
    MUL(2, 13, "*"){

        @Override
        double apply(double lhs, double rhs) {
            return lhs * rhs;
        }
    }
    ,
    DIV(3, 13, "/"){

        @Override
        double apply(double lhs, double rhs) {
            return lhs / rhs;
        }
    }
    ,
    REM(4, 13, "mod"){

        @Override
        double apply(double lhs, double rhs) {
            throw new RuntimeException("Not implemented");
        }
    }
    ,
    POW(5, 14, "^"){

        @Override
        double apply(double lhs, double rhs) {
            return Math.pow(lhs, rhs);
        }
    }
    ,
    LESS(6, 11, "less"){

        @Override
        double apply(double lhs, double rhs) {
            return Math.max(lhs - rhs, 0.0);
        }
    }
    ,
    OR(20, 1, "||"){

        @Override
        double apply(double lhs, double rhs) {
            return lhs != 0.0 || rhs != 0.0 ? 1 : 0;
        }
    }
    ,
    AND(21, 3, "&&"){

        @Override
        double apply(double lhs, double rhs) {
            return lhs != 0.0 && rhs != 0.0 ? 1 : 0;
        }
    }
    ,
    LT(22, 4, "<"){

        @Override
        double apply(double lhs, double rhs) {
            return lhs < rhs ? 1 : 0;
        }
    }
    ,
    LE(23, 4, "<="){

        @Override
        double apply(double lhs, double rhs) {
            return lhs <= rhs ? 1 : 0;
        }
    }
    ,
    EQ(24, 4, "=="){

        @Override
        double apply(double lhs, double rhs) {
            return lhs == rhs ? 1 : 0;
        }
    }
    ,
    GE(28, 4, ">="){

        @Override
        double apply(double lhs, double rhs) {
            return lhs >= rhs ? 1 : 0;
        }
    }
    ,
    GT(29, 4, ">"){

        @Override
        double apply(double lhs, double rhs) {
            return lhs > rhs ? 1 : 0;
        }
    }
    ,
    NE(30, 4, "!="){

        @Override
        double apply(double lhs, double rhs) {
            return lhs != rhs ? 1 : 0;
        }
    };

    private int opcode;
    private int precedence;
    private String str;

    private BinaryOp(int opcode, int precedence, String str) {
        this.opcode = opcode;
        this.precedence = precedence;
        this.str = str;
    }

    int opcode() {
        return this.opcode;
    }

    int precedence() {
        return this.precedence;
    }

    abstract double apply(double var1, double var3);

    public String toString() {
        return this.str;
    }

    /* synthetic */ BinaryOp(String string, int n, int n2, int n3, String string2, BinaryOp binaryOp) {
        this(n2, n3, string2);
    }
}

