/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import sampl.Integrality;
import sampl.ast.ArcAttr;
import sampl.ast.BasicAttr;
import sampl.ast.CoeffAttr;
import sampl.ast.ConstraintDecl;
import sampl.ast.Decl;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.SuffixAttr;
import sampl.ast.UnaryAttr;
import sampl.ast.VariableDecl;
import sampl.codegen.AbstractASTCompiler;
import sampl.codegen.DeclCompiler;
import sampl.codegen.IndexingCompiler;
import sampl.codegen.MethodEmitter;

final class VariableDeclCompiler
extends DeclCompiler {
    private VariableDecl decl;
    private Expr lower;
    private Expr upper;
    private ArcAttr from;
    private ArcAttr to;
    private List<CoeffAttr> coeffAttrs;
    private Expr initializer;
    private List<SuffixAttr> suffixAttrs = new ArrayList<SuffixAttr>();
    private Integrality type = Integrality.CONTINUOUS;
    private boolean isDefined;

    VariableDeclCompiler(AbstractASTCompiler ce, VariableDecl decl) {
        super(ce, true);
        this.decl = decl;
    }

    @Override
    String getParentName() {
        return "sampl/lang/VariableMap";
    }

    @Override
    Decl getDecl() {
        return this.decl;
    }

    @Override
    void emitConstructor() {
        MethodEmitter me = this.classEmitter.beginMethod(1, "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;)V");
        MethodVisitor mv = me.getMethodVisitor();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(178, "sampl/Integrality", this.type.toString(), "Lsampl/Integrality;");
        Indexing indexing = this.decl.getIndexing();
        mv.visitIntInsn(16, indexing != null ? indexing.getScenarioSubIndex() : -1);
        mv.visitMethodInsn(183, this.getParentName(), "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;Lsampl/Integrality;I)V");
        if (this.decl.isArc() || !this.coeffAttrs.isEmpty()) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "sampl/lang/VariableMap", "setNeedsExpand", "()V");
        }
        mv.visitInsn(177);
        me.endMethod();
    }

    @Override
    void emitItem(MethodEmitter initEmitter) {
        MethodVisitor mv = initEmitter.getMethodVisitor();
        if (this.isDefined) {
            if (this.initializer.hasNumericOrSymbolicType()) {
                initEmitter.emitNumeric(this.initializer);
            } else {
                mv.visitInsn(14);
            }
            mv.visitMethodInsn(182, "sampl/lang/VariableMap", "addVariable", "(Ljava/lang/Object;D)Lsampl/lang/Variable;");
        } else {
            if (this.type == Integrality.BINARY) {
                mv.visitInsn(14);
                mv.visitInsn(15);
            } else {
                if (this.lower == null) {
                    mv.visitLdcInsn((Object)Double.NEGATIVE_INFINITY);
                } else {
                    initEmitter.emitNumeric(this.lower);
                }
                if (this.upper == null) {
                    mv.visitLdcInsn((Object)Double.POSITIVE_INFINITY);
                } else {
                    initEmitter.emitNumeric(this.upper);
                }
            }
            if (this.initializer != null) {
                initEmitter.emit(this.initializer);
            } else {
                mv.visitInsn(14);
            }
            mv.visitMethodInsn(182, "sampl/lang/VariableMap", "addVariable", "(Ljava/lang/Object;DDD)Lsampl/lang/Variable;");
        }
        for (SuffixAttr attr : this.suffixAttrs) {
            if (!attr.getSuffix().toString().equals("stage")) continue;
            mv.visitInsn(89);
            initEmitter.emitNumber(attr.getValue());
            mv.visitMethodInsn(182, "sampl/lang/Variable", "stageInternal", "(D)V");
        }
        mv.visitInsn(87);
    }

    @Override
    void emitMembers() {
        Expr expr;
        Expr ref;
        this.coeffAttrs = new ArrayList<CoeffAttr>();
        super.emitMembers();
        if (this.from == null && this.to == null && this.coeffAttrs.isEmpty()) {
            return;
        }
        MethodEmitter me = this.classEmitter.beginMethod(17, "doExpand", "()V");
        MethodVisitor mv = me.getMethodVisitor();
        this.prepareEnvironment(me);
        Indexing indexing = this.decl.getIndexing();
        if (indexing != null && indexing.hasScenarioIndex()) {
            indexing = indexing.copyWithoutScenarioSet();
        }
        this.indexingEmitter = null;
        if (indexing != null) {
            this.indexingEmitter = new IndexingCompiler(me, indexing, true);
            this.indexingEmitter.start();
        }
        mv.visitVarInsn(25, 0);
        if (indexing != null) {
            mv.visitVarInsn(25, this.indexingEmitter.getKeyVar());
        } else {
            mv.visitInsn(1);
        }
        mv.visitMethodInsn(182, "sampl/lang/VariableMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "sampl/lang/Variable");
        int var = me.getVarIndex();
        mv.visitVarInsn(58, var);
        if (this.from != null) {
            ref = this.from.getReference();
            me.emit(ref);
            expr = this.from.getExpr();
            if (expr == null) {
                mv.visitInsn(15);
            } else {
                me.emitNumeric(expr);
            }
            if (!((ConstraintDecl)ref.getTarget()).hasNetOut()) {
                mv.visitInsn(119);
            }
            mv.visitVarInsn(25, var);
            mv.visitMethodInsn(182, "sampl/lang/Constraint", "addTerm", "(DLsampl/lang/Variable;)V");
        }
        if (this.to != null) {
            ref = this.to.getReference();
            me.emit(ref);
            expr = this.to.getExpr();
            if (expr == null) {
                mv.visitInsn(15);
            } else {
                me.emitNumeric(expr);
            }
            if (((ConstraintDecl)ref.getTarget()).hasNetOut()) {
                mv.visitInsn(119);
            }
            mv.visitVarInsn(25, var);
            mv.visitMethodInsn(182, "sampl/lang/Constraint", "addTerm", "(DLsampl/lang/Variable;)V");
        }
        for (CoeffAttr attr : this.coeffAttrs) {
            if (attr.is(CoeffAttr.Kind.OBJ)) {
                me.emit(attr.getReference());
                Expr coeff = attr.getCoeff();
                if (coeff != null) {
                    me.emitNumeric(coeff);
                } else {
                    mv.visitInsn(15);
                }
                mv.visitVarInsn(25, var);
                mv.visitMethodInsn(182, "sampl/lang/Objective", "addTerm", "(DLsampl/lang/Variable;)V");
                continue;
            }
            Indexing innerIndexing = attr.getIndexing();
            IndexingCompiler emitter = null;
            if (innerIndexing != null) {
                emitter = new IndexingCompiler(me, innerIndexing, true);
                emitter.start();
            }
            me.emit(attr.getReference());
            Expr value = attr.getCoeff();
            if (value != null) {
                me.emitNumeric(value);
            } else {
                mv.visitInsn(15);
            }
            mv.visitVarInsn(25, var);
            mv.visitMethodInsn(182, "sampl/lang/Constraint", "addTerm", "(DLsampl/lang/Variable;)V");
            if (innerIndexing == null) continue;
            emitter.end();
        }
        if (indexing != null) {
            this.indexingEmitter.end();
        }
        mv.visitInsn(177);
        me.endMethod();
    }

    @Override
    public void visit(BasicAttr attr) {
        if (this.type != Integrality.BINARY) {
            this.type = attr.is(BasicAttr.Kind.BINARY) ? Integrality.BINARY : Integrality.INTEGER;
        }
    }

    @Override
    public void visit(UnaryAttr attr) {
        Expr arg = attr.getArg();
        switch (attr.getKind()) {
            default: {
                assert (false) : "Invalid attribute.";
            }
            case LE: {
                this.upper = arg;
                break;
            }
            case GE: {
                this.lower = arg;
                break;
            }
            case EQ: {
                this.isDefined = true;
                this.initializer = arg;
                break;
            }
            case ASSIGN: 
            case DEFAULT: {
                this.initializer = arg;
            }
            case IN: 
        }
    }

    @Override
    public void visit(SuffixAttr attr) {
        this.suffixAttrs.add(attr);
    }

    @Override
    public void visit(ArcAttr attr) {
        if (attr.isFrom()) {
            this.from = attr;
        } else {
            this.to = attr;
        }
    }

    @Override
    public void visit(CoeffAttr attr) {
        this.coeffAttrs.add(attr);
    }
}

