/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import sampl.ast.BinaryExpr;
import sampl.ast.ColGroup;
import sampl.ast.Decl;
import sampl.ast.Direction;
import sampl.ast.Expr;
import sampl.ast.IndexDef;
import sampl.ast.Referable;
import sampl.ast.Reference;
import sampl.ast.TableDecl;
import sampl.codegen.AbstractASTCompiler;
import sampl.codegen.DeclCompiler;
import sampl.codegen.IndexingCompiler;
import sampl.codegen.MethodEmitter;
import sampl.types.MapType;
import sampl.types.Types;

final class TableDeclCompiler
extends DeclCompiler {
    private TableDecl decl;

    public TableDeclCompiler(AbstractASTCompiler ce, TableDecl decl) {
        super(ce);
        this.decl = decl;
    }

    @Override
    Decl getDecl() {
        return this.decl;
    }

    @Override
    String getParentName() {
        return "sampl/lang/TableMap";
    }

    @Override
    void emitItem(MethodEmitter initEmitter) {
        MethodVisitor mv = initEmitter.getMethodVisitor();
        List<Expr> strings = this.decl.getStrings();
        mv.visitIntInsn(16, strings.size());
        mv.visitTypeInsn(189, "java/lang/String");
        int i = 0;
        while (i < strings.size()) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            initEmitter.emitString(strings.get(i));
            mv.visitInsn(83);
            ++i;
        }
        List<Expr> keys = this.decl.getKeyCols();
        int numKeyCols = keys != null ? keys.size() : 0;
        mv.visitIntInsn(16, numKeyCols);
        mv.visitTypeInsn(189, "java/lang/String");
        int i2 = 0;
        while (i2 < numKeyCols) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i2);
            Expr key = keys.get(i2);
            if (key instanceof BinaryExpr) {
                key = ((BinaryExpr)key).getRHS();
            }
            String name = ((Reference)key).getIdentifier().toString();
            mv.visitLdcInsn((Object)name);
            mv.visitInsn(83);
            ++i2;
        }
        Expr inExpr = this.decl.getInExpr();
        if (inExpr != null) {
            inExpr.accept(initEmitter);
        } else {
            mv.visitInsn(1);
        }
        List<ColGroup> dataCols = this.decl.getDataCols();
        mv.visitIntInsn(16, dataCols.size());
        mv.visitTypeInsn(189, "sampl/lang/Parameter");
        int i3 = 0;
        while (i3 < dataCols.size()) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i3);
            Referable decl = dataCols.get(i3).getDecl();
            if (decl != null) {
                initEmitter.emitEntityReference(decl);
            } else {
                mv.visitInsn(1);
            }
            mv.visitInsn(83);
            ++i3;
        }
        mv.visitMethodInsn(183, "sampl/lang/TableMap", "addTable", "(Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/String;Ljava/util/Set;[Lsampl/lang/Parameter;)Lsampl/lang/Table;");
        mv.visitInsn(87);
    }

    private void emitCollectData() {
        MethodEmitter me = this.classEmitter.beginMethod(17, "collectData", "(Lsampl/lang/SAMPL;Ljava/util/List;)V");
        MethodVisitor mv = me.getMethodVisitor();
        int listVar = 2;
        Expr keySet = this.decl.getKeySet();
        List<Expr> keyCols = this.decl.getKeyCols();
        IndexingCompiler indexingEmitter = null;
        indexingEmitter = keySet != null ? new IndexingCompiler(me, Arrays.asList(keySet)) : new IndexingCompiler(me, keyCols);
        indexingEmitter.start();
        mv.visitVarInsn(25, listVar);
        int keyVar = indexingEmitter.getKeyVar();
        mv.visitVarInsn(25, keyVar);
        if (keyCols.size() != 1) {
            if (keySet != null) {
                mv.visitTypeInsn(192, "sampl/Tuple");
            }
            mv.visitMethodInsn(182, "sampl/Tuple", "clone", "()Lsampl/Tuple;");
        }
        mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
        mv.visitInsn(87);
        for (ColGroup col : this.decl.getDataCols()) {
            Expr expr = col.getExpr();
            mv.visitVarInsn(25, listVar);
            me.emitBoxed(expr);
            if (expr.getType() instanceof MapType) {
                mv.visitVarInsn(25, keyVar);
                mv.visitMethodInsn(182, "sampl/lang/Parameter", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            }
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
        }
        indexingEmitter.end();
        mv.visitInsn(177);
        me.endMethod();
    }

    private void emitAddRow(Referable[] keyDecls, boolean readSets) {
        MethodEmitter me = this.classEmitter.beginMethod(17, "addRow", "(Lsampl/lang/SAMPL;Ljava/lang/Object;[Ljava/lang/Object;)V");
        MethodVisitor mv = me.getMethodVisitor();
        int keyVar = 2;
        int valuesVar = 3;
        Label end = new Label();
        int index = 0;
        Referable[] referableArray = keyDecls;
        int n = keyDecls.length;
        int n2 = 0;
        while (n2 < n) {
            Referable keyDecl = referableArray[n2];
            Label skipCheck = new Label();
            if (!readSets) {
                me.emitEntityReference(keyDecl);
                mv.visitMethodInsn(182, "sampl/lang/SetMap", "hasData", "()Z");
                mv.visitJumpInsn(153, skipCheck);
            }
            me.emitEntityReference(keyDecl);
            mv.visitInsn(1);
            mv.visitMethodInsn(182, "sampl/lang/SetMap", "get", "(Ljava/lang/Object;)Ljava/util/Set;");
            mv.visitVarInsn(25, keyVar);
            if (keyDecls.length != 1) {
                mv.visitTypeInsn(192, "sampl/Tuple");
                mv.visitIntInsn(16, index);
                int dimen = keyDecl.getType().getDimension();
                if (dimen == 1) {
                    mv.visitMethodInsn(182, "sampl/Tuple", "get", "(I)Ljava/lang/Object;");
                } else {
                    mv.visitIntInsn(16, index + dimen);
                    mv.visitMethodInsn(182, "sampl/Tuple", "subtuple", "(II)Ljava/lang/Object;");
                }
                index += dimen;
            }
            if (readSets) {
                mv.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z");
                mv.visitInsn(87);
            } else {
                mv.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z");
                mv.visitJumpInsn(153, end);
            }
            mv.visitLabel(skipCheck);
            ++n2;
        }
        for (Expr keyCol : this.decl.getKeyCols()) {
            if (!(keyCol instanceof BinaryExpr)) continue;
            IndexDef indexDef = (IndexDef)((BinaryExpr)keyCol).getLHS();
            mv.visitVarInsn(25, keyVar);
            mv.visitVarInsn(58, indexDef.getVarIndex());
        }
        List<ColGroup> dataCols = this.decl.getDataCols();
        int i = 0;
        int n3 = dataCols.size();
        while (i < n3) {
            ColGroup colGroup = dataCols.get(i);
            if (colGroup.getDirection() != Direction.OUT) {
                Expr expr = colGroup.getExpr();
                if (expr.getType() instanceof MapType) {
                    me.emitEntityReference(dataCols.get(i).getDecl());
                    mv.visitVarInsn(25, keyVar);
                    mv.visitVarInsn(25, valuesVar);
                    mv.visitIntInsn(16, i);
                    mv.visitInsn(50);
                    mv.visitMethodInsn(182, "sampl/lang/Parameter", "insert", "(Ljava/lang/Object;Ljava/lang/Object;)V");
                } else {
                    me.emitLValue(expr);
                    mv.visitVarInsn(25, valuesVar);
                    mv.visitIntInsn(16, i);
                    mv.visitInsn(50);
                    me.emitAssignment(Types.SYMBOLIC, true);
                }
            }
            ++i;
        }
        mv.visitLabel(end);
        mv.visitInsn(177);
        me.endMethod();
    }

    @Override
    void emitMembers() {
        Object colName;
        Referable[] keyDecls;
        boolean readSets;
        MethodEmitter me = this.classEmitter.beginMethod(17, "getColumns", "(Lsampl/lang/SAMPL;Z)Ljava/util/List;");
        MethodVisitor mv = me.getMethodVisitor();
        Expr keySet = this.decl.getKeySet();
        Direction dir = this.decl.getDirection();
        boolean bl = readSets = dir == Direction.IN || dir == Direction.INOUT;
        if (keySet != null) {
            keyDecls = new Referable[]{keySet.getTarget()};
        } else if (this.decl.hasSetNames()) {
            List<Expr> keyCols = this.decl.getKeyCols();
            int numKeyCols = keyCols.size();
            keyDecls = new Referable[numKeyCols];
            int i = 0;
            while (i < numKeyCols) {
                Expr keyCol = keyCols.get(i);
                colName = keyCol instanceof BinaryExpr ? ((BinaryExpr)keyCol).getRHS() : keyCol;
                keyDecls[i] = ((Expr)colName).getTarget();
                ++i;
            }
        } else {
            keyDecls = new Referable[]{};
        }
        if (readSets) {
            Label endClear = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitJumpInsn(153, endClear);
            colName = keyDecls;
            int keyCol = keyDecls.length;
            int n = 0;
            while (n < keyCol) {
                Object decl = colName[n];
                if (decl != null) {
                    me.emitEntityReference((Referable)decl);
                    mv.visitInsn(1);
                    mv.visitTypeInsn(187, "java/util/LinkedHashSet");
                    mv.visitInsn(89);
                    mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V");
                    mv.visitMethodInsn(182, "sampl/lang/SetMap", "put", "(Ljava/lang/Object;Ljava/util/Set;)Z");
                    mv.visitInsn(87);
                }
                ++n;
            }
            mv.visitLabel(endClear);
        }
        List<ColGroup> dataCols = this.decl.getDataCols();
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)dataCols.size());
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V");
        for (ColGroup colGroup : dataCols) {
            mv.visitInsn(89);
            mv.visitTypeInsn(187, "sampl/lang/Column");
            mv.visitInsn(89);
            String colName2 = colGroup.getName();
            Expr expr = colGroup.getExpr();
            if (colName2 == null) {
                colName2 = me.format(expr);
            }
            mv.visitLdcInsn((Object)colName2);
            mv.visitMethodInsn(183, "sampl/lang/Column", "<init>", "(Ljava/lang/String;)V");
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
        }
        mv.visitInsn(176);
        me.endMethod();
        if (this.decl.hasSetNames()) {
            this.emitCollectData();
        }
        this.emitAddRow(keyDecls, readSets);
    }
}

