/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import org.objectweb.asm.MethodVisitor;
import sampl.ast.Attr;
import sampl.ast.Decl;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.SetDecl;
import sampl.ast.UnaryAttr;
import sampl.codegen.AbstractASTCompiler;
import sampl.codegen.DeclCompiler;
import sampl.codegen.IndexingCompiler;
import sampl.codegen.MethodEmitter;

final class SetDeclCompiler
extends DeclCompiler {
    private SetDecl decl;
    private Expr initializer;
    private boolean hasInitializer;
    private MethodEmitter checkEmitter;

    SetDeclCompiler(AbstractASTCompiler ce, SetDecl decl) {
        super(ce);
        this.decl = decl;
    }

    @Override
    String getParentName() {
        return "sampl/lang/SetMap";
    }

    @Override
    Decl getDecl() {
        return this.decl;
    }

    @Override
    void emitItem(MethodEmitter initEmitter) {
        MethodVisitor mv = initEmitter.getMethodVisitor();
        if (this.initializer != null) {
            initEmitter.emit(this.initializer);
        } else {
            mv.visitInsn(1);
        }
        String methodName = this.hasInitializer ? "putInitial" : "putDefault";
        mv.visitMethodInsn(182, this.getParentName(), methodName, "(Ljava/lang/Object;Ljava/util/Set;)V");
    }

    @Override
    void emitConstructor() {
        MethodEmitter me = this.classEmitter.beginMethod(1, "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;)V");
        MethodVisitor mv = me.getMethodVisitor();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(this.hasInitializer ? 4 : 3);
        mv.visitMethodInsn(183, this.getParentName(), "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;Z)V");
        mv.visitInsn(177);
        me.endMethod();
    }

    @Override
    void emitMembers() {
        this.checkEmitter = this.classEmitter.beginMethod(20, "check", "()V");
        MethodVisitor mv = this.checkEmitter.getMethodVisitor();
        this.prepareEnvironment(this.checkEmitter);
        Indexing indexing = this.decl.getIndexing();
        this.indexingEmitter = null;
        if (indexing != null) {
            this.indexingEmitter = new IndexingCompiler(this.checkEmitter, indexing);
            this.indexingEmitter.start();
        }
        for (Attr attr : this.decl.getAttrs()) {
            attr.accept(this);
        }
        if (indexing != null) {
            this.indexingEmitter.end();
        }
        mv.visitInsn(177);
        this.checkEmitter.endMethod();
    }

    @Override
    public void visit(UnaryAttr attr) {
        MethodVisitor mv = this.checkEmitter.getMethodVisitor();
        Expr arg = attr.getArg();
        switch (attr.getKind()) {
            default: {
                assert (false) : "Invalid attribute.";
            }
            case IN: 
            case WITHIN: {
                this.emitEntityAndKey(mv);
                this.checkEmitter.emit(arg);
                mv.visitLdcInsn((Object)this.checkEmitter.format(arg));
                mv.visitMethodInsn(184, "sampl/lang/SAMPL", "checkWithin", "(Lsampl/lang/SetMap;Ljava/lang/Object;Ljava/util/Set;Ljava/lang/String;)V");
                break;
            }
            case EQ: 
            case ASSIGN: {
                this.hasInitializer = true;
            }
            case DEFAULT: {
                this.initializer = arg;
            }
            case DIMEN: 
        }
    }
}

