/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import org.objectweb.asm.MethodVisitor;
import sampl.Integrality;
import sampl.ast.Attr;
import sampl.ast.Decl;
import sampl.ast.DistAttr;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.ParameterDecl;
import sampl.ast.UnaryAttr;
import sampl.codegen.AbstractASTCompiler;
import sampl.codegen.DeclCompiler;
import sampl.codegen.IndexingCompiler;
import sampl.codegen.MethodEmitter;
import sampl.types.Types;

final class ParameterDeclCompiler
extends DeclCompiler {
    private ParameterDecl decl;
    private Expr value;
    private boolean hasInitializer;
    private MethodEmitter checkEmitter;
    private DistAttr dist;

    ParameterDeclCompiler(AbstractASTCompiler ce, ParameterDecl decl) {
        super(ce);
        this.decl = decl;
    }

    @Override
    String getParentName() {
        return "sampl/lang/Parameter";
    }

    @Override
    Decl getDecl() {
        return this.decl;
    }

    @Override
    void emitItem(MethodEmitter initEmitter) {
        MethodVisitor mv = initEmitter.getMethodVisitor();
        if (this.dist != null) {
            mv.visitTypeInsn(187, "sampl/lang/SymmetricRV");
            mv.visitInsn(89);
            initEmitter.emitNumber(this.dist.getLower());
            initEmitter.emitNumber(this.dist.getUpper());
            mv.visitMethodInsn(183, "sampl/lang/SymmetricRV", "<init>", "(DD)V");
        } else if (this.value != null) {
            initEmitter.emitBoxed(this.value);
        } else {
            mv.visitInsn(1);
        }
        String methodName = this.hasInitializer ? "putInitial" : "putDefault";
        mv.visitMethodInsn(182, this.getParentName(), methodName, "(Ljava/lang/Object;Ljava/lang/Object;)V");
    }

    @Override
    void emitConstructor() {
        MethodEmitter me = this.classEmitter.beginMethod(1, "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;)V");
        MethodVisitor mv = me.getMethodVisitor();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(this.value != null ? 4 : 3);
        mv.visitMethodInsn(183, this.getParentName(), "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;Z)V");
        mv.visitInsn(177);
        me.endMethod();
    }

    @Override
    void emitMembers() {
        Integrality type;
        this.checkEmitter = this.classEmitter.beginMethod(20, "check", "(Lsampl/lang/SAMPL;)V");
        MethodVisitor mv = this.checkEmitter.getMethodVisitor();
        int set = -1;
        Indexing indexing = this.decl.getIndexing();
        this.indexingEmitter = null;
        if (indexing != null) {
            mv.visitTypeInsn(187, "java/util/LinkedHashSet");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V");
            set = this.checkEmitter.getVarIndex();
            mv.visitVarInsn(58, set);
            this.indexingEmitter = new IndexingCompiler(this.checkEmitter, indexing);
            this.indexingEmitter.start();
            mv.visitVarInsn(25, set);
            mv.visitVarInsn(25, this.indexingEmitter.getKeyVar());
            if (indexing.getNumParts() != 1) {
                mv.visitMethodInsn(182, "sampl/Tuple", "clone", "()Lsampl/Tuple;");
            }
            mv.visitMethodInsn(182, "java/util/LinkedHashSet", "add", "(Ljava/lang/Object;)Z");
            mv.visitInsn(87);
        }
        if ((type = this.decl.getNumericType()) != null && (type == Integrality.INTEGER || type == Integrality.BINARY)) {
            this.emitEntityAndKey(mv);
            String methodName = type == Integrality.INTEGER ? "checkInteger" : "checkBinary";
            mv.visitMethodInsn(184, "sampl/lang/SAMPL", methodName, "(Lsampl/lang/Parameter;Ljava/lang/Object;)V");
        }
        for (Attr attr : this.decl.getAttrs()) {
            attr.accept(this);
        }
        if (indexing != null) {
            this.indexingEmitter.end();
        }
        if (indexing != null) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, set);
            mv.visitMethodInsn(184, "sampl/lang/SAMPL", "checkIndexing", "(Lsampl/lang/Parameter;Ljava/util/Set;)V");
        }
        mv.visitInsn(177);
        this.checkEmitter.endMethod();
    }

    @Override
    void emitAddEntity() {
        if (!this.decl.isProbability()) {
            return;
        }
        MethodEmitter me = this.compiler.getBlockMethodEmitter();
        MethodVisitor mv = me.getMethodVisitor();
        me.emitEnvironmentRef();
        mv.visitTypeInsn(187, this.name);
        mv.visitInsn(89);
        me.emitEnvironmentRef();
        mv.visitLdcInsn((Object)this.decl.getName());
        mv.visitMethodInsn(183, this.name, "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;)V");
        mv.visitMethodInsn(182, "sampl/lang/SAMPL", "addProbability", "(Lsampl/lang/Parameter;)V");
    }

    private void emitCheck(String methodName, Expr arg) {
        MethodVisitor mv = this.checkEmitter.getMethodVisitor();
        this.emitEntityAndKey(mv);
        this.checkEmitter.emitNumeric(arg);
        mv.visitMethodInsn(184, "sampl/lang/SAMPL", methodName, "(Lsampl/lang/Parameter;Ljava/lang/Object;D)V");
    }

    @Override
    public void visit(UnaryAttr attr) {
        MethodVisitor mv = this.checkEmitter.getMethodVisitor();
        Expr arg = attr.getArg();
        switch (attr.getKind()) {
            default: {
                assert (false) : "Invalid attribute.";
            }
            case LT: {
                this.emitCheck("checkLess", arg);
                break;
            }
            case LE: {
                this.emitCheck("checkLessEqual", arg);
                break;
            }
            case GT: {
                this.emitCheck("checkGreater", arg);
                break;
            }
            case GE: {
                this.emitCheck("checkGreaterEqual", arg);
                break;
            }
            case NE: {
                String typeDescriptor;
                this.emitEntityAndKey(mv);
                if (arg.getType() == Types.NUMERIC) {
                    typeDescriptor = "D";
                    this.checkEmitter.emitNumeric(arg);
                } else {
                    typeDescriptor = "Ljava/lang/Object;";
                    this.checkEmitter.emit(arg);
                }
                mv.visitMethodInsn(184, "sampl/lang/SAMPL", "checkNotEqual", "(Lsampl/lang/Parameter;Ljava/lang/Object;" + typeDescriptor + ")V");
                break;
            }
            case IN: 
            case WITHIN: {
                this.emitEntityAndKey(mv);
                this.checkEmitter.emit(arg);
                mv.visitLdcInsn((Object)this.checkEmitter.format(arg));
                mv.visitMethodInsn(184, "sampl/lang/SAMPL", "checkIn", "(Lsampl/lang/Parameter;Ljava/lang/Object;Ljava/util/Set;Ljava/lang/String;)V");
                break;
            }
            case EQ: 
            case ASSIGN: {
                this.hasInitializer = true;
            }
            case DEFAULT: {
                this.value = arg;
            }
        }
    }

    @Override
    public void visit(DistAttr attr) {
        this.dist = attr;
    }
}

