/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import sampl.ast.ASTVisitor;
import sampl.ast.BasicStmt;
import sampl.ast.BinaryExpr;
import sampl.ast.CallExpr;
import sampl.ast.CheckDecl;
import sampl.ast.CheckStmt;
import sampl.ast.ColGroup;
import sampl.ast.CompoundStmt;
import sampl.ast.Condition;
import sampl.ast.ConditionalExpr;
import sampl.ast.ConstraintDecl;
import sampl.ast.Decl;
import sampl.ast.DoubleInequalityExpr;
import sampl.ast.EmptyStmt;
import sampl.ast.Expr;
import sampl.ast.FixStmt;
import sampl.ast.ForStmt;
import sampl.ast.Function;
import sampl.ast.IfStmt;
import sampl.ast.IndexDef;
import sampl.ast.IndexedExpr;
import sampl.ast.Indexing;
import sampl.ast.IteratedExpr;
import sampl.ast.JumpStmt;
import sampl.ast.LetStmt;
import sampl.ast.LoopContext;
import sampl.ast.NetExpr;
import sampl.ast.Node;
import sampl.ast.NumericLiteral;
import sampl.ast.ObjectiveDecl;
import sampl.ast.Option;
import sampl.ast.OptionStmt;
import sampl.ast.OutputStmt;
import sampl.ast.ParameterDecl;
import sampl.ast.ParenExpr;
import sampl.ast.PiecewiseLinearExpr;
import sampl.ast.ProblemDecl;
import sampl.ast.RangeExpr;
import sampl.ast.ReadStmt;
import sampl.ast.Referable;
import sampl.ast.Reference;
import sampl.ast.RepeatStmt;
import sampl.ast.SetDecl;
import sampl.ast.SetLiteral;
import sampl.ast.StringLiteral;
import sampl.ast.SubscriptExpr;
import sampl.ast.Suffix;
import sampl.ast.SuffixExpr;
import sampl.ast.TableDecl;
import sampl.ast.TableIOStmt;
import sampl.ast.TreeDecl;
import sampl.ast.UnaryExpr;
import sampl.ast.VariableDecl;
import sampl.codegen.IndexingCompiler;
import sampl.types.MapType;
import sampl.types.SetType;
import sampl.types.Type;
import sampl.types.Types;

final class MethodEmitter
implements ASTVisitor {
    private MethodVisitor mv;
    private int nextVarIndex;
    private boolean lvalue;
    private String lvalueClassName;
    private String lvalueFieldName;
    private IntStack exprBuilderVars = new IntStack();
    private Map<String, String> argsToDescriptor = new HashMap<String, String>();
    private boolean useExprBuilder;
    private Map<LoopContext, Loop> loops = new HashMap<LoopContext, Loop>();

    void emit(Expr e) {
        e.accept(this);
    }

    void emitEnvironmentRef() {
        this.mv.visitVarInsn(25, 1);
    }

    private void emitArray(List<Expr> items) {
        if (items.size() != 1 || !(items.get(0) instanceof IndexedExpr)) {
            this.mv.visitIntInsn(16, items.size());
            this.mv.visitIntInsn(188, 7);
            int i = 0;
            int n = items.size();
            while (i < n) {
                this.mv.visitInsn(89);
                this.mv.visitIntInsn(16, i);
                this.emitNumeric(items.get(i));
                this.mv.visitInsn(82);
                ++i;
            }
            return;
        }
        int list = this.getVarIndex();
        this.mv.visitTypeInsn(187, "java/util/ArrayList");
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
        this.mv.visitVarInsn(58, list);
        IndexedExpr indexed = (IndexedExpr)items.get(0);
        Indexing indexing = indexed.getIndexing();
        IndexingCompiler emitter = new IndexingCompiler(this, indexing);
        emitter.start();
        this.mv.visitVarInsn(25, list);
        this.emitNumeric(indexed.getArg());
        this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        this.mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
        this.mv.visitInsn(87);
        emitter.end();
        this.mv.visitVarInsn(25, list);
        this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "listToArray", "(Ljava/util/List;)[D");
    }

    private void emitArgs(BinaryExpr expr) {
        this.emitNumeric(expr.getLHS());
        this.emitNumeric(expr.getRHS());
    }

    private void emitCondition(int opcode) {
        Label trueLabel = new Label();
        this.mv.visitJumpInsn(opcode, trueLabel);
        this.mv.visitInsn(3);
        Label endLabel = new Label();
        this.mv.visitJumpInsn(167, endLabel);
        this.mv.visitLabel(trueLabel);
        this.mv.visitInsn(4);
        this.mv.visitLabel(endLabel);
    }

    private void emitRelationalExpr(BinaryExpr expr, int opcode) {
        this.emitArgs(expr);
        this.mv.visitInsn(152);
        this.emitCondition(opcode);
    }

    private void emitEqualityExpr(BinaryExpr expr, int opcode) {
        Expr lhs = expr.getLHS();
        Expr rhs = expr.getRHS();
        if (lhs.hasNumericType()) {
            this.emit(lhs);
            if (rhs.hasNumericType()) {
                this.emit(rhs);
                this.mv.visitInsn(152);
                this.emitCondition(opcode);
                return;
            }
            Expr temp = lhs;
            lhs = rhs;
            rhs = temp;
        }
        this.emit(lhs);
        this.emit(rhs);
        if (rhs.hasNumericType()) {
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        }
        this.mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        this.emitCondition(opcode == 154 ? 153 : 154);
    }

    int emitRuntimeExpr(Expr expr, int exprBuilderVar) {
        if (exprBuilderVar == 0) {
            this.mv.visitTypeInsn(187, "sampl/lang/ExprBuilder");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "sampl/lang/ExprBuilder", "<init>", "()V");
            exprBuilderVar = this.getVarIndex();
            this.mv.visitVarInsn(58, exprBuilderVar);
        }
        this.exprBuilderVars.push(exprBuilderVar);
        this.useExprBuilder = true;
        try {
            if (expr != null) {
                this.emitNumeric(expr);
            }
            this.mv.visitVarInsn(25, exprBuilderVar);
        }
        finally {
            this.useExprBuilder = false;
            this.exprBuilderVars.pop();
        }
        return exprBuilderVar;
    }

    private void emitScenarioProbability(int scenario) {
        this.emitEnvironmentRef();
        this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "getCurrentProblem", "()Lsampl/lang/Problem;");
        this.mv.visitMethodInsn(182, "sampl/lang/Problem", "probabilities", "()Lsampl/lang/Parameter;");
        this.mv.visitVarInsn(25, scenario);
        this.mv.visitMethodInsn(182, "sampl/lang/Parameter", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        this.mv.visitTypeInsn(192, "java/lang/Double");
        this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
    }

    private void emitDisplayPrefix(Indexing indexing, Expr arg) {
        StringBuilder sb = new StringBuilder();
        arg.format(sb);
        if (indexing.getDimension() == 1) {
            sb.append(" [*]");
        }
        sb.append(" :=");
        this.mv.visitLdcInsn((Object)sb.toString());
    }

    private void emitDisplayArgs(List<Expr> args, int writer) {
        if (args.isEmpty()) {
            this.mv.visitVarInsn(25, writer);
            this.mv.visitMethodInsn(182, "java/io/PrintWriter", "println", "()V");
            return;
        }
        for (Expr arg : args) {
            SuffixExpr suffixExpr;
            Referable decl;
            Indexing indexing;
            this.mv.visitVarInsn(25, writer);
            if (arg.hasMapType()) {
                arg = this.unwrap(arg);
            }
            if (arg instanceof IndexedExpr) {
                IndexedExpr indexed = (IndexedExpr)arg;
                arg = indexed.getArg();
                Indexing indexing2 = indexed.getIndexing();
                this.mv.visitInsn(89);
                this.emitDisplayPrefix(indexing2, arg);
                this.mv.visitMethodInsn(182, "java/io/PrintWriter", "println", "(Ljava/lang/String;)V");
                IndexingCompiler emitter = new IndexingCompiler(this, indexing2);
                emitter.start();
                this.mv.visitVarInsn(25, writer);
                this.mv.visitVarInsn(25, emitter.getKeyVar());
                arg.accept(this);
                Type argType = arg.getType();
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "display", "(Ljava/io/PrintWriter;Ljava/lang/Object;" + argType.getDescriptor() + ")V");
                emitter.end();
                this.mv.visitIntInsn(16, 59);
                this.mv.visitMethodInsn(182, "java/io/PrintWriter", "println", "(C)V");
                continue;
            }
            if (arg instanceof Reference) {
                Referable decl2 = arg.getTarget();
                Indexing indexing3 = decl2.getIndexing();
                if (indexing3 != null) {
                    if (decl2 instanceof SetDecl) {
                        this.emitEntityReference(decl2);
                        this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "display", "(Ljava/io/PrintWriter;Lsampl/lang/SetMap;)V");
                        continue;
                    }
                    this.emitDisplayPrefix(indexing3, arg);
                    this.emitEntityReference(decl2);
                    this.mv.visitInsn(1);
                    this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "display", "(Ljava/io/PrintWriter;Ljava/lang/String;Lsampl/lang/Entity;Ljava/lang/String;)V");
                    continue;
                }
            } else if (arg instanceof SuffixExpr && (indexing = (decl = (suffixExpr = (SuffixExpr)arg).getReference().getTarget()).getIndexing()) != null) {
                this.emitDisplayPrefix(indexing, arg);
                this.emitEntityReference(decl);
                this.mv.visitLdcInsn((Object)suffixExpr.getSuffix().getName());
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "display", "(Ljava/io/PrintWriter;Ljava/lang/String;Lsampl/lang/Entity;Ljava/lang/String;)V");
                continue;
            }
            Type argType = arg.getType();
            boolean isSet = argType instanceof SetType;
            StringBuilder sb = new StringBuilder();
            if (isSet) {
                sb.append("set ");
            }
            arg.format(sb);
            sb.append(isSet ? " := " : " = ");
            this.mv.visitLdcInsn((Object)sb.toString());
            arg.accept(this);
            this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "display", "(Ljava/io/PrintWriter;Ljava/lang/String;" + argType.getDescriptor() + ")V");
        }
    }

    private void emitPrintArg(Expr arg, int writer, int isFirst) {
        this.mv.visitVarInsn(25, writer);
        Label end = new Label();
        this.mv.visitVarInsn(21, isFirst);
        this.mv.visitJumpInsn(154, end);
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, 32);
        this.mv.visitMethodInsn(182, "java/io/PrintWriter", "print", "(C)V");
        this.mv.visitLabel(end);
        this.mv.visitInsn(3);
        this.mv.visitVarInsn(54, isFirst);
        arg.accept(this);
        if (arg.hasNumericType()) {
            this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "print", "(Ljava/io/PrintWriter;D)V");
        } else if (arg.hasLogicalType()) {
            this.mv.visitMethodInsn(182, "java/io/PrintWriter", "print", "(Z)V");
        } else {
            this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "print", "(Ljava/io/Writer;Ljava/lang/Object;)V");
        }
    }

    private Expr unwrap(Expr e) {
        while (e instanceof ParenExpr) {
            ParenExpr parenExpr = (ParenExpr)e;
            if (parenExpr.getNumItems() != 1) break;
            e = parenExpr.getItem(0);
        }
        return e;
    }

    private void emitPrintArgs(List<Expr> args, int writer) {
        if (!args.isEmpty()) {
            int isFirst = this.getVarIndex();
            this.mv.visitInsn(4);
            this.mv.visitVarInsn(54, isFirst);
            for (Expr arg : args) {
                if (arg.hasMapType()) {
                    arg = this.unwrap(arg);
                }
                if (arg instanceof IndexedExpr) {
                    IndexedExpr indexed = (IndexedExpr)arg;
                    arg = indexed.getArg();
                    IndexingCompiler emitter = new IndexingCompiler(this, indexed.getIndexing());
                    emitter.start();
                    this.emitPrintArg(arg, writer, isFirst);
                    emitter.end();
                    continue;
                }
                this.emitPrintArg(arg, writer, isFirst);
            }
        }
        this.mv.visitVarInsn(25, writer);
        this.mv.visitMethodInsn(182, "java/io/PrintWriter", "println", "()V");
    }

    private void emitPrintfArg(Expr arg) {
        this.emitBoxed(arg);
        this.mv.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z");
        this.mv.visitInsn(87);
    }

    private void emitPrintfArgs(List<Expr> args, int writer) {
        this.mv.visitVarInsn(25, writer);
        args.get(0).accept(this);
        this.mv.visitTypeInsn(187, "java/util/ArrayList");
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, args.size() - 1);
        this.mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V");
        int i = 1;
        while (i < args.size()) {
            Expr arg = args.get(i);
            this.mv.visitInsn(89);
            if (!(arg instanceof IndexedExpr)) {
                this.emitPrintfArg(arg);
            } else {
                int list = this.getVarIndex();
                this.mv.visitVarInsn(58, list);
                IndexedExpr indexed = (IndexedExpr)arg;
                arg = indexed.getArg();
                IndexingCompiler emitter = new IndexingCompiler(this, indexed.getIndexing());
                emitter.start();
                this.mv.visitVarInsn(25, list);
                this.emitPrintfArg(arg);
                emitter.end();
            }
            ++i;
        }
        this.mv.visitMethodInsn(182, "java/util/ArrayList", "toArray", "()[Ljava/lang/Object;");
        this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "printf", "(Ljava/io/PrintWriter;Ljava/lang/String;[Ljava/lang/Object;)V");
    }

    private void emitExpandArg(Expr arg, int writer) {
        String className;
        arg.accept(this);
        Type type = arg.getType();
        if (type instanceof MapType) {
            className = (type = ((MapType)type).getValueType()) == Types.CONSTRAINT ? "sampl/lang/ConstraintMap" : "sampl/lang/ObjectiveMap";
        } else {
            className = type.getDescriptor();
            className = className.substring(1, className.length() - 1);
        }
        this.mv.visitVarInsn(25, writer);
        this.mv.visitMethodInsn(182, className, "expand", "(Ljava/io/Writer;)V");
    }

    private void emitExpandArgs(List<Expr> args, int writer) {
        if (args.isEmpty()) {
            this.emitEnvironmentRef();
            this.mv.visitVarInsn(25, writer);
            this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "expand", "(Ljava/io/Writer;)V");
            return;
        }
        for (Expr arg : args) {
            if (arg instanceof IndexedExpr) {
                IndexedExpr indexed = (IndexedExpr)arg;
                arg = indexed.getArg();
                IndexingCompiler emitter = new IndexingCompiler(this, indexed.getIndexing());
                emitter.start();
                this.emitExpandArg(arg, writer);
                emitter.end();
                continue;
            }
            this.emitExpandArg(arg, writer);
        }
    }

    private void emitXrefArgs(List<Expr> args, int writer) {
        for (Expr arg : args) {
            this.emitEntityReference((Decl)arg.getTarget());
            this.mv.visitVarInsn(25, writer);
            this.mv.visitMethodInsn(182, "sampl/lang/Entity", "xref", "(Ljava/io/PrintWriter;)V");
        }
    }

    private void emitTuple(List<Expr> items) {
        int numItems = items.size();
        this.mv.visitTypeInsn(187, "sampl/Tuple");
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, numItems);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        while (i < numItems) {
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, i);
            this.emitBoxed(items.get(i));
            this.mv.visitInsn(83);
            ++i;
        }
        this.mv.visitMethodInsn(183, "sampl/Tuple", "<init>", "([Ljava/lang/Object;)V");
    }

    private void emitTupleWithoutItem(List<Expr> items, int excludeIndex) {
        int numItems = items.size();
        this.mv.visitTypeInsn(187, "sampl/Tuple");
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, numItems);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        while (i < numItems) {
            if (i != excludeIndex) {
                this.mv.visitInsn(89);
                this.mv.visitIntInsn(16, i);
                this.emitBoxed(items.get(i));
                this.mv.visitInsn(83);
            }
            ++i;
        }
        this.mv.visitMethodInsn(183, "sampl/Tuple", "<init>", "([Ljava/lang/Object;)V");
    }

    void emitLValue(Expr expr) {
        try {
            this.lvalue = true;
            this.lvalueFieldName = null;
            expr.accept(this);
        }
        finally {
            this.lvalue = false;
        }
    }

    void emitAssignment(Type type, boolean insert) {
        String desc = type.getDescriptor();
        if (this.lvalueFieldName != null) {
            this.mv.visitMethodInsn(182, this.lvalueClassName, this.lvalueFieldName, "(" + desc + ")V");
        } else if (insert) {
            this.mv.visitMethodInsn(182, this.lvalueClassName, "insert", "(Ljava/lang/Object;" + desc + ")V");
        } else {
            this.mv.visitMethodInsn(182, this.lvalueClassName, "put", "(Ljava/lang/Object;" + desc + ")Z");
            this.mv.visitInsn(87);
        }
    }

    void emitVariableGlobalFixUnfix(boolean fix, boolean withValue) {
        String fname = fix ? "fix" : "unfix";
        String msignature = withValue ? "(D)V" : "()V";
        this.mv.visitMethodInsn(182, this.lvalueClassName, fname, msignature);
    }

    private String getNumericDescriptor(Expr expr) {
        Type type = expr.getType();
        if (type == Types.VARIABLE) {
            return Types.EXPR.getDescriptor();
        }
        return type != Types.SYMBOLIC ? type.getDescriptor() : "D";
    }

    private String getDescriptor(BinaryExpr expr) {
        return "(" + this.getNumericDescriptor(expr.getLHS()) + this.getNumericDescriptor(expr.getRHS()) + ")" + expr.getType().getDescriptor();
    }

    String emitEntityReference(Referable decl) {
        String name = "sampl/lang/" + decl.getClassName();
        this.emitEnvironmentRef();
        this.mv.visitLdcInsn((Object)decl.getName());
        this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "getEntity", "(Ljava/lang/String;)Lsampl/lang/Entity;");
        this.mv.visitTypeInsn(192, name);
        return name;
    }

    void doEmitItem(Type declType, Type exprType, String name) {
        if (declType == Types.NUMERIC) {
            this.mv.visitMethodInsn(182, name, "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            this.mv.visitTypeInsn(192, "java/lang/Double");
            this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        } else if (exprType == Types.NUMERIC) {
            this.mv.visitMethodInsn(182, name, "getValue", "(Ljava/lang/Object;)D");
        } else {
            this.mv.visitMethodInsn(182, name, "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            String desc = declType.getDescriptor();
            this.mv.visitTypeInsn(192, desc.substring(1, desc.length() - 1));
        }
    }

    public MethodEmitter(MethodVisitor mv, int numArgs) {
        this.mv = mv;
        this.nextVarIndex = numArgs + 1;
    }

    public static String getClassName(Decl d) {
        return "entities." + d.getName();
    }

    int getVarIndex() {
        return this.nextVarIndex++;
    }

    int getDoubleVarIndex() {
        int index = this.nextVarIndex;
        this.nextVarIndex += 2;
        return index;
    }

    void emitBoxed(Expr expr) {
        expr.accept(this);
        if (expr.hasNumericType()) {
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (expr.hasLogicalType()) {
            this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        }
    }

    void emitNumber(Expr expr) {
        expr.accept(this);
        if (expr.getType() == Types.SYMBOLIC) {
            this.mv.visitTypeInsn(192, "java/lang/Double");
            this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        }
    }

    private boolean isAdditiveOrScaling(Expr e) {
        if (e instanceof BinaryExpr) {
            BinaryExpr bin = (BinaryExpr)e;
            switch (bin.getKind()) {
                case ADD: 
                case SUB: {
                    return true;
                }
                case MUL: {
                    return bin.getLHS().hasNumericOrSymbolicType() || bin.getRHS().hasNumericOrSymbolicType();
                }
                case DIV: {
                    return bin.getRHS().hasNumericOrSymbolicType();
                }
            }
        } else {
            if (e instanceof IteratedExpr) {
                return ((IteratedExpr)e).getKind() == IteratedExpr.Kind.SUM;
            }
            if (e instanceof ParenExpr) {
                List<Expr> items = ((ParenExpr)e).getItems();
                return items.size() == 1 && this.isAdditiveOrScaling(items.get(0));
            }
            if (e instanceof UnaryExpr) {
                UnaryExpr.Kind kind = ((UnaryExpr)e).getKind();
                return kind == UnaryExpr.Kind.MINUS || kind == UnaryExpr.Kind.PLUS;
            }
        }
        return e instanceof ConditionalExpr || e instanceof NetExpr;
    }

    private void emitScaled(Expr multiplier, Expr expr, String functionName) {
        this.mv.visitVarInsn(25, this.exprBuilderVars.top());
        this.mv.visitInsn(89);
        this.emitNumber(multiplier);
        this.mv.visitMethodInsn(182, "sampl/lang/ExprBuilder", functionName, "(D)D");
        this.emitNumeric(expr);
        this.mv.visitMethodInsn(182, "sampl/lang/ExprBuilder", "setMultiplier", "(D)V");
    }

    void emitNumeric(Expr expr) {
        boolean useEB;
        boolean savedUseEB = this.useExprBuilder;
        boolean bl = useEB = this.useExprBuilder && (expr.hasNumericOrSymbolicType() || !this.isAdditiveOrScaling(expr));
        if (useEB) {
            this.useExprBuilder = false;
            this.mv.visitVarInsn(25, this.exprBuilderVars.top());
        }
        this.emitNumber(expr);
        if (useEB) {
            String desc = expr.hasNumericOrSymbolicType() ? "D" : "Lsampl/lang/Expr;";
            this.mv.visitMethodInsn(182, "sampl/lang/ExprBuilder", "add", "(" + desc + ")V");
        }
        this.useExprBuilder = savedUseEB;
    }

    void emitString(Expr expr) {
        if (expr == null) {
            this.mv.visitInsn(1);
            return;
        }
        expr.accept(this);
        Type type = expr.getType();
        if (type == Types.STRING) {
            return;
        }
        this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "convertToString", "(" + type.getDescriptor() + ")Ljava/lang/String;");
    }

    void emitLogical(Expr expr) {
        expr.accept(this);
        Type type = expr.getType();
        if (type == Types.NUMERIC) {
            this.mv.visitInsn(14);
            this.mv.visitInsn(151);
        } else if (type == Types.SYMBOLIC) {
            this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "convertToBoolean", "(Ljava/lang/Object;)Z");
        }
    }

    String format(Expr expr) {
        StringBuilder sb = new StringBuilder();
        expr.format(sb);
        return sb.toString();
    }

    void endMethod() {
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    void emitGetSuffix(Suffix suffix, Type type, boolean isLValue) {
        String descriptor = type.getDescriptor();
        String className = descriptor.substring(1, descriptor.length() - 1);
        if (isLValue) {
            this.lvalueClassName = className;
            this.lvalueFieldName = suffix.getName();
            if (suffix.isInternal()) {
                this.lvalueFieldName = String.valueOf(this.lvalueFieldName) + "Internal";
            }
            return;
        }
        String name = suffix.getName();
        if (suffix.isInternal()) {
            name = String.valueOf(name) + "Internal";
        }
        this.mv.visitMethodInsn(182, className, name, "()" + suffix.getType().getDescriptor());
    }

    private void convert(Type from, Type to) {
        if (from != Types.NUMERIC || to.equals(from)) {
            return;
        }
        if (to == Types.SYMBOLIC) {
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else {
            assert (to == Types.EXPR);
            this.mv.visitMethodInsn(184, "sampl/lang/Number", "valueOf", "(D)Lsampl/lang/Number;");
        }
    }

    MethodVisitor getMethodVisitor() {
        return this.mv;
    }

    @Override
    public void visit(SetDecl node) {
    }

    @Override
    public void visit(ParameterDecl node) {
    }

    @Override
    public void visit(VariableDecl node) {
    }

    @Override
    public void visit(ObjectiveDecl node) {
    }

    @Override
    public void visit(ConstraintDecl node) {
    }

    @Override
    public void visit(ProblemDecl node) {
    }

    @Override
    public void visit(CheckDecl node) {
    }

    @Override
    public void visit(TableDecl node) {
    }

    @Override
    public void visit(TreeDecl node) {
    }

    @Override
    public void visit(ColGroup cg) {
    }

    @Override
    public void visit(NumericLiteral num) {
        double value = num.getValue();
        if (value == 0.0) {
            this.mv.visitInsn(14);
        } else if (value == 1.0) {
            this.mv.visitInsn(15);
        } else {
            this.mv.visitLdcInsn((Object)num.getValue());
        }
    }

    @Override
    public void visit(StringLiteral str) {
        this.mv.visitLdcInsn((Object)str.getValue());
    }

    @Override
    public void visit(SetLiteral set) {
        this.mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, (int)((double)set.getNumMembers() * 1.3));
        this.mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "(I)V");
        for (Expr member : set.getMembers()) {
            this.mv.visitInsn(89);
            this.emitBoxed(member);
            this.mv.visitMethodInsn(182, "java/util/LinkedHashSet", "add", "(Ljava/lang/Object;)Z");
            this.mv.visitInsn(87);
        }
    }

    @Override
    public void visit(Reference ref) {
        Referable target = ref.getTarget();
        if (target instanceof IndexDef) {
            assert (!this.lvalue);
            if (ref.getType() == Types.SCENARIO) {
                this.mv.visitFieldInsn(178, "sampl/lang/SAMPL$Scenario", "INSTANCE", "Lsampl/lang/SAMPL$Scenario;");
            } else {
                this.mv.visitVarInsn(25, ((IndexDef)target).getVarIndex());
            }
            return;
        }
        Decl decl = (Decl)target;
        if (decl.getName().equals("Infinity")) {
            this.mv.visitLdcInsn((Object)Double.POSITIVE_INFINITY);
            return;
        }
        String name = this.emitEntityReference(decl);
        if (decl.getIndexing() != null) {
            return;
        }
        this.mv.visitInsn(1);
        if (this.lvalue) {
            this.lvalueClassName = name;
            return;
        }
        this.doEmitItem(decl.getType(), ref.getType(), name);
    }

    @Override
    public void visit(IndexDef def) {
    }

    @Override
    public void visit(SubscriptExpr expr) {
        int subIndex;
        Reference scenarioSub;
        Decl decl = expr.getTarget();
        List<Expr> subs = expr.getSubscripts();
        Indexing indexing = decl.getIndexing();
        if (indexing.hasScenarioIndex() && !expr.hasNumericType() && decl instanceof ParameterDecl && (scenarioSub = (Reference)subs.get(subIndex = indexing.getScenarioSubIndex())).getType() == Types.SCENARIO) {
            this.emitEntityReference(decl);
            if (subs.size() != 1) {
                this.emitTupleWithoutItem(subs, subIndex);
                this.mv.visitLdcInsn((Object)subIndex);
                this.mv.visitMethodInsn(182, "sampl/lang/Parameter", "getStochastic", "(Lsampl/Tuple;I)Lsampl/lang/DiscreteRV;");
            } else {
                this.mv.visitMethodInsn(182, "sampl/lang/Parameter", "getStochastic", "()Lsampl/lang/DiscreteRV;");
            }
            return;
        }
        String name = this.emitEntityReference(decl);
        boolean isLValue = this.lvalue;
        this.lvalue = false;
        if (expr.getNumSubscripts() == 1) {
            this.emitBoxed(subs.get(0));
        } else {
            this.emitTuple(subs);
        }
        if (isLValue) {
            this.lvalueClassName = name;
            return;
        }
        this.doEmitItem(((MapType)decl.getType()).getValueType(), expr.getType(), name);
    }

    @Override
    public void visit(SuffixExpr expr) {
        Expr ref = expr.getReference();
        boolean isLValue = this.lvalue;
        this.lvalue = false;
        ref.accept(this);
        this.emitGetSuffix(expr.getSuffix(), ref.getType(), isLValue);
    }

    @Override
    public void visit(CallExpr expr) {
        String className;
        Function func = expr.getFunction();
        String name = func.getName();
        List<Expr> args = expr.getArgs();
        String argTypes = func.getArgTypes();
        Function.Kind kind = func.getKind();
        if (kind == Function.Kind.VARARG) {
            boolean first = true;
            for (Expr arg : args) {
                this.emitNumeric(arg);
                if (!first) {
                    this.mv.visitMethodInsn(184, "java/lang/Math", name, "(DD)D");
                    continue;
                }
                first = false;
            }
            return;
        }
        int opcode = 184;
        if (kind == Function.Kind.MATH) {
            className = "java/lang/Math";
            if (name.equals("round")) {
                name = "rint";
            }
        } else {
            className = "sampl/lang/SAMPL";
            if (kind == Function.Kind.NONSTATIC) {
                opcode = 182;
                this.emitEnvironmentRef();
            }
        }
        int i = 0;
        int n = args.size();
        while (i < n) {
            Expr arg = args.get(i);
            if (argTypes.charAt(i) == 'D') {
                this.emitNumeric(arg);
            } else {
                this.emit(arg);
            }
            ++i;
        }
        String desc = this.argsToDescriptor.get(argTypes);
        if (desc == null) {
            desc = "(";
            int i2 = 0;
            int n2 = argTypes.length();
            while (i2 < n2) {
                desc = String.valueOf(desc) + (argTypes.charAt(i2) == 'S' ? "Ljava/util/Set;" : "D");
                ++i2;
            }
            desc = String.valueOf(desc) + ")D";
            this.argsToDescriptor.put(argTypes, desc);
        }
        this.mv.visitMethodInsn(opcode, className, name, desc);
    }

    @Override
    public void visit(ParenExpr expr) {
        if (expr.getNumItems() == 1) {
            expr.getItem(0).accept(this);
        } else {
            this.emitTuple(expr.getItems());
        }
    }

    @Override
    public void visit(UnaryExpr expr) {
        Expr arg = expr.getArg();
        switch (expr.getKind()) {
            default: {
                assert (false) : "Invalid unary operator.";
            }
            case PLUS: {
                arg.accept(this);
                break;
            }
            case MINUS: {
                if (expr.hasNumericType()) {
                    this.emitNumeric(arg);
                    this.mv.visitInsn(119);
                    break;
                }
                this.mv.visitVarInsn(25, this.exprBuilderVars.top());
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(182, "sampl/lang/ExprBuilder", "neg", "()V");
                this.emitNumeric(arg);
                this.mv.visitMethodInsn(182, "sampl/lang/ExprBuilder", "neg", "()V");
                break;
            }
            case NOT: {
                this.emitLogical(arg);
                this.emitCondition(153);
            }
        }
    }

    @Override
    public void visit(BinaryExpr expr) {
        switch (expr.getKind()) {
            default: {
                assert (false) : "Invalid binary operator.";
            }
            case EXP: {
                this.emitArgs(expr);
                if (expr.hasNumericType()) {
                    this.mv.visitMethodInsn(184, "java/lang/Math", "pow", "(DD)D");
                    break;
                }
                this.mv.visitMethodInsn(184, "sampl/lang/BinaryExpr", "pow", this.getDescriptor(expr));
                break;
            }
            case MUL: {
                Expr lhs = expr.getLHS();
                Expr rhs = expr.getRHS();
                if (expr.hasNumericType()) {
                    this.emitNumber(lhs);
                    this.emitNumber(rhs);
                    this.mv.visitInsn(107);
                    break;
                }
                if (lhs.hasNumericOrSymbolicType()) {
                    this.emitScaled(lhs, rhs, "mul");
                    break;
                }
                if (rhs.hasNumericOrSymbolicType()) {
                    this.emitScaled(rhs, lhs, "mul");
                    break;
                }
                this.emitArgs(expr);
                this.mv.visitMethodInsn(184, "sampl/lang/BinaryExpr", "mul", this.getDescriptor(expr));
                break;
            }
            case DIV: {
                Expr lhs = expr.getLHS();
                Expr rhs = expr.getRHS();
                if (expr.hasNumericType()) {
                    this.emitNumber(lhs);
                    this.emitNumber(rhs);
                    this.mv.visitInsn(111);
                    break;
                }
                if (rhs.hasNumericOrSymbolicType()) {
                    this.emitScaled(rhs, lhs, "div");
                    break;
                }
                this.emitArgs(expr);
                this.mv.visitMethodInsn(184, "sampl/lang/BinaryExpr", "div", this.getDescriptor(expr));
                break;
            }
            case IDIV: {
                this.emitArgs(expr);
                this.mv.visitMethodInsn(184, "sampl/Util", "intdiv", "(DD)D");
                break;
            }
            case MOD: {
                this.emitArgs(expr);
                this.mv.visitInsn(115);
                break;
            }
            case ADD: {
                if (expr.hasNumericType()) {
                    this.emitNumber(expr.getLHS());
                    this.emitNumber(expr.getRHS());
                    this.mv.visitInsn(99);
                    break;
                }
                this.useExprBuilder = true;
                this.emitNumeric(expr.getLHS());
                this.emitNumeric(expr.getRHS());
                break;
            }
            case SUB: {
                if (expr.hasNumericType()) {
                    this.emitNumber(expr.getLHS());
                    this.emitNumber(expr.getRHS());
                    this.mv.visitInsn(103);
                    break;
                }
                this.useExprBuilder = true;
                this.emitNumeric(expr.getLHS());
                this.mv.visitVarInsn(25, this.exprBuilderVars.top());
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(182, "sampl/lang/ExprBuilder", "neg", "()V");
                this.useExprBuilder = true;
                this.emitNumeric(expr.getRHS());
                this.mv.visitMethodInsn(182, "sampl/lang/ExprBuilder", "neg", "()V");
                break;
            }
            case LESS: {
                this.emitArgs(expr);
                if (expr.hasNumericType()) {
                    this.mv.visitInsn(103);
                    this.mv.visitInsn(14);
                    this.mv.visitMethodInsn(184, "java/lang/Math", "max", "(DD)D");
                    break;
                }
                this.mv.visitMethodInsn(184, "sampl/lang/BinaryExpr", "less", this.getDescriptor(expr));
                break;
            }
            case UNION: {
                this.emitArgs(expr);
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "union", "(Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;");
                break;
            }
            case DIFF: {
                this.emitArgs(expr);
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "diff", "(Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;");
                break;
            }
            case SYMDIFF: {
                this.emitArgs(expr);
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "symdiff", "(Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;");
                break;
            }
            case CROSS: {
                this.emitArgs(expr);
                this.mv.visitLdcInsn((Object)expr.getLHS().getDimension());
                this.mv.visitLdcInsn((Object)expr.getRHS().getDimension());
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "cross", "(Ljava/util/Set;Ljava/util/Set;II)Ljava/util/Set;");
                break;
            }
            case CONCAT: {
                this.emitString(expr.getLHS());
                this.emitString(expr.getRHS());
                this.mv.visitMethodInsn(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
                break;
            }
            case IN: {
                expr.getRHS().accept(this);
                this.emitBoxed(expr.getLHS());
                this.mv.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z");
                this.emitCondition(154);
                break;
            }
            case NOTIN: {
                expr.getRHS().accept(this);
                this.emitBoxed(expr.getLHS());
                this.mv.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z");
                this.emitCondition(153);
                break;
            }
            case LT: {
                this.emitRelationalExpr(expr, 155);
                break;
            }
            case GT: {
                this.emitRelationalExpr(expr, 157);
                break;
            }
            case LE: {
                if (expr.hasLogicalType()) {
                    this.emitRelationalExpr(expr, 158);
                    break;
                }
                this.emitArgs(expr);
                this.mv.visitMethodInsn(184, "sampl/lang/BinaryExpr", "le", this.getDescriptor(expr));
                break;
            }
            case GE: {
                if (expr.hasLogicalType()) {
                    this.emitRelationalExpr(expr, 156);
                    break;
                }
                this.emitArgs(expr);
                this.mv.visitMethodInsn(184, "sampl/lang/BinaryExpr", "ge", this.getDescriptor(expr));
                break;
            }
            case EQ: {
                this.emitEqualityExpr(expr, 153);
                break;
            }
            case NE: {
                this.emitEqualityExpr(expr, 154);
                break;
            }
            case OR: {
                Label trueLabel = new Label();
                this.emitLogical(expr.getLHS());
                this.mv.visitJumpInsn(154, trueLabel);
                this.emitLogical(expr.getRHS());
                this.mv.visitJumpInsn(154, trueLabel);
                this.mv.visitInsn(3);
                Label endLabel = new Label();
                this.mv.visitJumpInsn(167, endLabel);
                this.mv.visitLabel(trueLabel);
                this.mv.visitInsn(4);
                this.mv.visitLabel(endLabel);
                break;
            }
            case AND: {
                Label falseLabel = new Label();
                this.emitLogical(expr.getLHS());
                this.mv.visitJumpInsn(153, falseLabel);
                this.emitLogical(expr.getRHS());
                this.mv.visitJumpInsn(153, falseLabel);
                this.mv.visitInsn(4);
                Label endLabel = new Label();
                this.mv.visitJumpInsn(167, endLabel);
                this.mv.visitLabel(falseLabel);
                this.mv.visitInsn(3);
                this.mv.visitLabel(endLabel);
            }
        }
    }

    @Override
    public void visit(RangeExpr expr) {
        this.mv.visitTypeInsn(187, "sampl/lang/Range");
        this.mv.visitInsn(89);
        this.emitNumeric(expr.getLHS());
        this.emitNumeric(expr.getRHS());
        Expr by = expr.getBy();
        if (by != null) {
            this.emitNumeric(by);
        }
        this.mv.visitMethodInsn(183, "sampl/lang/Range", "<init>", by != null ? "(DDD)V" : "(DD)V");
    }

    private void emitCallExpr(Expr arg) {
        this.mv.visitTypeInsn(187, "sampl/lang/CallExpr");
        this.mv.visitInsn(89);
        this.emit(arg);
        this.mv.visitMethodInsn(183, "sampl/lang/CallExpr", "<init>", "(Lsampl/lang/Expr;)V");
    }

    @Override
    public void visit(IteratedExpr expr) {
        Indexing indexing = expr.getIndexing();
        IndexingCompiler emitter = new IndexingCompiler(this, indexing);
        Expr arg = expr.getArg();
        switch (expr.getKind()) {
            default: {
                assert (false) : "Invalid iterated expression.";
            }
            case SUM: {
                if (expr.hasNumericType()) {
                    int result = this.getDoubleVarIndex();
                    this.mv.visitInsn(14);
                    this.mv.visitVarInsn(57, result);
                    emitter.start();
                    this.emitNumber(arg);
                    this.mv.visitVarInsn(24, result);
                    this.mv.visitInsn(99);
                    this.mv.visitVarInsn(57, result);
                    emitter.end();
                    this.mv.visitVarInsn(24, result);
                    break;
                }
                this.useExprBuilder = false;
                emitter.start();
                this.useExprBuilder = true;
                this.emitNumeric(arg);
                emitter.end();
                break;
            }
            case PROD: {
                int result = this.getDoubleVarIndex();
                this.mv.visitInsn(15);
                this.mv.visitVarInsn(57, result);
                emitter.start();
                this.emitNumeric(arg);
                this.mv.visitVarInsn(24, result);
                this.mv.visitInsn(107);
                this.mv.visitVarInsn(57, result);
                emitter.end();
                this.mv.visitVarInsn(24, result);
                break;
            }
            case MIN: {
                int result = this.getDoubleVarIndex();
                this.mv.visitLdcInsn((Object)Double.POSITIVE_INFINITY);
                this.mv.visitVarInsn(57, result);
                emitter.start();
                this.emitNumeric(arg);
                this.mv.visitVarInsn(24, result);
                this.mv.visitMethodInsn(184, "java/lang/Math", "min", "(DD)D");
                this.mv.visitVarInsn(57, result);
                emitter.end();
                this.mv.visitVarInsn(24, result);
                break;
            }
            case MAX: {
                int result = this.getDoubleVarIndex();
                this.mv.visitLdcInsn((Object)Double.NEGATIVE_INFINITY);
                this.mv.visitVarInsn(57, result);
                emitter.start();
                this.emitNumeric(arg);
                this.mv.visitVarInsn(24, result);
                this.mv.visitMethodInsn(184, "java/lang/Math", "max", "(DD)D");
                this.mv.visitVarInsn(57, result);
                emitter.end();
                this.mv.visitVarInsn(24, result);
                break;
            }
            case UNION: {
                int result = this.getVarIndex();
                this.mv.visitTypeInsn(187, "java/util/HashSet");
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(183, "java/util/HashSet", "<init>", "()V");
                this.mv.visitVarInsn(58, result);
                emitter.start();
                this.mv.visitVarInsn(25, result);
                arg.accept(this);
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "union", "(Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;");
                this.mv.visitVarInsn(58, result);
                emitter.end();
                this.mv.visitVarInsn(25, result);
                break;
            }
            case EXISTS: {
                this.mv.visitInsn(3);
                emitter.start();
                this.emitLogical(arg);
                this.mv.visitJumpInsn(153, emitter.getCheckLabel());
                this.mv.visitInsn(87);
                this.mv.visitInsn(4);
                Label end = new Label();
                this.mv.visitJumpInsn(167, end);
                emitter.end();
                this.mv.visitLabel(end);
                break;
            }
            case FORALL: {
                this.mv.visitInsn(4);
                emitter.start();
                this.emitLogical(arg);
                this.mv.visitJumpInsn(154, emitter.getCheckLabel());
                this.mv.visitInsn(87);
                this.mv.visitInsn(3);
                Label end = new Label();
                this.mv.visitJumpInsn(167, end);
                emitter.end();
                this.mv.visitLabel(end);
                break;
            }
            case SETOF: {
                int result = this.getVarIndex();
                this.mv.visitTypeInsn(187, "java/util/LinkedHashSet");
                this.mv.visitInsn(89);
                this.mv.visitInsn(89);
                this.mv.visitVarInsn(58, result);
                this.mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V");
                emitter.start();
                this.mv.visitVarInsn(25, result);
                this.emitBoxed(arg);
                this.mv.visitMethodInsn(182, "java/util/LinkedHashSet", "add", "(Ljava/lang/Object;)Z");
                this.mv.visitInsn(87);
                emitter.end();
                break;
            }
            case EXPECTATION: {
                if (expr.hasNumericType()) {
                    int result = this.getDoubleVarIndex();
                    this.mv.visitInsn(14);
                    this.mv.visitVarInsn(57, result);
                    emitter.start();
                    arg.accept(this);
                    this.emitScenarioProbability(emitter.getKeyVar());
                    this.mv.visitInsn(107);
                    this.mv.visitVarInsn(24, result);
                    this.mv.visitInsn(99);
                    this.mv.visitVarInsn(57, result);
                    emitter.end();
                    this.mv.visitVarInsn(24, result);
                    break;
                }
                this.emitCallExpr(arg);
                break;
            }
            case PROBABILITY: {
                assert (arg == null);
                if (expr.hasNumericType()) {
                    int result = this.getDoubleVarIndex();
                    this.mv.visitInsn(14);
                    this.mv.visitVarInsn(57, result);
                    emitter.start();
                    this.emitLogical(indexing.getCondition());
                    this.mv.visitJumpInsn(153, emitter.getCheckLabel());
                    this.mv.visitVarInsn(24, result);
                    this.emitScenarioProbability(emitter.getKeyVar());
                    this.mv.visitInsn(99);
                    this.mv.visitVarInsn(57, result);
                    emitter.end();
                    this.mv.visitVarInsn(24, result);
                    break;
                }
                this.emitCallExpr(indexing.getCondition());
            }
        }
    }

    @Override
    public void visit(IndexedExpr expr) {
        assert (false) : "Invalid expression.";
    }

    @Override
    public void visit(Indexing expr) {
        this.mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V");
        int set = this.getVarIndex();
        this.mv.visitVarInsn(58, set);
        IndexingCompiler emitter = new IndexingCompiler(this, expr);
        emitter.start();
        this.mv.visitVarInsn(25, set);
        this.mv.visitVarInsn(25, emitter.getKeyVar());
        if (expr.getNumParts() != 1) {
            this.mv.visitMethodInsn(182, "sampl/Tuple", "clone", "()Lsampl/Tuple;");
        }
        this.mv.visitMethodInsn(182, "java/util/LinkedHashSet", "add", "(Ljava/lang/Object;)Z");
        this.mv.visitInsn(87);
        emitter.end();
        this.mv.visitVarInsn(25, set);
    }

    @Override
    public void visit(ConditionalExpr expr) {
        boolean useEB = this.useExprBuilder;
        this.useExprBuilder = false;
        Type type = expr.getType();
        this.emitLogical(expr.getCondition());
        Label elseLabel = new Label();
        this.mv.visitJumpInsn(153, elseLabel);
        Expr thenExpr = expr.getThen();
        if (!useEB) {
            thenExpr.accept(this);
            this.convert(thenExpr.getType(), type);
        } else {
            this.useExprBuilder = true;
            this.emitNumeric(thenExpr);
        }
        Label endLabel = new Label();
        this.mv.visitJumpInsn(167, endLabel);
        this.mv.visitLabel(elseLabel);
        Expr elseExpr = expr.getElse();
        if (!useEB) {
            Type elseType;
            if (elseExpr != null) {
                elseType = elseExpr.getType();
                elseExpr.accept(this);
            } else {
                elseType = Types.NUMERIC;
                this.mv.visitInsn(14);
            }
            this.convert(elseType, type);
        } else if (elseExpr != null) {
            this.useExprBuilder = true;
            this.emitNumeric(elseExpr);
        }
        this.mv.visitLabel(endLabel);
    }

    @Override
    public void visit(DoubleInequalityExpr expr) {
        assert (false) : "Invalid expression.";
    }

    @Override
    public void visit(PiecewiseLinearExpr expr) {
        if (expr.hasNumericType()) {
            this.emitArray(expr.getBreakpoints());
            this.emitArray(expr.getSlopes());
            this.emitNumeric(expr.getArg());
            this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "piecewiseLinear", "([D[DD)D");
        } else {
            this.mv.visitTypeInsn(187, "sampl/lang/PiecewiseLinear");
            this.mv.visitInsn(89);
            this.emitArray(expr.getBreakpoints());
            this.emitArray(expr.getSlopes());
            expr.getArg().accept(this);
            this.mv.visitMethodInsn(183, "sampl/lang/PiecewiseLinear", "<init>", "([D[DLsampl/lang/Variable;)V");
        }
    }

    @Override
    public void visit(NetExpr expr) {
    }

    @Override
    public void visit(EmptyStmt stmt) {
    }

    @Override
    public void visit(BasicStmt stmt) {
        Expr arg = stmt.getArg();
        switch (stmt.getKind()) {
            default: {
                assert (false) : "Invalid statement.";
                break;
            }
            case MODEL: 
            case DATA: {
                break;
            }
            case RESET: {
                this.emitEnvironmentRef();
                this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "reset", "()V");
                break;
            }
            case SHELL: {
                this.emitEnvironmentRef();
                if (arg != null) {
                    this.emitString(arg);
                } else {
                    this.mv.visitInsn(1);
                }
                this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "shell", "(Ljava/lang/String;)V");
                break;
            }
            case SOLUTION: {
                this.emitEnvironmentRef();
                arg.accept(this);
                this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "solution", "(Ljava/lang/String;)V");
                break;
            }
            case SOLVE: {
                this.emitEnvironmentRef();
                if (arg != null) {
                    arg.accept(this);
                    if (arg.getType() == Types.OBJECTIVE) {
                        this.emitString(stmt.getFilename());
                        this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "solve", "(Lsampl/lang/Objective;Ljava/lang/String;)V");
                        break;
                    }
                } else {
                    this.mv.visitInsn(1);
                }
                this.emitString(stmt.getFilename());
                this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "solve", "(Lsampl/lang/Problem;Ljava/lang/String;)V");
                break;
            }
            case WRITE: {
                this.emitEnvironmentRef();
                if (arg != null) {
                    this.emitString(arg);
                } else {
                    this.mv.visitInsn(1);
                }
                this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "write", "(Ljava/lang/String;)V");
                break;
            }
            case PROBLEM: {
                this.emitEnvironmentRef();
                if (arg != null) {
                    arg.accept(this);
                } else {
                    this.mv.visitInsn(1);
                }
                this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "problem", "(Lsampl/lang/Problem;)V");
            }
        }
    }

    @Override
    public void visit(OptionStmt stmt) {
        List<Option> options = stmt.getOptions();
        if (options.isEmpty()) {
            this.emitEnvironmentRef();
            this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "option", "()V");
            return;
        }
        for (Option opt : options) {
            this.emitEnvironmentRef();
            Decl decl = opt.getDecl();
            if (decl != null) {
                this.emitEntityReference(decl);
            } else {
                this.mv.visitInsn(1);
            }
            this.mv.visitLdcInsn((Object)opt.getName().toString());
            Expr value = opt.getValue();
            if (value == null) {
                this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "option", "(Lsampl/lang/ProblemMap;Ljava/lang/String;)V");
                continue;
            }
            value.accept(this);
            if (value.hasNumericType()) {
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
            this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "option", "(Lsampl/lang/ProblemMap;Ljava/lang/String;Ljava/lang/Object;)V");
        }
    }

    @Override
    public void visit(CheckStmt stmt) {
        this.emitEnvironmentRef();
        this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "runChecks", "()V");
    }

    @Override
    public void visit(LetStmt stmt) {
        Expr lhs = stmt.getLHS();
        this.emitEntityReference(lhs.getTarget());
        this.mv.visitMethodInsn(182, "sampl/lang/Entity", "prepareForAssignment", "()V");
        Indexing indexing = stmt.getIndexing();
        IndexingCompiler emitter = null;
        if (indexing != null) {
            emitter = new IndexingCompiler(this, stmt.getIndexing());
            emitter.start();
        }
        this.emitLValue(lhs);
        Expr rhs = stmt.getRHS();
        rhs.accept(this);
        this.emitAssignment(rhs.getType(), false);
        if (indexing != null) {
            emitter.end();
        }
    }

    @Override
    public void visit(FixStmt stmt) {
        Expr lhs = stmt.getLHS();
        this.emitEntityReference(lhs.getTarget());
        this.mv.visitMethodInsn(182, "sampl/lang/Entity", "prepareForAssignment", "()V");
        Indexing indexing = stmt.getIndexing();
        IndexingCompiler emitter = null;
        if (indexing != null) {
            emitter = new IndexingCompiler(this, stmt.getIndexing());
            emitter.start();
        }
        if (lhs.getDimension() == 1) {
            this.emitEntityReference(lhs.getTarget());
        } else {
            this.emitLValue(lhs);
        }
        Expr rhs = null;
        if (stmt.getRHS() != null) {
            rhs = stmt.getRHS();
            rhs.accept(this);
        }
        if (lhs.getDimension() == 1) {
            this.emitVariableGlobalFixUnfix(true, rhs != null);
        } else {
            this.emitAssignment(rhs.getType(), false);
        }
        if (indexing != null) {
            emitter.end();
        }
    }

    @Override
    public void visit(IfStmt stmt) {
        this.emitLogical(stmt.getCondition());
        Label elseLabel = new Label();
        this.mv.visitJumpInsn(153, elseLabel);
        stmt.getThen().accept(this);
        Node elseStmt = stmt.getElse();
        if (elseStmt != null) {
            Label endLabel = new Label();
            this.mv.visitJumpInsn(167, endLabel);
            this.mv.visitLabel(elseLabel);
            stmt.getElse().accept(this);
            this.mv.visitLabel(endLabel);
        } else {
            this.mv.visitLabel(elseLabel);
        }
    }

    @Override
    public void visit(ForStmt stmt) {
        IndexingCompiler emitter = new IndexingCompiler(this, stmt.getIndexing());
        emitter.start();
        Label end = new Label();
        this.loops.put(stmt.getContext(), new Loop(emitter.getCheckLabel(), end));
        stmt.getBody().accept(this);
        emitter.end();
        this.mv.visitLabel(end);
    }

    @Override
    public void visit(RepeatStmt stmt) {
        Label start = new Label();
        this.mv.visitLabel(start);
        Condition pre = stmt.getPrecondition();
        Condition post = stmt.getPostcondition();
        Label check = post != null ? new Label() : start;
        Label end = new Label();
        this.loops.put(stmt.getContext(), new Loop(check, end));
        if (pre != null) {
            this.emitLogical(pre.expr);
            this.mv.visitJumpInsn(pre.until ? 154 : 153, end);
        }
        stmt.getBody().accept(this);
        if (post != null) {
            this.mv.visitLabel(check);
            this.emitLogical(post.expr);
            this.mv.visitJumpInsn(post.until ? 153 : 154, start);
        } else {
            this.mv.visitJumpInsn(167, start);
        }
        this.mv.visitLabel(end);
    }

    @Override
    public void visit(JumpStmt stmt) {
        Loop loop = this.loops.get(stmt.getTarget());
        this.mv.visitJumpInsn(167, stmt.isBreak() ? loop.end : loop.check);
    }

    @Override
    public void visit(CompoundStmt stmt) {
        for (Node node : stmt.getStmts()) {
            node.accept(this);
        }
    }

    @Override
    public void visit(OutputStmt stmt) {
        int writer = this.getVarIndex();
        Expr filename = stmt.getFilename();
        if (filename != null) {
            this.emitEnvironmentRef();
            this.emitString(filename);
            this.mv.visitInsn(stmt.isAppending() ? 4 : 3);
            this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "getWriter", "(Ljava/lang/String;Z)Ljava/io/PrintWriter;");
            this.mv.visitVarInsn(58, writer);
        } else {
            this.emitEnvironmentRef();
            this.mv.visitFieldInsn(180, "sampl/lang/SAMPL", "out", "Ljava/io/PrintWriter;");
            this.mv.visitVarInsn(58, writer);
        }
        Indexing indexing = stmt.getIndexing();
        IndexingCompiler emitter = null;
        if (indexing != null) {
            emitter = new IndexingCompiler(this, indexing);
            emitter.start();
        }
        List<Expr> args = stmt.getArgs();
        switch (stmt.getKind()) {
            default: {
                assert (false) : "Invalid statement.";
            }
            case DISPLAY: {
                this.emitDisplayArgs(args, writer);
                break;
            }
            case PRINT: {
                this.emitPrintArgs(args, writer);
                break;
            }
            case PRINTF: {
                this.emitPrintfArgs(args, writer);
                break;
            }
            case EXPAND: {
                this.emitExpandArgs(args, writer);
                break;
            }
            case XREF: {
                this.emitXrefArgs(args, writer);
            }
        }
        if (indexing != null) {
            emitter.end();
        }
    }

    @Override
    public void visit(ReadStmt stmt) {
        int reader = this.getVarIndex();
        Expr filename = stmt.getFilename();
        this.emitEnvironmentRef();
        if (filename != null) {
            this.emitString(filename);
            this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", "getReader", "(Ljava/lang/String;)Ljava/io/BufferedReader;");
            this.mv.visitVarInsn(58, reader);
        } else {
            this.mv.visitFieldInsn(180, "sampl/lang/SAMPL", "in", "Ljava/io/BufferedReader;");
            this.mv.visitVarInsn(58, reader);
        }
        for (Expr arg : stmt.getArgs()) {
            this.emitEntityReference(arg.getTarget());
            this.mv.visitMethodInsn(182, "sampl/lang/Entity", "prepareForAssignment", "()V");
        }
        Indexing indexing = stmt.getIndexing();
        IndexingCompiler emitter = null;
        if (indexing != null) {
            emitter = new IndexingCompiler(this, indexing);
            emitter.start();
        }
        for (Expr arg : stmt.getArgs()) {
            this.emitLValue(arg);
            this.mv.visitVarInsn(25, reader);
            if (arg.hasNumericType()) {
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "readNumeric", "(Ljava/io/BufferedReader;)D");
            } else {
                this.mv.visitMethodInsn(184, "sampl/lang/SAMPL", "readSymbolic", "(Ljava/io/BufferedReader;)Ljava/lang/Object;");
            }
            this.emitAssignment(arg.getType(), false);
        }
        if (indexing != null) {
            emitter.end();
        }
    }

    @Override
    public void visit(TableIOStmt stmt) {
        this.emitEnvironmentRef();
        Expr ref = stmt.getReference();
        ref.accept(this);
        String descriptor = ref.getType() == Types.TABLE ? "Lsampl/lang/Table;" : "Lsampl/lang/TableMap;";
        this.mv.visitMethodInsn(182, "sampl/lang/SAMPL", stmt.isWrite() ? "write" : "read", "(" + descriptor + ")V");
    }

    @Override
    public void visit(Option opt) {
    }

    private static class IntStack {
        private int[] items = new int[8];
        private int size;

        private IntStack() {
        }

        public void push(int value) {
            if (this.size == this.items.length) {
                this.items = Arrays.copyOf(this.items, this.items.length * 2);
            }
            this.items[this.size++] = value;
        }

        public void pop() {
            --this.size;
        }

        public int top() {
            return this.items[this.size - 1];
        }
    }

    private static class Loop {
        Label check;
        Label end;

        Loop(Label check, Label end) {
            this.check = check;
            this.end = end;
        }
    }
}

