/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;
import sampl.DiagnosticException;
import sampl.DiagnosticHandler;
import sampl.SAMPLException;
import sampl.Source;
import sampl.ast.ParameterDecl;
import sampl.ast.SetDecl;
import sampl.ast.Stmt;
import sampl.codegen.AbstractASTCompiler;
import sampl.lang.Block;
import sampl.lang.DataSetter;
import sampl.lang.Parameter;
import sampl.lang.SAMPL;

public final class Interpreter
extends AbstractASTCompiler {
    private SAMPL sampl;
    private Source source;
    private DiagnosticHandler handler;
    private boolean run;
    private boolean dumpBytecode;
    private Map<String, Class<?>> classes = new HashMap();
    private DataSetter dataSetter;
    private DynamicClassLoader loader;

    private void runLastBlock(int pos) {
        String className = this.endBlock();
        if (!this.run || className == null) {
            return;
        }
        Class<?> cls = this.classes.get(className);
        try {
            ((Block)cls.newInstance()).execute(this.sampl);
        }
        catch (SAMPLException e) {
            this.handler.diagnostic(new DiagnosticException(e.getMessage(), this.source, pos));
        }
        catch (Exception e) {
            StringWriter trace = new StringWriter();
            e.printStackTrace(new PrintWriter(trace));
            this.handler.diagnostic(new DiagnosticException(trace.toString(), this.source, pos));
        }
        this.sampl.out.flush();
    }

    @Override
    protected ClassVisitor getClassVisitor() {
        ClassWriter cv = new ClassWriter(2){
            private String name;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.name = name.replace('/', '.');
            }

            public void visitEnd() {
                super.visitEnd();
                if (Interpreter.this.run) {
                    Interpreter.this.classes.put(this.name, Interpreter.this.loader.defineClass(this.name, this.toByteArray()));
                }
            }
        };
        return this.dumpBytecode ? new TraceClassVisitor((ClassVisitor)cv, new PrintWriter(System.out)) : cv;
    }

    public Interpreter(SAMPL env, DiagnosticHandler handler, boolean run, boolean dumpBytecode) throws SAMPLException {
        this.sampl = env;
        env.setResetHandler(new Runnable(){

            @Override
            public void run() {
                Interpreter.this.loader = new DynamicClassLoader();
                Interpreter.this.classes.clear();
            }
        });
        this.handler = handler;
        this.run = run;
        this.dumpBytecode = dumpBytecode;
        this.loader = new DynamicClassLoader();
        this.dataSetter = new DataSetter(this.sampl);
    }

    @Override
    public void onSourceSwitch(Source s) {
        this.source = s;
    }

    @Override
    public void onTopLevelStmt(Stmt stmt) {
        super.onTopLevelStmt(stmt);
        this.runLastBlock(stmt.getStart());
    }

    @Override
    public void onSourcesEnd() {
        this.runLastBlock(0);
    }

    @Override
    public void onDataStart(SetDecl decl, Object key) {
        this.runLastBlock(0);
        this.dataSetter.enterData(decl.getName(), key);
    }

    @Override
    public void onDataStart(ParameterDecl[] decls) {
        Parameter[] params = new Parameter[decls.length];
        int i = 0;
        while (i < decls.length) {
            params[i] = (Parameter)this.sampl.getEntity(decls[i].getName());
            params[i].prepareForData();
            ++i;
        }
        this.dataSetter.enterData(params);
    }

    @Override
    public void onKey(Object key) {
        this.dataSetter.addKey(key);
    }

    @Override
    public void onData(Object value) {
        this.dataSetter.addData(value);
    }

    @Override
    public void onDefaultData(Object value) {
        this.dataSetter.setDefaultData(value);
    }

    @Override
    public void onData(Object key, Object value, int index) {
        this.dataSetter.addData(key, value, index);
    }

    private static class DynamicClassLoader
    extends ClassLoader {
        private DynamicClassLoader() {
        }

        Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

