/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.types.Type;

public class UnaryExpr
extends Expr {
    private Kind kind;
    private Expr arg;

    public UnaryExpr(int start, Type type, Kind kind, Expr arg) {
        super(start, arg.getEnd(), type);
        this.kind = kind;
        this.arg = arg;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Expr getArg() {
        return this.arg;
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append((Object)this.kind);
        this.arg.format(sb);
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public static enum Kind {
        PLUS("+"),
        MINUS("-"),
        NOT("!");

        private String op;

        private Kind(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

