/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.ast.Referable;
import sampl.ast.Suffix;
import sampl.types.Type;

public class SuffixExpr
extends Expr {
    private Expr reference;
    private Suffix suffix;

    public SuffixExpr(int end, Type type, Expr reference, Suffix suffix) {
        super(reference.getStart(), end, type);
        this.reference = reference;
        this.suffix = suffix;
    }

    public Expr getReference() {
        return this.reference;
    }

    public Suffix getSuffix() {
        return this.suffix;
    }

    @Override
    public Referable getTarget() {
        return this.reference.getTarget();
    }

    @Override
    public boolean isAssignable() {
        return this.suffix.isAssignable();
    }

    @Override
    public void format(StringBuilder sb) {
        this.reference.format(sb);
        sb.append('.');
        sb.append(this.suffix.getName());
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

