/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import java.util.List;
import sampl.ast.Decl;
import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.types.MapType;
import sampl.types.Type;

public class SubscriptExpr
extends Expr {
    private Decl decl;
    private List<Expr> subscripts;

    public SubscriptExpr(int start, int end, Type type, Decl decl, List<Expr> subscripts) {
        super(start, end, type);
        this.decl = decl;
        this.subscripts = subscripts;
    }

    public int getNumSubscripts() {
        return this.subscripts.size();
    }

    public List<Expr> getSubscripts() {
        return this.subscripts;
    }

    public Expr getSubscript(int index) {
        return this.subscripts.get(index);
    }

    @Override
    public Decl getTarget() {
        return this.decl;
    }

    @Override
    public Type getOriginalType() {
        return ((MapType)this.decl.getType()).getValueType();
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append(this.decl.getName());
        sb.append('[');
        SubscriptExpr.formatList(sb, this.subscripts);
        sb.append(']');
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

