/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.types.Type;

public class RangeExpr
extends Expr {
    private Expr lhs;
    private Expr rhs;
    private Expr by;

    public RangeExpr(Type type, Expr lhs, Expr rhs, Expr by) {
        super(lhs.getStart(), (by != null ? by : rhs).getEnd(), type);
        this.lhs = lhs;
        this.rhs = rhs;
        this.by = by;
    }

    public Expr getLHS() {
        return this.lhs;
    }

    public Expr getRHS() {
        return this.rhs;
    }

    public Expr getBy() {
        return this.by;
    }

    @Override
    public void format(StringBuilder sb) {
        this.lhs.format(sb);
        sb.append(" .. ");
        this.rhs.format(sb);
        if (this.by == null) {
            return;
        }
        sb.append(" by ");
        this.by.format(sb);
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

