/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import java.util.List;
import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.types.Type;

public class PiecewiseLinearExpr
extends Expr {
    private List<Expr> breakpoints;
    private List<Expr> slopes;
    private Expr arg;

    public PiecewiseLinearExpr(int start, int end, Type type, List<Expr> breakpoints, List<Expr> slopes, Expr arg) {
        super(start, end, type);
        this.breakpoints = breakpoints;
        this.slopes = slopes;
        this.arg = arg;
    }

    public List<Expr> getBreakpoints() {
        return this.breakpoints;
    }

    public List<Expr> getSlopes() {
        return this.slopes;
    }

    public Expr getArg() {
        return this.arg;
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append("<<");
        PiecewiseLinearExpr.formatList(sb, this.breakpoints);
        sb.append("; ");
        PiecewiseLinearExpr.formatList(sb, this.slopes);
        sb.append(">> ");
        this.arg.format(sb);
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

