/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;

public class NetExpr
extends Expr {
    private Kind kind;
    private Expr expr;

    public NetExpr(int start, Kind kind, Expr expr) {
        super(start, expr != null ? expr.getEnd() : start + kind.toString().length() - 1, null);
        this.kind = kind;
        this.expr = expr;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Expr getExpr() {
        return this.expr;
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append(this.kind.toString().toLowerCase());
        if (this.expr == null) {
            return;
        }
        sb.append(" + ");
        this.expr.format(sb);
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public static enum Kind {
        NET_IN,
        NET_OUT,
        TO_COME;

    }
}

