/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.ast.Indexing;
import sampl.types.Type;

public class IteratedExpr
extends Expr {
    private Kind kind;
    private Indexing indexing;
    private Expr arg;

    public IteratedExpr(int start, Type type, Kind kind, Indexing indexing, Expr arg) {
        super(start, (arg != null ? arg : indexing).getEnd(), type);
        this.kind = kind;
        this.indexing = indexing;
        this.arg = arg;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Indexing getIndexing() {
        return this.indexing;
    }

    public Expr getArg() {
        return this.arg;
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append(this.kind.toString().toLowerCase());
        this.indexing.format(sb);
        if (this.arg != null) {
            sb.append(' ');
            this.arg.format(sb);
        }
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public static enum Kind {
        SUM,
        PROD,
        MIN,
        MAX,
        UNION,
        EXISTS,
        FORALL,
        SETOF,
        EXPECTATION,
        PROBABILITY;

    }
}

