/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import java.util.List;
import sampl.ast.ASTVisitor;
import sampl.ast.ExprVisitor;
import sampl.ast.Indexing;
import sampl.ast.Node;
import sampl.ast.Referable;
import sampl.types.MapType;
import sampl.types.Type;
import sampl.types.Types;

public abstract class Expr
extends Node {
    private Type type;
    public static final Indexing INVALID = new Indexing(-1, -1, null, null, null);

    static void formatList(StringBuilder sb, List<Expr> exprs) {
        if (exprs.isEmpty()) {
            return;
        }
        exprs.get(0).format(sb);
        int i = 1;
        while (i < exprs.size()) {
            sb.append(", ");
            exprs.get(i).format(sb);
            ++i;
        }
    }

    public Expr(int start, int end, Type t) {
        super(start, end);
        this.type = t;
    }

    public final Type getType() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
    }

    public final boolean hasNumericType() {
        return this.type == Types.NUMERIC;
    }

    public final boolean hasNumericOrSymbolicType() {
        return this.type == Types.NUMERIC || this.type == Types.SYMBOLIC;
    }

    public final boolean hasLogicalType() {
        return this.type == Types.LOGICAL;
    }

    public final boolean hasMapType() {
        return this.type instanceof MapType;
    }

    public final int getDimension() {
        return this.type.getDimension();
    }

    public Referable getTarget() {
        return null;
    }

    public Type getOriginalType() {
        return this.type;
    }

    public boolean isAssignable() {
        return false;
    }

    public abstract void format(StringBuilder var1);

    public abstract void accept(ExprVisitor var1);

    @Override
    public final void accept(ASTVisitor visitor) {
        this.accept((ExprVisitor)visitor);
    }
}

