/*
 * Decompiled with CFR 0.152.
 */
package sampl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Source {
    private String name;
    private Reader reader;
    private List<Integer> lineStarts = new ArrayList<Integer>();

    public Source(String name, Reader reader) {
        this.name = name;
        this.reader = reader;
        this.lineStarts.add(0);
    }

    public static Source newStringSource(String name, String input) {
        return new Source(name, new StringReader(input));
    }

    public static Source newFileSource(String filename) throws IOException {
        return new Source(filename, new InputStreamReader(new FileInputStream(filename)));
    }

    public String getName() {
        return this.name;
    }

    public Reader getReader() {
        return this.reader;
    }

    public int getLineNumber(int offset) {
        int lineNumber = Collections.binarySearch(this.lineStarts, offset);
        return lineNumber >= 0 ? lineNumber + 1 : -lineNumber - 1;
    }

    public int getColumnNumber(int offset, int lineNumber) {
        return offset - this.lineStarts.get(lineNumber - 1) + 1;
    }

    public void endLine(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative line length");
        }
        this.lineStarts.add(this.lineStarts.get(this.lineStarts.size() - 1) + length);
    }
}

