/*
 * Decompiled with CFR 0.152.
 */
package sampl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import sampl.Environment;
import sampl.LicenseException;

public final class License {
    private Key key;
    private boolean isTemp;
    private String message;
    private String hostname;
    private int lbits;
    private int mbits;
    private String directory;
    static final int MOD = 10000;

    private static long uint(long n) {
        return n & 0xFFFFFFFFL;
    }

    private static void decrypt(int index, int[] v, int[] w, int[] k) {
        long y = License.uint(v[index]);
        long z = License.uint(v[index + 1]);
        long sum = 3337565984L;
        long delta = 2654435769L;
        int n = 32;
        while (n-- > 0) {
            z = License.uint(z - ((y << 4 ^ y >> 5) + y ^ sum + (long)k[(int)(sum >> 11 & 3L)]));
            sum = License.uint(sum - delta);
            y = License.uint(y - ((z << 4 ^ z >> 5) + z ^ sum + (long)k[(int)(sum & 3L)]));
        }
        w[index] = (int)y;
        w[index + 1] = (int)z;
    }

    public License(String dir, Environment env) throws LicenseException {
        try {
            Reader reader = new Reader();
            try {
                if (!reader.tryOpen(dir) && !reader.tryOpen(env.getVariable("LICFORTMP"))) {
                    reader.open(env.getWorkingDir());
                }
                reader.read();
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            if (dir != null) {
                throw new LicenseException("License not found in the specified directory:\n" + dir);
            }
            throw new LicenseException(e);
        }
    }

    public boolean isTemporary() {
        return this.isTemp;
    }

    public String getMessage() {
        return this.message;
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getLBits() {
        return this.lbits;
    }

    public int getMBits() {
        return this.mbits;
    }

    public boolean hasExpired() {
        Key testKey = new Key(new Random(), true);
        if (this.key.year < testKey.year) {
            return true;
        }
        if (this.key.year == testKey.year) {
            if (this.key.month < testKey.month) {
                return true;
            }
            if (this.key.month == testKey.month && this.key.day < testKey.day) {
                return true;
            }
        }
        return false;
    }

    public Date getExpiryDate() {
        Key zeroKey = new Key(new Random(), false);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set((this.key.year - zeroKey.year) / 3, (this.key.month - zeroKey.month) / 3 - 1, (this.key.day - zeroKey.day) / 3);
        return calendar.getTime();
    }

    public String getDirectory() {
        return this.directory;
    }

    private class Key {
        int version;
        int year;
        int month;
        int day;
        static final int NUM_BITS = 31;
        int[] keysequence = new int[31];

        Key() {
        }

        Key(Random random, boolean currentDate) {
            if (currentDate) {
                GregorianCalendar calendar = new GregorianCalendar();
                this.year = calendar.get(1);
                this.month = calendar.get(2) + 1;
                this.day = calendar.get(5);
            }
            this.version = 0;
            String VERSION = "FortMP_ver3.2";
            int i = 0;
            while (i < "FortMP_ver3.2".length()) {
                this.version += "FortMP_ver3.2".charAt(i) * 3;
                ++i;
            }
            random.srand(this.version);
            i = 0;
            while (i < 31) {
                this.keysequence[i] = random.rand() % 10000;
                ++i;
            }
            this.year = this.year * 3 + random.rand() % 10000;
            this.month = this.month * 3 + random.rand() % 10000;
            this.day = this.day * 3 + random.rand() % 10000;
            if (this.day % 3 == 0) {
                ++this.day;
            }
        }
    }

    private static class Random {
        private int next;

        private Random() {
        }

        void srand(int seed) {
            this.next = seed;
        }

        int rand() {
            this.next = this.next * 214013 + 2531011;
            return (this.next >>> 16) % 32768;
        }
    }

    private class Reader {
        private InputStream in;
        private byte[] buffer = new byte[4];
        private Random random = new Random();

        private int readInt() throws IOException, LicenseException {
            int numRead = this.in.read(this.buffer);
            if (numRead < 4) {
                throw new LicenseException(License.this.getDirectory(), "Invalid license");
            }
            return this.buffer[0] & 0xFF | (this.buffer[1] & 0xFF) << 8 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[3] & 0xFF) << 24;
        }

        private String readEncryptedString() throws IOException, LicenseException {
            int length = this.readInt();
            int[] encrypted = new int[length / 4];
            int i = 0;
            while (i < length / 4) {
                encrypted[i] = this.readInt();
                ++i;
            }
            int KEY = 43981;
            int[] key = new int[]{43981, 43981, 43981, 43981};
            int[] nonEncrypted = new int[length];
            int i2 = 0;
            while (i2 < length / 4) {
                License.decrypt(i2, encrypted, nonEncrypted, key);
                i2 += 2;
            }
            String str = new String();
            int i3 = 0;
            while (i3 < length) {
                str = String.valueOf(str) + (char)(nonEncrypted[i3 / 4] >>> i3 % 4 * 8 & 0xFF);
                ++i3;
            }
            return str.trim();
        }

        private String readNonEncryptedString() throws LicenseException, IOException {
            int length = this.readInt();
            if (length == 0) {
                return null;
            }
            byte[] b = new byte[length];
            int n = this.in.read(b);
            if (n != length) {
                throw new LicenseException(License.this.getDirectory(), "Invalid license");
            }
            String decoded = new String(b, "UTF-8");
            return decoded;
        }

        private void open(String dir) throws FileNotFoundException {
            File file = new File(dir, "LICENCE.KEY");
            this.in = new BufferedInputStream(new FileInputStream(file));
            License.this.directory = file.getParent();
        }

        boolean tryOpen(String dir) {
            try {
                if (dir != null) {
                    this.open(dir);
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return false;
        }

        Reader() {
        }

        void close() throws IOException {
            if (this.in != null) {
                this.in.close();
            }
        }

        void read() throws LicenseException, IOException {
            Key testKey = new Key(this.random, true);
            License.this.key = new Key();
            ((License)License.this).key.version = this.readInt();
            ((License)License.this).key.year = this.readInt();
            ((License)License.this).key.month = this.readInt();
            ((License)License.this).key.day = this.readInt();
            int i = 0;
            while (i < 31) {
                ((License)License.this).key.keysequence[i] = this.readInt();
                ++i;
            }
            if (((License)License.this).key.day % 3 != 0) {
                ((License)License.this).key.version ^= 0x155;
            }
            if (((License)License.this).key.version != testKey.version) {
                throw new LicenseException(License.this.getDirectory(), "License not valid for this version of software");
            }
            if (((License)License.this).key.day % 3 == 0) {
                this.random.srand(((License)License.this).key.version);
                i = 0;
                while (i < 31) {
                    this.random.rand();
                    ++i;
                }
                ((License)License.this).key.year += this.random.rand() % 10000;
                ((License)License.this).key.month += this.random.rand() % 10000;
                ((License)License.this).key.day += this.random.rand() % 10000;
                if (((License)License.this).key.day % 3 == 0) {
                    ++((License)License.this).key.day;
                }
            }
            int pow2i = 1;
            int tempLBits = 0;
            int tempMBits = 0;
            int i2 = 0;
            while (i2 < 31) {
                int diff = ((License)License.this).key.keysequence[i2] - testKey.keysequence[i2];
                switch (diff) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        tempMBits += pow2i;
                        break;
                    }
                    case 2: {
                        tempLBits += pow2i;
                        break;
                    }
                    case 3: {
                        tempLBits += pow2i;
                        tempMBits += pow2i;
                        break;
                    }
                    default: {
                        throw new LicenseException(License.this.getDirectory(), "Invalid license bits");
                    }
                }
                pow2i *= 2;
                ++i2;
            }
            int VERSION_SIZE = 80;
            this.in.skip(80L);
            long licenseID = Long.parseLong(this.readEncryptedString());
            License.this.hostname = this.readNonEncryptedString();
            License.this.message = this.readEncryptedString();
            License.this.isTemp = licenseID == 19781206L;
            License.this.lbits = tempLBits;
            License.this.mbits = tempMBits;
        }
    }
}

